// Compiled by ClojureScript 1.9.946 {}
goog.provide('re_frame.fx');
goog.require('cljs.core');
goog.require('re_frame.router');
goog.require('re_frame.db');
goog.require('re_frame.interceptor');
goog.require('re_frame.interop');
goog.require('re_frame.events');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
re_frame.fx.kind = new cljs.core.Keyword(null,"fx","fx",-1237829572);
if(cljs.core.truth_(re_frame.registrar.kinds.call(null,re_frame.fx.kind))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * Register the given effect `handler` for the given `id`.
 * 
 *   `id` is keyword, often namespaced.
 *   `handler` is a side-effecting function which takes a single argument and whose return
 *   value is ignored.
 * 
 *   Example Use
 *   -----------
 * 
 *   First, registration ... associate `:effect2` with a handler.
 * 
 *   (reg-fx
 *   :effect2
 *   (fn [value]
 *      ... do something side-effect-y))
 * 
 *   Then, later, if an event handler were to return this effects map ...
 * 
 *   {...
 * :effect2  [1 2]}
 * 
 * ... then the `handler` `fn` we registered previously, using `reg-fx`, will be
 * called with an argument of `[1 2]`.
 */
re_frame.fx.reg_fx = (function re_frame$fx$reg_fx(id,handler){
return re_frame.registrar.register_handler.call(null,re_frame.fx.kind,id,handler);
});
/**
 * An interceptor whose `:after` actions the contents of `:effects`. As a result,
 *   this interceptor is Domino 3.
 * 
 *   This interceptor is silently added (by reg-event-db etc) to the front of
 *   interceptor chains for all events.
 * 
 *   For each key in `:effects` (a map), it calls the registered `effects handler`
 *   (see `reg-fx` for registration of effect handlers).
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 * 
 *   it will call the registered effect handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`. When calling each handler, provides the map
 *   value for that key - so in the example above the effect handler for :dispatch
 *   will be given one arg `[:hello 42]`.
 * 
 *   You cannot rely on the ordering in which effects are executed.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"do-fx","do-fx",1194163050),new cljs.core.Keyword(null,"after","after",594996914),(function re_frame$fx$do_fx_after(context){
var seq__16057 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__16058 = null;
var count__16059 = (0);
var i__16060 = (0);
while(true){
if((i__16060 < count__16059)){
var vec__16061 = cljs.core._nth.call(null,chunk__16058,i__16060);
var effect_key = cljs.core.nth.call(null,vec__16061,(0),null);
var effect_value = cljs.core.nth.call(null,vec__16061,(1),null);
var temp__5455__auto___16067 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___16067)){
var effect_fn_16068 = temp__5455__auto___16067;
effect_fn_16068.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect: \"",effect_key,"\". Ignoring.");
}

var G__16069 = seq__16057;
var G__16070 = chunk__16058;
var G__16071 = count__16059;
var G__16072 = (i__16060 + (1));
seq__16057 = G__16069;
chunk__16058 = G__16070;
count__16059 = G__16071;
i__16060 = G__16072;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__16057);
if(temp__5457__auto__){
var seq__16057__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__16057__$1)){
var c__9713__auto__ = cljs.core.chunk_first.call(null,seq__16057__$1);
var G__16073 = cljs.core.chunk_rest.call(null,seq__16057__$1);
var G__16074 = c__9713__auto__;
var G__16075 = cljs.core.count.call(null,c__9713__auto__);
var G__16076 = (0);
seq__16057 = G__16073;
chunk__16058 = G__16074;
count__16059 = G__16075;
i__16060 = G__16076;
continue;
} else {
var vec__16064 = cljs.core.first.call(null,seq__16057__$1);
var effect_key = cljs.core.nth.call(null,vec__16064,(0),null);
var effect_value = cljs.core.nth.call(null,vec__16064,(1),null);
var temp__5455__auto___16077 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___16077)){
var effect_fn_16078 = temp__5455__auto___16077;
effect_fn_16078.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect: \"",effect_key,"\". Ignoring.");
}

var G__16079 = cljs.core.next.call(null,seq__16057__$1);
var G__16080 = null;
var G__16081 = (0);
var G__16082 = (0);
seq__16057 = G__16079;
chunk__16058 = G__16080;
count__16059 = G__16081;
i__16060 = G__16082;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch-later","dispatch-later",291951390),(function (value){
var seq__16083 = cljs.core.seq.call(null,value);
var chunk__16084 = null;
var count__16085 = (0);
var i__16086 = (0);
while(true){
if((i__16086 < count__16085)){
var map__16087 = cljs.core._nth.call(null,chunk__16084,i__16086);
var map__16087__$1 = ((((!((map__16087 == null)))?((((map__16087.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16087.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16087):map__16087);
var effect = map__16087__$1;
var ms = cljs.core.get.call(null,map__16087__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.call(null,map__16087__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if((cljs.core.empty_QMARK_.call(null,dispatch)) || (!(typeof ms === 'number'))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-later value:",effect);
} else {
re_frame.interop.set_timeout_BANG_.call(null,((function (seq__16083,chunk__16084,count__16085,i__16086,map__16087,map__16087__$1,effect,ms,dispatch){
return (function (){
return re_frame.router.dispatch.call(null,dispatch);
});})(seq__16083,chunk__16084,count__16085,i__16086,map__16087,map__16087__$1,effect,ms,dispatch))
,ms);
}

var G__16091 = seq__16083;
var G__16092 = chunk__16084;
var G__16093 = count__16085;
var G__16094 = (i__16086 + (1));
seq__16083 = G__16091;
chunk__16084 = G__16092;
count__16085 = G__16093;
i__16086 = G__16094;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__16083);
if(temp__5457__auto__){
var seq__16083__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__16083__$1)){
var c__9713__auto__ = cljs.core.chunk_first.call(null,seq__16083__$1);
var G__16095 = cljs.core.chunk_rest.call(null,seq__16083__$1);
var G__16096 = c__9713__auto__;
var G__16097 = cljs.core.count.call(null,c__9713__auto__);
var G__16098 = (0);
seq__16083 = G__16095;
chunk__16084 = G__16096;
count__16085 = G__16097;
i__16086 = G__16098;
continue;
} else {
var map__16089 = cljs.core.first.call(null,seq__16083__$1);
var map__16089__$1 = ((((!((map__16089 == null)))?((((map__16089.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16089.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16089):map__16089);
var effect = map__16089__$1;
var ms = cljs.core.get.call(null,map__16089__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.call(null,map__16089__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if((cljs.core.empty_QMARK_.call(null,dispatch)) || (!(typeof ms === 'number'))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-later value:",effect);
} else {
re_frame.interop.set_timeout_BANG_.call(null,((function (seq__16083,chunk__16084,count__16085,i__16086,map__16089,map__16089__$1,effect,ms,dispatch,seq__16083__$1,temp__5457__auto__){
return (function (){
return re_frame.router.dispatch.call(null,dispatch);
});})(seq__16083,chunk__16084,count__16085,i__16086,map__16089,map__16089__$1,effect,ms,dispatch,seq__16083__$1,temp__5457__auto__))
,ms);
}

var G__16099 = cljs.core.next.call(null,seq__16083__$1);
var G__16100 = null;
var G__16101 = (0);
var G__16102 = (0);
seq__16083 = G__16099;
chunk__16084 = G__16100;
count__16085 = G__16101;
i__16086 = G__16102;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),(function (value){
if(!(cljs.core.vector_QMARK_.call(null,value))){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value);
} else {
return re_frame.router.dispatch.call(null,value);
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),(function (value){
if(!(cljs.core.sequential_QMARK_.call(null,value))){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-n value. Expected a collection, got got:",value);
} else {
var seq__16103 = cljs.core.seq.call(null,cljs.core.remove.call(null,cljs.core.nil_QMARK_,value));
var chunk__16104 = null;
var count__16105 = (0);
var i__16106 = (0);
while(true){
if((i__16106 < count__16105)){
var event = cljs.core._nth.call(null,chunk__16104,i__16106);
re_frame.router.dispatch.call(null,event);

var G__16107 = seq__16103;
var G__16108 = chunk__16104;
var G__16109 = count__16105;
var G__16110 = (i__16106 + (1));
seq__16103 = G__16107;
chunk__16104 = G__16108;
count__16105 = G__16109;
i__16106 = G__16110;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__16103);
if(temp__5457__auto__){
var seq__16103__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__16103__$1)){
var c__9713__auto__ = cljs.core.chunk_first.call(null,seq__16103__$1);
var G__16111 = cljs.core.chunk_rest.call(null,seq__16103__$1);
var G__16112 = c__9713__auto__;
var G__16113 = cljs.core.count.call(null,c__9713__auto__);
var G__16114 = (0);
seq__16103 = G__16111;
chunk__16104 = G__16112;
count__16105 = G__16113;
i__16106 = G__16114;
continue;
} else {
var event = cljs.core.first.call(null,seq__16103__$1);
re_frame.router.dispatch.call(null,event);

var G__16115 = cljs.core.next.call(null,seq__16103__$1);
var G__16116 = null;
var G__16117 = (0);
var G__16118 = (0);
seq__16103 = G__16115;
chunk__16104 = G__16116;
count__16105 = G__16117;
i__16106 = G__16118;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"deregister-event-handler","deregister-event-handler",-1096518994),(function (value){
var clear_event = cljs.core.partial.call(null,re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_.call(null,value)){
var seq__16119 = cljs.core.seq.call(null,value);
var chunk__16120 = null;
var count__16121 = (0);
var i__16122 = (0);
while(true){
if((i__16122 < count__16121)){
var event = cljs.core._nth.call(null,chunk__16120,i__16122);
clear_event.call(null,event);

var G__16123 = seq__16119;
var G__16124 = chunk__16120;
var G__16125 = count__16121;
var G__16126 = (i__16122 + (1));
seq__16119 = G__16123;
chunk__16120 = G__16124;
count__16121 = G__16125;
i__16122 = G__16126;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__16119);
if(temp__5457__auto__){
var seq__16119__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__16119__$1)){
var c__9713__auto__ = cljs.core.chunk_first.call(null,seq__16119__$1);
var G__16127 = cljs.core.chunk_rest.call(null,seq__16119__$1);
var G__16128 = c__9713__auto__;
var G__16129 = cljs.core.count.call(null,c__9713__auto__);
var G__16130 = (0);
seq__16119 = G__16127;
chunk__16120 = G__16128;
count__16121 = G__16129;
i__16122 = G__16130;
continue;
} else {
var event = cljs.core.first.call(null,seq__16119__$1);
clear_event.call(null,event);

var G__16131 = cljs.core.next.call(null,seq__16119__$1);
var G__16132 = null;
var G__16133 = (0);
var G__16134 = (0);
seq__16119 = G__16131;
chunk__16120 = G__16132;
count__16121 = G__16133;
i__16122 = G__16134;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return clear_event.call(null,value);
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"db","db",993250759),(function (value){
if(!((cljs.core.deref.call(null,re_frame.db.app_db) === value))){
return cljs.core.reset_BANG_.call(null,re_frame.db.app_db,value);
} else {
return null;
}
}));

//# sourceMappingURL=fx.js.map
