// Compiled by ClojureScript 1.9.946 {}
goog.provide('sodium.core');
goog.require('cljs.core');
goog.require('cljs.spec.alpha');
goog.require('re_frame.loggers');
goog.require('soda_ash.core');
goog.require('sodium.re_utils');
goog.require('sodium.utils');
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("sodium","size","sodium/size",352697062),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"large","large",-196820544),null,new cljs.core.Keyword(null,"huge","huge",1683634816),null,new cljs.core.Keyword(null,"medium","medium",-1864319384),null,new cljs.core.Keyword(null,"small","small",2133478704),null,new cljs.core.Keyword(null,"tiny","tiny",1577883515),null], null), null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"large","large",-196820544),null,new cljs.core.Keyword(null,"huge","huge",1683634816),null,new cljs.core.Keyword(null,"medium","medium",-1864319384),null,new cljs.core.Keyword(null,"small","small",2133478704),null,new cljs.core.Keyword(null,"tiny","tiny",1577883515),null], null), null));
sodium.core.negligible_QMARK_ = (function sodium$core$negligible_QMARK_(x){
if(cljs.core.seqable_QMARK_.call(null,x)){
return cljs.core.empty_QMARK_.call(null,x);
} else {
return cljs.core.not.call(null,x);
}
});
/**
 * Return a function suitable for an on-* handler, to deliver the value
 *   into into a re-frame event. See also >atom.
 *   The first argument is a re-frame event vector, into which the value
 *   will be conjed as the final element.
 *   It is followed by two optional arguments: a default value that will
 *   be used when the value is empty, and a 'coercer' function to convert
 *   the value into a suitable form for the event.
 *   Note that the default value is _not_ passed through the coercer.
 */
sodium.core._GT_event = (function sodium$core$_GT_event(var_args){
var G__16532 = arguments.length;
switch (G__16532) {
case 1:
return sodium.core._GT_event.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sodium.core._GT_event.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sodium.core._GT_event.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sodium.core._GT_event.cljs$core$IFn$_invoke$arity$1 = (function (event){
return sodium.core._GT_event.call(null,event,"");
});

sodium.core._GT_event.cljs$core$IFn$_invoke$arity$2 = (function (event,default$){
return sodium.core._GT_event.call(null,event,default$,cljs.core.identity);
});

sodium.core._GT_event.cljs$core$IFn$_invoke$arity$3 = (function (event,default$,coercer){
return (function (p1__16530_SHARP_,p2__16529_SHARP_){
return sodium.re_utils._GT_evt.call(null,(function (){var value = (function (){var or__8782__auto__ = p2__16529_SHARP_.value;
if(cljs.core.truth_(or__8782__auto__)){
return or__8782__auto__;
} else {
return p2__16529_SHARP_.checked;
}
})();
return cljs.core.conj.call(null,event,coercer.call(null,(cljs.core.truth_(sodium.core.negligible_QMARK_.call(null,value))?default$:value)));
})());
});
});

sodium.core._GT_event.cljs$lang$maxFixedArity = 3;

/**
 * Utility function to dispatch multiple events from an on-* hander.
 *   The syntax is a bit opaque, because we have to wrap both the event
 *   parameters and the parameters to >event (default and coercer).
 * 
 *   So, a usage looks like:
 * 
 *  (na/>events [[[:update-age :in-minutes] 42]
 *               [[:set-color] :cyan nearest-color]])
 *   
 */
sodium.core._GT_events = (function sodium$core$_GT_events(events){
return (function (dom_event,param_map){
return cljs.core.run_BANG_.call(null,(function (event){
return cljs.core.apply.call(null,sodium.core._GT_event,event).call(null,dom_event,param_map);
}),events);
});
});
/**
 * Return a function suitable for an on-* handler, to deliver the value
 *   into into an atom. This would typically be used to store a result into
 *   a local reagent atom. See also >event.
 *   The first argument is an atom, which the value will be reset! into.
 *   It is followed by two optional arguments: a default value that will
 *   be used when the value is empty, and a 'coercer' function to convert
 *   the value into a suitable form for the event.
 *   Note that the default value is _not_ passed through the coercer.
 */
sodium.core._GT_atom = (function sodium$core$_GT_atom(var_args){
var G__16537 = arguments.length;
switch (G__16537) {
case 1:
return sodium.core._GT_atom.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sodium.core._GT_atom.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sodium.core._GT_atom.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sodium.core._GT_atom.cljs$core$IFn$_invoke$arity$1 = (function (atom){
return sodium.core._GT_atom.call(null,atom,"");
});

sodium.core._GT_atom.cljs$core$IFn$_invoke$arity$2 = (function (atom,default$){
return sodium.core._GT_atom.call(null,atom,default$,cljs.core.identity);
});

sodium.core._GT_atom.cljs$core$IFn$_invoke$arity$3 = (function (atom,default$,coercer){
return (function (p1__16535_SHARP_,p2__16534_SHARP_){
return cljs.core.reset_BANG_.call(null,atom,coercer.call(null,cljs.core.js__GT_clj.call(null,(function (){var or__8782__auto__ = p2__16534_SHARP_.value;
if(cljs.core.truth_(or__8782__auto__)){
return or__8782__auto__;
} else {
return p2__16534_SHARP_.checked;
}
})())));
});
});

sodium.core._GT_atom.cljs$lang$maxFixedArity = 3;

/**
 * Convert value and text info format suitable for a React list element
 *   for Dropdown or Select lists.
 */
sodium.core.list_option = (function sodium$core$list_option(value,text){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"key","key",-1516042587),value,new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"text","text",-1790561697),text], null);
});
/**
 * Generate a list suitable for a Dropdown or Select list of options.
 *   Items is the raw list, while value-n and text-fn extract value and
 *   text from each element.
 */
sodium.core.dropdown_list = (function sodium$core$dropdown_list(items,value_fn,text_fn){
return cljs.core.mapv.call(null,(function (item){
return sodium.core.list_option.call(null,value_fn.call(null,item),text_fn.call(null,item));
}),items);
});
/**
 * Get a value from an atom. Suitable to use, e.g., as the :value or
 *   :default-value parameter to a component.
 *   Atom is the atom to be dereferenced. It will be translated by access-fn.
 *   If null, default will be supplied instead.
 */
sodium.core._LT_atom = (function sodium$core$_LT_atom(var_args){
var G__16540 = arguments.length;
switch (G__16540) {
case 1:
return sodium.core._LT_atom.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sodium.core._LT_atom.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sodium.core._LT_atom.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sodium.core._LT_atom.cljs$core$IFn$_invoke$arity$1 = (function (atom){
return sodium.core._LT_atom.call(null,atom,null);
});

sodium.core._LT_atom.cljs$core$IFn$_invoke$arity$2 = (function (atom,default$){
return sodium.core._LT_atom.call(null,atom,default$,cljs.core.identity);
});

sodium.core._LT_atom.cljs$core$IFn$_invoke$arity$3 = (function (atom,default$,access_fn){
var or__8782__auto__ = access_fn.call(null,cljs.core.deref.call(null,atom));
if(cljs.core.truth_(or__8782__auto__)){
return or__8782__auto__;
} else {
return default$;
}
});

sodium.core._LT_atom.cljs$lang$maxFixedArity = 3;

sodium.core.advertisement = (function sodium$core$advertisement(var_args){
var args__10068__auto__ = [];
var len__10061__auto___16547 = arguments.length;
var i__10062__auto___16548 = (0);
while(true){
if((i__10062__auto___16548 < len__10061__auto___16547)){
args__10068__auto__.push((arguments[i__10062__auto___16548]));

var G__16549 = (i__10062__auto___16548 + (1));
i__10062__auto___16548 = G__16549;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.advertisement.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.advertisement.cljs$core$IFn$_invoke$arity$variadic = (function (p__16544,body__10278__auto__){
var map__16545 = p__16544;
var map__16545__$1 = ((((!((map__16545 == null)))?((((map__16545.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16545.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16545):map__16545);
var params__10277__auto__ = map__16545__$1;
var test = cljs.core.get.call(null,map__16545__$1,new cljs.core.Keyword(null,"test","test",577538877));
var children = cljs.core.get.call(null,map__16545__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var key = cljs.core.get.call(null,map__16545__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var unit = cljs.core.get.call(null,map__16545__$1,new cljs.core.Keyword(null,"unit","unit",375175175));
var as = cljs.core.get.call(null,map__16545__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var on_click = cljs.core.get.call(null,map__16545__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var style = cljs.core.get.call(null,map__16545__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var centered_QMARK_ = cljs.core.get.call(null,map__16545__$1,new cljs.core.Keyword(null,"centered?","centered?",-109742703));
var id = cljs.core.get.call(null,map__16545__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var class_name = cljs.core.get.call(null,map__16545__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10277__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 10, [new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"unit","unit",375175175),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"centered?","centered?",-109742703),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"test","test",577538877),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10277__auto__) #{:children :key :unit :as :on-click :style :centered? :id :class-name :test})"));
}

return sodium.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.Advertisement,sodium.utils.camelize_map_keys.call(null,params__10277__auto__)], null),body__10278__auto__);
});

sodium.core.advertisement.cljs$lang$maxFixedArity = (1);

sodium.core.advertisement.cljs$lang$applyTo = (function (seq16542){
var G__16543 = cljs.core.first.call(null,seq16542);
var seq16542__$1 = cljs.core.next.call(null,seq16542);
return sodium.core.advertisement.cljs$core$IFn$_invoke$arity$variadic(G__16543,seq16542__$1);
});

sodium.core.checkbox = (function sodium$core$checkbox(var_args){
var args__10068__auto__ = [];
var len__10061__auto___16555 = arguments.length;
var i__10062__auto___16556 = (0);
while(true){
if((i__10062__auto___16556 < len__10061__auto___16555)){
args__10068__auto__.push((arguments[i__10062__auto___16556]));

var G__16557 = (i__10062__auto___16556 + (1));
i__10062__auto___16556 = G__16557;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.checkbox.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.checkbox.cljs$core$IFn$_invoke$arity$variadic = (function (p__16552,body__10278__auto__){
var map__16553 = p__16552;
var map__16553__$1 = ((((!((map__16553 == null)))?((((map__16553.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16553.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16553):map__16553);
var params__10277__auto__ = map__16553__$1;
var disabled_QMARK_ = cljs.core.get.call(null,map__16553__$1,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181));
var on_change = cljs.core.get.call(null,map__16553__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
var default_indeterminate_QMARK_ = cljs.core.get.call(null,map__16553__$1,new cljs.core.Keyword(null,"default-indeterminate?","default-indeterminate?",654011935));
var slider = cljs.core.get.call(null,map__16553__$1,new cljs.core.Keyword(null,"slider","slider",-472668865));
var tab_index = cljs.core.get.call(null,map__16553__$1,new cljs.core.Keyword(null,"tab-index","tab-index",895755393));
var children = cljs.core.get.call(null,map__16553__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var indeterminate_QMARK_ = cljs.core.get.call(null,map__16553__$1,new cljs.core.Keyword(null,"indeterminate?","indeterminate?",-1382048766));
var checked_QMARK_ = cljs.core.get.call(null,map__16553__$1,new cljs.core.Keyword(null,"checked?","checked?",2024809091));
var key = cljs.core.get.call(null,map__16553__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var radio = cljs.core.get.call(null,map__16553__$1,new cljs.core.Keyword(null,"radio","radio",1323726374));
var value = cljs.core.get.call(null,map__16553__$1,new cljs.core.Keyword(null,"value","value",305978217));
var name = cljs.core.get.call(null,map__16553__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var as = cljs.core.get.call(null,map__16553__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var type = cljs.core.get.call(null,map__16553__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var toggle = cljs.core.get.call(null,map__16553__$1,new cljs.core.Keyword(null,"toggle","toggle",1291842030));
var on_mouse_down = cljs.core.get.call(null,map__16553__$1,new cljs.core.Keyword(null,"on-mouse-down","on-mouse-down",1147755470));
var on_click = cljs.core.get.call(null,map__16553__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var style = cljs.core.get.call(null,map__16553__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var label = cljs.core.get.call(null,map__16553__$1,new cljs.core.Keyword(null,"label","label",1718410804));
var id = cljs.core.get.call(null,map__16553__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var fitted_QMARK_ = cljs.core.get.call(null,map__16553__$1,new cljs.core.Keyword(null,"fitted?","fitted?",-1576243243));
var read_only_QMARK_ = cljs.core.get.call(null,map__16553__$1,new cljs.core.Keyword(null,"read-only?","read-only?",-770285386));
var class_name = cljs.core.get.call(null,map__16553__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
var default_checked_QMARK_ = cljs.core.get.call(null,map__16553__$1,new cljs.core.Keyword(null,"default-checked?","default-checked?",1949214712));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10277__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 24, [new cljs.core.Keyword(null,"tab-index","tab-index",895755393),null,new cljs.core.Keyword(null,"indeterminate?","indeterminate?",-1382048766),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"checked?","checked?",2024809091),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"radio","radio",1323726374),null,new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"value","value",305978217),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"toggle","toggle",1291842030),null,new cljs.core.Keyword(null,"on-mouse-down","on-mouse-down",1147755470),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"label","label",1718410804),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"fitted?","fitted?",-1576243243),null,new cljs.core.Keyword(null,"read-only?","read-only?",-770285386),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"default-checked?","default-checked?",1949214712),null,new cljs.core.Keyword(null,"on-change","on-change",-732046149),null,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181),null,new cljs.core.Keyword(null,"slider","slider",-472668865),null,new cljs.core.Keyword(null,"default-indeterminate?","default-indeterminate?",654011935),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10277__auto__) #{:tab-index :indeterminate? :children :checked? :key :radio :name :as :value :type :toggle :on-mouse-down :on-click :style :label :id :fitted? :read-only? :class-name :default-checked? :on-change :disabled? :slider :default-indeterminate?})"));
}

return sodium.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.Checkbox,sodium.utils.camelize_map_keys.call(null,params__10277__auto__)], null),body__10278__auto__);
});

sodium.core.checkbox.cljs$lang$maxFixedArity = (1);

sodium.core.checkbox.cljs$lang$applyTo = (function (seq16550){
var G__16551 = cljs.core.first.call(null,seq16550);
var seq16550__$1 = cljs.core.next.call(null,seq16550);
return sodium.core.checkbox.cljs$core$IFn$_invoke$arity$variadic(G__16551,seq16550__$1);
});

sodium.core.container = (function sodium$core$container(var_args){
var args__10068__auto__ = [];
var len__10061__auto___16563 = arguments.length;
var i__10062__auto___16564 = (0);
while(true){
if((i__10062__auto___16564 < len__10061__auto___16563)){
args__10068__auto__.push((arguments[i__10062__auto___16564]));

var G__16565 = (i__10062__auto___16564 + (1));
i__10062__auto___16564 = G__16565;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.container.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.container.cljs$core$IFn$_invoke$arity$variadic = (function (p__16560,body__10278__auto__){
var map__16561 = p__16560;
var map__16561__$1 = ((((!((map__16561 == null)))?((((map__16561.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16561.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16561):map__16561);
var params__10277__auto__ = map__16561__$1;
var fluid_QMARK_ = cljs.core.get.call(null,map__16561__$1,new cljs.core.Keyword(null,"fluid?","fluid?",-742121890));
var text_QMARK_ = cljs.core.get.call(null,map__16561__$1,new cljs.core.Keyword(null,"text?","text?",-934411583));
var children = cljs.core.get.call(null,map__16561__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var key = cljs.core.get.call(null,map__16561__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var text_align = cljs.core.get.call(null,map__16561__$1,new cljs.core.Keyword(null,"text-align","text-align",1786091845));
var as = cljs.core.get.call(null,map__16561__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var on_click = cljs.core.get.call(null,map__16561__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var style = cljs.core.get.call(null,map__16561__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var id = cljs.core.get.call(null,map__16561__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var class_name = cljs.core.get.call(null,map__16561__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10277__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 10, [new cljs.core.Keyword(null,"text?","text?",-934411583),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"text-align","text-align",1786091845),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"fluid?","fluid?",-742121890),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10277__auto__) #{:text? :children :text-align :key :as :on-click :style :id :class-name :fluid?})"));
}

return sodium.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.Container,sodium.utils.camelize_map_keys.call(null,params__10277__auto__)], null),body__10278__auto__);
});

sodium.core.container.cljs$lang$maxFixedArity = (1);

sodium.core.container.cljs$lang$applyTo = (function (seq16558){
var G__16559 = cljs.core.first.call(null,seq16558);
var seq16558__$1 = cljs.core.next.call(null,seq16558);
return sodium.core.container.cljs$core$IFn$_invoke$arity$variadic(G__16559,seq16558__$1);
});

sodium.core.dropdown = (function sodium$core$dropdown(var_args){
var args__10068__auto__ = [];
var len__10061__auto___16571 = arguments.length;
var i__10062__auto___16572 = (0);
while(true){
if((i__10062__auto___16572 < len__10061__auto___16571)){
args__10068__auto__.push((arguments[i__10062__auto___16572]));

var G__16573 = (i__10062__auto___16572 + (1));
i__10062__auto___16572 = G__16573;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.dropdown.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.dropdown.cljs$core$IFn$_invoke$arity$variadic = (function (p__16568,body__10278__auto__){
var map__16569 = p__16568;
var map__16569__$1 = ((((!((map__16569 == null)))?((((map__16569.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16569.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16569):map__16569);
var params__10277__auto__ = map__16569__$1;
var on_search_change = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"on-search-change","on-search-change",-179605351));
var options = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"options","options",99638489));
var error_QMARK_ = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"error?","error?",-460689159));
var placehoder = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"placehoder","placehoder",1840553690));
var disabled_QMARK_ = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181));
var selection = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"selection","selection",975998651));
var trigger = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"trigger","trigger",103466139));
var on_change = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
var addition_label = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"addition-label","addition-label",-856529348));
var button_QMARK_ = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"button?","button?",-1099897092));
var on_open = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"on-open","on-open",-1391088163));
var scrolling_QMARK_ = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"scrolling?","scrolling?",-365022499));
var test = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"test","test",577538877));
var open_on_focus_QMARK_ = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"open-on-focus?","open-on-focus?",1405372990));
var fluid_QMARK_ = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"fluid?","fluid?",-742121890));
var default_selected_label = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"default-selected-label","default-selected-label",-1690769250));
var on_label_click = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"on-label-click","on-label-click",-706744384));
var on_add_item = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"on-add-item","on-add-item",-1647898400));
var close_on_blur_QMARK_ = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"close-on-blur?","close-on-blur?",1411001664));
var selected_label = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"selected-label","selected-label",-902280703));
var tab_index = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"tab-index","tab-index",895755393));
var children = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var pointing = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"pointing","pointing",-1869969692));
var upward_QMARK_ = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"upward?","upward?",1016884292));
var key = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var addition_position = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"addition-position","addition-position",-127742747));
var on_close = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"on-close","on-close",-761178394));
var allow_additions = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"allow-additions","allow-additions",437152424));
var on_focus = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"on-focus","on-focus",-13737624));
var floating_QMARK_ = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"floating?","floating?",509059561));
var close_on_change_QMARK_ = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"close-on-change?","close-on-change?",-530623799));
var value = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"value","value",305978217));
var loading_QMARK_ = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"loading?","loading?",1905707049));
var as = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var default_value = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"default-value","default-value",232220170));
var on_blur = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"on-blur","on-blur",814300747));
var search_input = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"search-input","search-input",-576916149));
var no_results_message = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"no-results-message","no-results-message",-668792660));
var icon = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"icon","icon",1679606541));
var basic_QMARK_ = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"basic?","basic?",-2093501395));
var search = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"search","search",1564939822));
var header = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"header","header",119441134));
var on_mouse_down = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"on-mouse-down","on-mouse-down",1147755470));
var render_label = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"render-label","render-label",634900559));
var on_click = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var labeled_QMARK_ = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"labeled?","labeled?",-92627440));
var style = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var item_QMARK_ = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"item?","item?",1224206865));
var inline_QMARK_ = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"inline?","inline?",-1674483791));
var compact_QMARK_ = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"compact?","compact?",1216893298));
var min_characters = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"min-characters","min-characters",1196301908));
var id = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var open_QMARK_ = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"open?","open?",1238443125));
var multiple_QMARK_ = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"multiple?","multiple?",-490002283));
var select_on_blur = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"select-on-blur","select-on-blur",500299062));
var simple_QMARK_ = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"simple?","simple?",1381678616));
var default_open_QMARK_ = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"default-open?","default-open?",-2082763144));
var class_name = cljs.core.get.call(null,map__16569__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10277__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 58, [new cljs.core.Keyword(null,"on-add-item","on-add-item",-1647898400),null,new cljs.core.Keyword(null,"close-on-blur?","close-on-blur?",1411001664),null,new cljs.core.Keyword(null,"on-label-click","on-label-click",-706744384),null,new cljs.core.Keyword(null,"tab-index","tab-index",895755393),null,new cljs.core.Keyword(null,"selected-label","selected-label",-902280703),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"upward?","upward?",1016884292),null,new cljs.core.Keyword(null,"pointing","pointing",-1869969692),null,new cljs.core.Keyword(null,"addition-position","addition-position",-127742747),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"on-close","on-close",-761178394),null,new cljs.core.Keyword(null,"on-focus","on-focus",-13737624),null,new cljs.core.Keyword(null,"allow-additions","allow-additions",437152424),null,new cljs.core.Keyword(null,"loading?","loading?",1905707049),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"floating?","floating?",509059561),null,new cljs.core.Keyword(null,"close-on-change?","close-on-change?",-530623799),null,new cljs.core.Keyword(null,"value","value",305978217),null,new cljs.core.Keyword(null,"default-value","default-value",232220170),null,new cljs.core.Keyword(null,"search-input","search-input",-576916149),null,new cljs.core.Keyword(null,"on-blur","on-blur",814300747),null,new cljs.core.Keyword(null,"no-results-message","no-results-message",-668792660),null,new cljs.core.Keyword(null,"basic?","basic?",-2093501395),null,new cljs.core.Keyword(null,"icon","icon",1679606541),null,new cljs.core.Keyword(null,"search","search",1564939822),null,new cljs.core.Keyword(null,"header","header",119441134),null,new cljs.core.Keyword(null,"on-mouse-down","on-mouse-down",1147755470),null,new cljs.core.Keyword(null,"render-label","render-label",634900559),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"labeled?","labeled?",-92627440),null,new cljs.core.Keyword(null,"item?","item?",1224206865),null,new cljs.core.Keyword(null,"inline?","inline?",-1674483791),null,new cljs.core.Keyword(null,"compact?","compact?",1216893298),null,new cljs.core.Keyword(null,"min-characters","min-characters",1196301908),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"open?","open?",1238443125),null,new cljs.core.Keyword(null,"multiple?","multiple?",-490002283),null,new cljs.core.Keyword(null,"select-on-blur","select-on-blur",500299062),null,new cljs.core.Keyword(null,"simple?","simple?",1381678616),null,new cljs.core.Keyword(null,"default-open?","default-open?",-2082763144),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"on-search-change","on-search-change",-179605351),null,new cljs.core.Keyword(null,"options","options",99638489),null,new cljs.core.Keyword(null,"error?","error?",-460689159),null,new cljs.core.Keyword(null,"placehoder","placehoder",1840553690),null,new cljs.core.Keyword(null,"trigger","trigger",103466139),null,new cljs.core.Keyword(null,"on-change","on-change",-732046149),null,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181),null,new cljs.core.Keyword(null,"selection","selection",975998651),null,new cljs.core.Keyword(null,"addition-label","addition-label",-856529348),null,new cljs.core.Keyword(null,"button?","button?",-1099897092),null,new cljs.core.Keyword(null,"on-open","on-open",-1391088163),null,new cljs.core.Keyword(null,"scrolling?","scrolling?",-365022499),null,new cljs.core.Keyword(null,"test","test",577538877),null,new cljs.core.Keyword(null,"default-selected-label","default-selected-label",-1690769250),null,new cljs.core.Keyword(null,"open-on-focus?","open-on-focus?",1405372990),null,new cljs.core.Keyword(null,"fluid?","fluid?",-742121890),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10277__auto__) #{:on-add-item :close-on-blur? :on-label-click :tab-index :selected-label :children :upward? :pointing :addition-position :key :on-close :on-focus :allow-additions :loading? :as :floating? :close-on-change? :value :default-value :search-input :on-blur :no-results-message :basic? :icon :search :header :on-mouse-down :render-label :on-click :style :labeled? :item? :inline? :compact? :min-characters :id :open? :multiple? :select-on-blur :simple? :default-open? :class-name :on-search-change :options :error? :placehoder :trigger :on-change :disabled? :selection :addition-label :button? :on-open :scrolling? :test :default-selected-label :open-on-focus? :fluid?})"));
}

return sodium.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.Dropdown,sodium.utils.camelize_map_keys.call(null,params__10277__auto__)], null),body__10278__auto__);
});

sodium.core.dropdown.cljs$lang$maxFixedArity = (1);

sodium.core.dropdown.cljs$lang$applyTo = (function (seq16566){
var G__16567 = cljs.core.first.call(null,seq16566);
var seq16566__$1 = cljs.core.next.call(null,seq16566);
return sodium.core.dropdown.cljs$core$IFn$_invoke$arity$variadic(G__16567,seq16566__$1);
});

sodium.core.divider = (function sodium$core$divider(var_args){
var args__10068__auto__ = [];
var len__10061__auto___16579 = arguments.length;
var i__10062__auto___16580 = (0);
while(true){
if((i__10062__auto___16580 < len__10061__auto___16579)){
args__10068__auto__.push((arguments[i__10062__auto___16580]));

var G__16581 = (i__10062__auto___16580 + (1));
i__10062__auto___16580 = G__16581;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.divider.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.divider.cljs$core$IFn$_invoke$arity$variadic = (function (p__16576,body__10278__auto__){
var map__16577 = p__16576;
var map__16577__$1 = ((((!((map__16577 == null)))?((((map__16577.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16577.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16577):map__16577);
var params__10277__auto__ = map__16577__$1;
var inverted_QMARK_ = cljs.core.get.call(null,map__16577__$1,new cljs.core.Keyword(null,"inverted?","inverted?",-676420704));
var horizontal_QMARK_ = cljs.core.get.call(null,map__16577__$1,new cljs.core.Keyword(null,"horizontal?","horizontal?",-423282271));
var children = cljs.core.get.call(null,map__16577__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var key = cljs.core.get.call(null,map__16577__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var as = cljs.core.get.call(null,map__16577__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var on_click = cljs.core.get.call(null,map__16577__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var style = cljs.core.get.call(null,map__16577__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var clearing_QMARK_ = cljs.core.get.call(null,map__16577__$1,new cljs.core.Keyword(null,"clearing?","clearing?",-1821736270));
var id = cljs.core.get.call(null,map__16577__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var vertical_QMARK_ = cljs.core.get.call(null,map__16577__$1,new cljs.core.Keyword(null,"vertical?","vertical?",-1522630444));
var hidden_QMARK_ = cljs.core.get.call(null,map__16577__$1,new cljs.core.Keyword(null,"hidden?","hidden?",1339691380));
var fitted_QMARK_ = cljs.core.get.call(null,map__16577__$1,new cljs.core.Keyword(null,"fitted?","fitted?",-1576243243));
var class_name = cljs.core.get.call(null,map__16577__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
var section_QMARK_ = cljs.core.get.call(null,map__16577__$1,new cljs.core.Keyword(null,"section?","section?",-608017256));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10277__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [new cljs.core.Keyword(null,"inverted?","inverted?",-676420704),null,new cljs.core.Keyword(null,"horizontal?","horizontal?",-423282271),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"clearing?","clearing?",-1821736270),null,new cljs.core.Keyword(null,"vertical?","vertical?",-1522630444),null,new cljs.core.Keyword(null,"hidden?","hidden?",1339691380),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"fitted?","fitted?",-1576243243),null,new cljs.core.Keyword(null,"section?","section?",-608017256),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10277__auto__) #{:inverted? :horizontal? :children :key :as :on-click :style :clearing? :vertical? :hidden? :id :fitted? :section? :class-name})"));
}

return sodium.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.Divider,sodium.utils.camelize_map_keys.call(null,params__10277__auto__)], null),body__10278__auto__);
});

sodium.core.divider.cljs$lang$maxFixedArity = (1);

sodium.core.divider.cljs$lang$applyTo = (function (seq16574){
var G__16575 = cljs.core.first.call(null,seq16574);
var seq16574__$1 = cljs.core.next.call(null,seq16574);
return sodium.core.divider.cljs$core$IFn$_invoke$arity$variadic(G__16575,seq16574__$1);
});

sodium.core.form = (function sodium$core$form(var_args){
var args__10068__auto__ = [];
var len__10061__auto___16587 = arguments.length;
var i__10062__auto___16588 = (0);
while(true){
if((i__10062__auto___16588 < len__10061__auto___16587)){
args__10068__auto__.push((arguments[i__10062__auto___16588]));

var G__16589 = (i__10062__auto___16588 + (1));
i__10062__auto___16588 = G__16589;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.form.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.form.cljs$core$IFn$_invoke$arity$variadic = (function (p__16584,body__10278__auto__){
var map__16585 = p__16584;
var map__16585__$1 = ((((!((map__16585 == null)))?((((map__16585.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16585.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16585):map__16585);
var params__10277__auto__ = map__16585__$1;
var error_QMARK_ = cljs.core.get.call(null,map__16585__$1,new cljs.core.Keyword(null,"error?","error?",-460689159));
var success_QMARK_ = cljs.core.get.call(null,map__16585__$1,new cljs.core.Keyword(null,"success?","success?",-122854052));
var inverted_QMARK_ = cljs.core.get.call(null,map__16585__$1,new cljs.core.Keyword(null,"inverted?","inverted?",-676420704));
var children = cljs.core.get.call(null,map__16585__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var key = cljs.core.get.call(null,map__16585__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var loading_QMARK_ = cljs.core.get.call(null,map__16585__$1,new cljs.core.Keyword(null,"loading?","loading?",1905707049));
var as = cljs.core.get.call(null,map__16585__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var reply_QMARK_ = cljs.core.get.call(null,map__16585__$1,new cljs.core.Keyword(null,"reply?","reply?",126773098));
var warning_QMARK_ = cljs.core.get.call(null,map__16585__$1,new cljs.core.Keyword(null,"warning?","warning?",-1789142517));
var on_click = cljs.core.get.call(null,map__16585__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var size = cljs.core.get.call(null,map__16585__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var widths = cljs.core.get.call(null,map__16585__$1,new cljs.core.Keyword(null,"widths","widths",-1467327440));
var style = cljs.core.get.call(null,map__16585__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var id = cljs.core.get.call(null,map__16585__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var on_submit = cljs.core.get.call(null,map__16585__$1,new cljs.core.Keyword(null,"on-submit","on-submit",1227871159));
var class_name = cljs.core.get.call(null,map__16585__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
var action = cljs.core.get.call(null,map__16585__$1,new cljs.core.Keyword(null,"action","action",-811238024));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10277__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 17, [new cljs.core.Keyword(null,"inverted?","inverted?",-676420704),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"loading?","loading?",1905707049),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"reply?","reply?",126773098),null,new cljs.core.Keyword(null,"warning?","warning?",-1789142517),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"widths","widths",-1467327440),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"on-submit","on-submit",1227871159),null,new cljs.core.Keyword(null,"action","action",-811238024),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"error?","error?",-460689159),null,new cljs.core.Keyword(null,"success?","success?",-122854052),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10277__auto__) #{:inverted? :children :key :loading? :as :reply? :warning? :on-click :size :widths :style :id :on-submit :action :class-name :error? :success?})"));
}

return sodium.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.Form,sodium.utils.camelize_map_keys.call(null,params__10277__auto__)], null),body__10278__auto__);
});

sodium.core.form.cljs$lang$maxFixedArity = (1);

sodium.core.form.cljs$lang$applyTo = (function (seq16582){
var G__16583 = cljs.core.first.call(null,seq16582);
var seq16582__$1 = cljs.core.next.call(null,seq16582);
return sodium.core.form.cljs$core$IFn$_invoke$arity$variadic(G__16583,seq16582__$1);
});

sodium.core.form_input = (function sodium$core$form_input(var_args){
var args__10068__auto__ = [];
var len__10061__auto___16595 = arguments.length;
var i__10062__auto___16596 = (0);
while(true){
if((i__10062__auto___16596 < len__10061__auto___16595)){
args__10068__auto__.push((arguments[i__10062__auto___16596]));

var G__16597 = (i__10062__auto___16596 + (1));
i__10062__auto___16596 = G__16597;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.form_input.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.form_input.cljs$core$IFn$_invoke$arity$variadic = (function (p__16592,body__10278__auto__){
var map__16593 = p__16592;
var map__16593__$1 = ((((!((map__16593 == null)))?((((map__16593.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16593.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16593):map__16593);
var params__10277__auto__ = map__16593__$1;
var input = cljs.core.get.call(null,map__16593__$1,new cljs.core.Keyword(null,"input","input",556931961));
var action_position = cljs.core.get.call(null,map__16593__$1,new cljs.core.Keyword(null,"action-position","action-position",-704217959));
var error_QMARK_ = cljs.core.get.call(null,map__16593__$1,new cljs.core.Keyword(null,"error?","error?",-460689159));
var disabled_QMARK_ = cljs.core.get.call(null,map__16593__$1,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181));
var on_change = cljs.core.get.call(null,map__16593__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
var step = cljs.core.get.call(null,map__16593__$1,new cljs.core.Keyword(null,"step","step",1288888124));
var fluid_QMARK_ = cljs.core.get.call(null,map__16593__$1,new cljs.core.Keyword(null,"fluid?","fluid?",-742121890));
var label_position = cljs.core.get.call(null,map__16593__$1,new cljs.core.Keyword(null,"label-position","label-position",-1546831329));
var inverted_QMARK_ = cljs.core.get.call(null,map__16593__$1,new cljs.core.Keyword(null,"inverted?","inverted?",-676420704));
var tab_index = cljs.core.get.call(null,map__16593__$1,new cljs.core.Keyword(null,"tab-index","tab-index",895755393));
var children = cljs.core.get.call(null,map__16593__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var required_QMARK_ = cljs.core.get.call(null,map__16593__$1,new cljs.core.Keyword(null,"required?","required?",-872514462));
var key = cljs.core.get.call(null,map__16593__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var placeholder = cljs.core.get.call(null,map__16593__$1,new cljs.core.Keyword(null,"placeholder","placeholder",-104873083));
var icon_position = cljs.core.get.call(null,map__16593__$1,new cljs.core.Keyword(null,"icon-position","icon-position",-1720359034));
var focus_QMARK_ = cljs.core.get.call(null,map__16593__$1,new cljs.core.Keyword(null,"focus?","focus?",-3018488));
var value = cljs.core.get.call(null,map__16593__$1,new cljs.core.Keyword(null,"value","value",305978217));
var as = cljs.core.get.call(null,map__16593__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var default_value = cljs.core.get.call(null,map__16593__$1,new cljs.core.Keyword(null,"default-value","default-value",232220170));
var width = cljs.core.get.call(null,map__16593__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var transparent_QMARK_ = cljs.core.get.call(null,map__16593__$1,new cljs.core.Keyword(null,"transparent?","transparent?",-1446050548));
var type = cljs.core.get.call(null,map__16593__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var icon = cljs.core.get.call(null,map__16593__$1,new cljs.core.Keyword(null,"icon","icon",1679606541));
var on_click = cljs.core.get.call(null,map__16593__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var size = cljs.core.get.call(null,map__16593__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var style = cljs.core.get.call(null,map__16593__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var inline_QMARK_ = cljs.core.get.call(null,map__16593__$1,new cljs.core.Keyword(null,"inline?","inline?",-1674483791));
var list = cljs.core.get.call(null,map__16593__$1,new cljs.core.Keyword(null,"list","list",765357683));
var loading = cljs.core.get.call(null,map__16593__$1,new cljs.core.Keyword(null,"loading","loading",-737050189));
var label = cljs.core.get.call(null,map__16593__$1,new cljs.core.Keyword(null,"label","label",1718410804));
var id = cljs.core.get.call(null,map__16593__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var control = cljs.core.get.call(null,map__16593__$1,new cljs.core.Keyword(null,"control","control",1892578036));
var class_name = cljs.core.get.call(null,map__16593__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
var action = cljs.core.get.call(null,map__16593__$1,new cljs.core.Keyword(null,"action","action",-811238024));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10277__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 34, [new cljs.core.Keyword(null,"inverted?","inverted?",-676420704),null,new cljs.core.Keyword(null,"tab-index","tab-index",895755393),null,new cljs.core.Keyword(null,"required?","required?",-872514462),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),null,new cljs.core.Keyword(null,"icon-position","icon-position",-1720359034),null,new cljs.core.Keyword(null,"focus?","focus?",-3018488),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"value","value",305978217),null,new cljs.core.Keyword(null,"default-value","default-value",232220170),null,new cljs.core.Keyword(null,"width","width",-384071477),null,new cljs.core.Keyword(null,"transparent?","transparent?",-1446050548),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"icon","icon",1679606541),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"inline?","inline?",-1674483791),null,new cljs.core.Keyword(null,"loading","loading",-737050189),null,new cljs.core.Keyword(null,"list","list",765357683),null,new cljs.core.Keyword(null,"label","label",1718410804),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"control","control",1892578036),null,new cljs.core.Keyword(null,"action","action",-811238024),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"action-position","action-position",-704217959),null,new cljs.core.Keyword(null,"error?","error?",-460689159),null,new cljs.core.Keyword(null,"input","input",556931961),null,new cljs.core.Keyword(null,"on-change","on-change",-732046149),null,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181),null,new cljs.core.Keyword(null,"step","step",1288888124),null,new cljs.core.Keyword(null,"fluid?","fluid?",-742121890),null,new cljs.core.Keyword(null,"label-position","label-position",-1546831329),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10277__auto__) #{:inverted? :tab-index :required? :children :key :placeholder :icon-position :focus? :as :value :default-value :width :transparent? :type :icon :on-click :size :style :inline? :loading :list :label :id :control :action :class-name :action-position :error? :input :on-change :disabled? :step :fluid? :label-position})"));
}

return sodium.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.FormInput,sodium.utils.camelize_map_keys.call(null,params__10277__auto__)], null),body__10278__auto__);
});

sodium.core.form_input.cljs$lang$maxFixedArity = (1);

sodium.core.form_input.cljs$lang$applyTo = (function (seq16590){
var G__16591 = cljs.core.first.call(null,seq16590);
var seq16590__$1 = cljs.core.next.call(null,seq16590);
return sodium.core.form_input.cljs$core$IFn$_invoke$arity$variadic(G__16591,seq16590__$1);
});

sodium.core.form_group = (function sodium$core$form_group(var_args){
var args__10068__auto__ = [];
var len__10061__auto___16603 = arguments.length;
var i__10062__auto___16604 = (0);
while(true){
if((i__10062__auto___16604 < len__10061__auto___16603)){
args__10068__auto__.push((arguments[i__10062__auto___16604]));

var G__16605 = (i__10062__auto___16604 + (1));
i__10062__auto___16604 = G__16605;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.form_group.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.form_group.cljs$core$IFn$_invoke$arity$variadic = (function (p__16600,body__10278__auto__){
var map__16601 = p__16600;
var map__16601__$1 = ((((!((map__16601 == null)))?((((map__16601.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16601.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16601):map__16601);
var params__10277__auto__ = map__16601__$1;
var inline = cljs.core.get.call(null,map__16601__$1,new cljs.core.Keyword(null,"inline","inline",1399884222));
var children = cljs.core.get.call(null,map__16601__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var grouped = cljs.core.get.call(null,map__16601__$1,new cljs.core.Keyword(null,"grouped","grouped",15624546));
var key = cljs.core.get.call(null,map__16601__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var as = cljs.core.get.call(null,map__16601__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var on_click = cljs.core.get.call(null,map__16601__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var widths = cljs.core.get.call(null,map__16601__$1,new cljs.core.Keyword(null,"widths","widths",-1467327440));
var style = cljs.core.get.call(null,map__16601__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var id = cljs.core.get.call(null,map__16601__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var class_name = cljs.core.get.call(null,map__16601__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10277__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 10, [new cljs.core.Keyword(null,"grouped","grouped",15624546),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"widths","widths",-1467327440),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"inline","inline",1399884222),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10277__auto__) #{:grouped :children :key :as :on-click :widths :style :id :class-name :inline})"));
}

return sodium.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.FormGroup,sodium.utils.camelize_map_keys.call(null,params__10277__auto__)], null),body__10278__auto__);
});

sodium.core.form_group.cljs$lang$maxFixedArity = (1);

sodium.core.form_group.cljs$lang$applyTo = (function (seq16598){
var G__16599 = cljs.core.first.call(null,seq16598);
var seq16598__$1 = cljs.core.next.call(null,seq16598);
return sodium.core.form_group.cljs$core$IFn$_invoke$arity$variadic(G__16599,seq16598__$1);
});

sodium.core.grid = (function sodium$core$grid(var_args){
var args__10068__auto__ = [];
var len__10061__auto___16611 = arguments.length;
var i__10062__auto___16612 = (0);
while(true){
if((i__10062__auto___16612 < len__10061__auto___16611)){
args__10068__auto__.push((arguments[i__10062__auto___16612]));

var G__16613 = (i__10062__auto___16612 + (1));
i__10062__auto___16612 = G__16613;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.grid.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.grid.cljs$core$IFn$_invoke$arity$variadic = (function (p__16608,body__10278__auto__){
var map__16609 = p__16608;
var map__16609__$1 = ((((!((map__16609 == null)))?((((map__16609.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16609.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16609):map__16609);
var params__10277__auto__ = map__16609__$1;
var doubling_QMARK_ = cljs.core.get.call(null,map__16609__$1,new cljs.core.Keyword(null,"doubling?","doubling?",-2028386054));
var divided_QMARK_ = cljs.core.get.call(null,map__16609__$1,new cljs.core.Keyword(null,"divided?","divided?",-706929476));
var relaxed = cljs.core.get.call(null,map__16609__$1,new cljs.core.Keyword(null,"relaxed","relaxed",-939075907));
var divided = cljs.core.get.call(null,map__16609__$1,new cljs.core.Keyword(null,"divided","divided",727855229));
var reversed = cljs.core.get.call(null,map__16609__$1,new cljs.core.Keyword(null,"reversed","reversed",-286659968));
var inverted_QMARK_ = cljs.core.get.call(null,map__16609__$1,new cljs.core.Keyword(null,"inverted?","inverted?",-676420704));
var children = cljs.core.get.call(null,map__16609__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var stretched_QMARK_ = cljs.core.get.call(null,map__16609__$1,new cljs.core.Keyword(null,"stretched?","stretched?",-1920610910));
var stackable_QMARK_ = cljs.core.get.call(null,map__16609__$1,new cljs.core.Keyword(null,"stackable?","stackable?",-1877083005));
var celled = cljs.core.get.call(null,map__16609__$1,new cljs.core.Keyword(null,"celled","celled",-1969088093));
var key = cljs.core.get.call(null,map__16609__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var text_align = cljs.core.get.call(null,map__16609__$1,new cljs.core.Keyword(null,"text-align","text-align",1786091845));
var vertical_align = cljs.core.get.call(null,map__16609__$1,new cljs.core.Keyword(null,"vertical-align","vertical-align",651007333));
var columns = cljs.core.get.call(null,map__16609__$1,new cljs.core.Keyword(null,"columns","columns",1998437288));
var as = cljs.core.get.call(null,map__16609__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var on_click = cljs.core.get.call(null,map__16609__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var style = cljs.core.get.call(null,map__16609__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var centered_QMARK_ = cljs.core.get.call(null,map__16609__$1,new cljs.core.Keyword(null,"centered?","centered?",-109742703));
var id = cljs.core.get.call(null,map__16609__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var celled_QMARK_ = cljs.core.get.call(null,map__16609__$1,new cljs.core.Keyword(null,"celled?","celled?",-266703115));
var padded = cljs.core.get.call(null,map__16609__$1,new cljs.core.Keyword(null,"padded","padded",1434297910));
var container_QMARK_ = cljs.core.get.call(null,map__16609__$1,new cljs.core.Keyword(null,"container?","container?",-1563620041));
var class_name = cljs.core.get.call(null,map__16609__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10277__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 23, [new cljs.core.Keyword(null,"reversed","reversed",-286659968),null,new cljs.core.Keyword(null,"inverted?","inverted?",-676420704),null,new cljs.core.Keyword(null,"stretched?","stretched?",-1920610910),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"stackable?","stackable?",-1877083005),null,new cljs.core.Keyword(null,"celled","celled",-1969088093),null,new cljs.core.Keyword(null,"text-align","text-align",1786091845),null,new cljs.core.Keyword(null,"vertical-align","vertical-align",651007333),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"columns","columns",1998437288),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"centered?","centered?",-109742703),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"celled?","celled?",-266703115),null,new cljs.core.Keyword(null,"padded","padded",1434297910),null,new cljs.core.Keyword(null,"container?","container?",-1563620041),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"doubling?","doubling?",-2028386054),null,new cljs.core.Keyword(null,"divided?","divided?",-706929476),null,new cljs.core.Keyword(null,"divided","divided",727855229),null,new cljs.core.Keyword(null,"relaxed","relaxed",-939075907),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10277__auto__) #{:reversed :inverted? :stretched? :children :stackable? :celled :text-align :vertical-align :key :columns :as :on-click :style :centered? :id :celled? :padded :container? :class-name :doubling? :divided? :divided :relaxed})"));
}

return sodium.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.Grid,sodium.utils.camelize_map_keys.call(null,params__10277__auto__)], null),body__10278__auto__);
});

sodium.core.grid.cljs$lang$maxFixedArity = (1);

sodium.core.grid.cljs$lang$applyTo = (function (seq16606){
var G__16607 = cljs.core.first.call(null,seq16606);
var seq16606__$1 = cljs.core.next.call(null,seq16606);
return sodium.core.grid.cljs$core$IFn$_invoke$arity$variadic(G__16607,seq16606__$1);
});

sodium.core.grid_column = (function sodium$core$grid_column(var_args){
var args__10068__auto__ = [];
var len__10061__auto___16619 = arguments.length;
var i__10062__auto___16620 = (0);
while(true){
if((i__10062__auto___16620 < len__10061__auto___16619)){
args__10068__auto__.push((arguments[i__10062__auto___16620]));

var G__16621 = (i__10062__auto___16620 + (1));
i__10062__auto___16620 = G__16621;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.grid_column.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.grid_column.cljs$core$IFn$_invoke$arity$variadic = (function (p__16616,body__10278__auto__){
var map__16617 = p__16616;
var map__16617__$1 = ((((!((map__16617 == null)))?((((map__16617.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16617.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16617):map__16617);
var params__10277__auto__ = map__16617__$1;
var mobile = cljs.core.get.call(null,map__16617__$1,new cljs.core.Keyword(null,"mobile","mobile",1403078170));
var wide_screen = cljs.core.get.call(null,map__16617__$1,new cljs.core.Keyword(null,"wide-screen","wide-screen",-1538015237));
var large_screen = cljs.core.get.call(null,map__16617__$1,new cljs.core.Keyword(null,"large-screen","large-screen",1669396892));
var tablet = cljs.core.get.call(null,map__16617__$1,new cljs.core.Keyword(null,"tablet","tablet",-318585919));
var children = cljs.core.get.call(null,map__16617__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var stretched_QMARK_ = cljs.core.get.call(null,map__16617__$1,new cljs.core.Keyword(null,"stretched?","stretched?",-1920610910));
var only = cljs.core.get.call(null,map__16617__$1,new cljs.core.Keyword(null,"only","only",1907811652));
var key = cljs.core.get.call(null,map__16617__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var color = cljs.core.get.call(null,map__16617__$1,new cljs.core.Keyword(null,"color","color",1011675173));
var text_align = cljs.core.get.call(null,map__16617__$1,new cljs.core.Keyword(null,"text-align","text-align",1786091845));
var vertical_align = cljs.core.get.call(null,map__16617__$1,new cljs.core.Keyword(null,"vertical-align","vertical-align",651007333));
var computer = cljs.core.get.call(null,map__16617__$1,new cljs.core.Keyword(null,"computer","computer",-1035300443));
var as = cljs.core.get.call(null,map__16617__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var width = cljs.core.get.call(null,map__16617__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var on_click = cljs.core.get.call(null,map__16617__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var style = cljs.core.get.call(null,map__16617__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var floated = cljs.core.get.call(null,map__16617__$1,new cljs.core.Keyword(null,"floated","floated",739819667));
var id = cljs.core.get.call(null,map__16617__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var class_name = cljs.core.get.call(null,map__16617__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10277__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 19, [new cljs.core.Keyword(null,"tablet","tablet",-318585919),null,new cljs.core.Keyword(null,"stretched?","stretched?",-1920610910),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"only","only",1907811652),null,new cljs.core.Keyword(null,"color","color",1011675173),null,new cljs.core.Keyword(null,"text-align","text-align",1786091845),null,new cljs.core.Keyword(null,"vertical-align","vertical-align",651007333),null,new cljs.core.Keyword(null,"computer","computer",-1035300443),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"width","width",-384071477),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"floated","floated",739819667),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"mobile","mobile",1403078170),null,new cljs.core.Keyword(null,"wide-screen","wide-screen",-1538015237),null,new cljs.core.Keyword(null,"large-screen","large-screen",1669396892),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10277__auto__) #{:tablet :stretched? :children :only :color :text-align :vertical-align :computer :key :as :width :on-click :style :floated :id :class-name :mobile :wide-screen :large-screen})"));
}

return sodium.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.GridColumn,sodium.utils.camelize_map_keys.call(null,params__10277__auto__)], null),body__10278__auto__);
});

sodium.core.grid_column.cljs$lang$maxFixedArity = (1);

sodium.core.grid_column.cljs$lang$applyTo = (function (seq16614){
var G__16615 = cljs.core.first.call(null,seq16614);
var seq16614__$1 = cljs.core.next.call(null,seq16614);
return sodium.core.grid_column.cljs$core$IFn$_invoke$arity$variadic(G__16615,seq16614__$1);
});

sodium.core.grid_row = (function sodium$core$grid_row(var_args){
var args__10068__auto__ = [];
var len__10061__auto___16627 = arguments.length;
var i__10062__auto___16628 = (0);
while(true){
if((i__10062__auto___16628 < len__10061__auto___16627)){
args__10068__auto__.push((arguments[i__10062__auto___16628]));

var G__16629 = (i__10062__auto___16628 + (1));
i__10062__auto___16628 = G__16629;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.grid_row.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.grid_row.cljs$core$IFn$_invoke$arity$variadic = (function (p__16624,body__10278__auto__){
var map__16625 = p__16624;
var map__16625__$1 = ((((!((map__16625 == null)))?((((map__16625.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16625.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16625):map__16625);
var params__10277__auto__ = map__16625__$1;
var divided_QMARK_ = cljs.core.get.call(null,map__16625__$1,new cljs.core.Keyword(null,"divided?","divided?",-706929476));
var reversed = cljs.core.get.call(null,map__16625__$1,new cljs.core.Keyword(null,"reversed","reversed",-286659968));
var children = cljs.core.get.call(null,map__16625__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var stretched_QMARK_ = cljs.core.get.call(null,map__16625__$1,new cljs.core.Keyword(null,"stretched?","stretched?",-1920610910));
var only = cljs.core.get.call(null,map__16625__$1,new cljs.core.Keyword(null,"only","only",1907811652));
var key = cljs.core.get.call(null,map__16625__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var color = cljs.core.get.call(null,map__16625__$1,new cljs.core.Keyword(null,"color","color",1011675173));
var text_align = cljs.core.get.call(null,map__16625__$1,new cljs.core.Keyword(null,"text-align","text-align",1786091845));
var vertical_align = cljs.core.get.call(null,map__16625__$1,new cljs.core.Keyword(null,"vertical-align","vertical-align",651007333));
var columns = cljs.core.get.call(null,map__16625__$1,new cljs.core.Keyword(null,"columns","columns",1998437288));
var as = cljs.core.get.call(null,map__16625__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var on_click = cljs.core.get.call(null,map__16625__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var style = cljs.core.get.call(null,map__16625__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var centered_QMARK_ = cljs.core.get.call(null,map__16625__$1,new cljs.core.Keyword(null,"centered?","centered?",-109742703));
var id = cljs.core.get.call(null,map__16625__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var class_name = cljs.core.get.call(null,map__16625__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10277__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 16, [new cljs.core.Keyword(null,"reversed","reversed",-286659968),null,new cljs.core.Keyword(null,"stretched?","stretched?",-1920610910),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"only","only",1907811652),null,new cljs.core.Keyword(null,"color","color",1011675173),null,new cljs.core.Keyword(null,"text-align","text-align",1786091845),null,new cljs.core.Keyword(null,"vertical-align","vertical-align",651007333),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"columns","columns",1998437288),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"centered?","centered?",-109742703),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"divided?","divided?",-706929476),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10277__auto__) #{:reversed :stretched? :children :only :color :text-align :vertical-align :key :columns :as :on-click :style :centered? :id :class-name :divided?})"));
}

return sodium.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.GridRow,sodium.utils.camelize_map_keys.call(null,params__10277__auto__)], null),body__10278__auto__);
});

sodium.core.grid_row.cljs$lang$maxFixedArity = (1);

sodium.core.grid_row.cljs$lang$applyTo = (function (seq16622){
var G__16623 = cljs.core.first.call(null,seq16622);
var seq16622__$1 = cljs.core.next.call(null,seq16622);
return sodium.core.grid_row.cljs$core$IFn$_invoke$arity$variadic(G__16623,seq16622__$1);
});

sodium.core.header = (function sodium$core$header(var_args){
var args__10068__auto__ = [];
var len__10061__auto___16635 = arguments.length;
var i__10062__auto___16636 = (0);
while(true){
if((i__10062__auto___16636 < len__10061__auto___16635)){
args__10068__auto__.push((arguments[i__10062__auto___16636]));

var G__16637 = (i__10062__auto___16636 + (1));
i__10062__auto___16636 = G__16637;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.header.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.header.cljs$core$IFn$_invoke$arity$variadic = (function (p__16632,body__10278__auto__){
var map__16633 = p__16632;
var map__16633__$1 = ((((!((map__16633 == null)))?((((map__16633.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16633.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16633):map__16633);
var params__10277__auto__ = map__16633__$1;
var attached = cljs.core.get.call(null,map__16633__$1,new cljs.core.Keyword(null,"attached","attached",-1212764293));
var subheader = cljs.core.get.call(null,map__16633__$1,new cljs.core.Keyword(null,"subheader","subheader",-1028810273));
var inverted_QMARK_ = cljs.core.get.call(null,map__16633__$1,new cljs.core.Keyword(null,"inverted?","inverted?",-676420704));
var children = cljs.core.get.call(null,map__16633__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var key = cljs.core.get.call(null,map__16633__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var color = cljs.core.get.call(null,map__16633__$1,new cljs.core.Keyword(null,"color","color",1011675173));
var text_align = cljs.core.get.call(null,map__16633__$1,new cljs.core.Keyword(null,"text-align","text-align",1786091845));
var dividing_QMARK_ = cljs.core.get.call(null,map__16633__$1,new cljs.core.Keyword(null,"dividing?","dividing?",-966834650));
var content = cljs.core.get.call(null,map__16633__$1,new cljs.core.Keyword(null,"content","content",15833224));
var as = cljs.core.get.call(null,map__16633__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var sub_QMARK_ = cljs.core.get.call(null,map__16633__$1,new cljs.core.Keyword(null,"sub?","sub?",768712042));
var icon = cljs.core.get.call(null,map__16633__$1,new cljs.core.Keyword(null,"icon","icon",1679606541));
var on_click = cljs.core.get.call(null,map__16633__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var size = cljs.core.get.call(null,map__16633__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var style = cljs.core.get.call(null,map__16633__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var block_QMARK_ = cljs.core.get.call(null,map__16633__$1,new cljs.core.Keyword(null,"block?","block?",1102479923));
var floated = cljs.core.get.call(null,map__16633__$1,new cljs.core.Keyword(null,"floated","floated",739819667));
var id = cljs.core.get.call(null,map__16633__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var class_name = cljs.core.get.call(null,map__16633__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
var image = cljs.core.get.call(null,map__16633__$1,new cljs.core.Keyword(null,"image","image",-58725096));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10277__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [new cljs.core.Keyword(null,"inverted?","inverted?",-676420704),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"color","color",1011675173),null,new cljs.core.Keyword(null,"text-align","text-align",1786091845),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"dividing?","dividing?",-966834650),null,new cljs.core.Keyword(null,"content","content",15833224),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"sub?","sub?",768712042),null,new cljs.core.Keyword(null,"icon","icon",1679606541),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"floated","floated",739819667),null,new cljs.core.Keyword(null,"block?","block?",1102479923),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"image","image",-58725096),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"attached","attached",-1212764293),null,new cljs.core.Keyword(null,"subheader","subheader",-1028810273),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10277__auto__) #{:inverted? :children :color :text-align :key :dividing? :content :as :sub? :icon :on-click :size :style :floated :block? :id :image :class-name :attached :subheader})"));
}

return sodium.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.Header,sodium.utils.camelize_map_keys.call(null,params__10277__auto__)], null),body__10278__auto__);
});

sodium.core.header.cljs$lang$maxFixedArity = (1);

sodium.core.header.cljs$lang$applyTo = (function (seq16630){
var G__16631 = cljs.core.first.call(null,seq16630);
var seq16630__$1 = cljs.core.next.call(null,seq16630);
return sodium.core.header.cljs$core$IFn$_invoke$arity$variadic(G__16631,seq16630__$1);
});

sodium.core.image = (function sodium$core$image(var_args){
var args__10068__auto__ = [];
var len__10061__auto___16643 = arguments.length;
var i__10062__auto___16644 = (0);
while(true){
if((i__10062__auto___16644 < len__10061__auto___16643)){
args__10068__auto__.push((arguments[i__10062__auto___16644]));

var G__16645 = (i__10062__auto___16644 + (1));
i__10062__auto___16644 = G__16645;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.image.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.image.cljs$core$IFn$_invoke$arity$variadic = (function (p__16640,body__10278__auto__){
var map__16641 = p__16640;
var map__16641__$1 = ((((!((map__16641 == null)))?((((map__16641.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16641.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16641):map__16641);
var params__10277__auto__ = map__16641__$1;
var disabled_QMARK_ = cljs.core.get.call(null,map__16641__$1,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181));
var wrapped = cljs.core.get.call(null,map__16641__$1,new cljs.core.Keyword(null,"wrapped","wrapped",1775172701));
var height = cljs.core.get.call(null,map__16641__$1,new cljs.core.Keyword(null,"height","height",1025178622));
var href = cljs.core.get.call(null,map__16641__$1,new cljs.core.Keyword(null,"href","href",-793805698));
var Fluid = cljs.core.get.call(null,map__16641__$1,new cljs.core.Keyword(null,"Fluid","Fluid",1557436705));
var children = cljs.core.get.call(null,map__16641__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var key = cljs.core.get.call(null,map__16641__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var vertical_align = cljs.core.get.call(null,map__16641__$1,new cljs.core.Keyword(null,"vertical-align","vertical-align",651007333));
var alt = cljs.core.get.call(null,map__16641__$1,new cljs.core.Keyword(null,"alt","alt",-3214426));
var ui_QMARK_ = cljs.core.get.call(null,map__16641__$1,new cljs.core.Keyword(null,"ui?","ui?",1139629609));
var avatar_QMARK_ = cljs.core.get.call(null,map__16641__$1,new cljs.core.Keyword(null,"avatar?","avatar?",-195115191));
var as = cljs.core.get.call(null,map__16641__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var width = cljs.core.get.call(null,map__16641__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var spadced = cljs.core.get.call(null,map__16641__$1,new cljs.core.Keyword(null,"spadced","spadced",-1180126901));
var bordered_QMARK_ = cljs.core.get.call(null,map__16641__$1,new cljs.core.Keyword(null,"bordered?","bordered?",562358476));
var src = cljs.core.get.call(null,map__16641__$1,new cljs.core.Keyword(null,"src","src",-1651076051));
var on_click = cljs.core.get.call(null,map__16641__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var size = cljs.core.get.call(null,map__16641__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var dimmer = cljs.core.get.call(null,map__16641__$1,new cljs.core.Keyword(null,"dimmer","dimmer",-938888368));
var style = cljs.core.get.call(null,map__16641__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var inline_QMARK_ = cljs.core.get.call(null,map__16641__$1,new cljs.core.Keyword(null,"inline?","inline?",-1674483791));
var centered_QMARK_ = cljs.core.get.call(null,map__16641__$1,new cljs.core.Keyword(null,"centered?","centered?",-109742703));
var floated = cljs.core.get.call(null,map__16641__$1,new cljs.core.Keyword(null,"floated","floated",739819667));
var label = cljs.core.get.call(null,map__16641__$1,new cljs.core.Keyword(null,"label","label",1718410804));
var id = cljs.core.get.call(null,map__16641__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var shape = cljs.core.get.call(null,map__16641__$1,new cljs.core.Keyword(null,"shape","shape",1190694006));
var class_name = cljs.core.get.call(null,map__16641__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10277__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 27, [new cljs.core.Keyword(null,"Fluid","Fluid",1557436705),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"vertical-align","vertical-align",651007333),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"alt","alt",-3214426),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"ui?","ui?",1139629609),null,new cljs.core.Keyword(null,"avatar?","avatar?",-195115191),null,new cljs.core.Keyword(null,"width","width",-384071477),null,new cljs.core.Keyword(null,"spadced","spadced",-1180126901),null,new cljs.core.Keyword(null,"bordered?","bordered?",562358476),null,new cljs.core.Keyword(null,"src","src",-1651076051),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"dimmer","dimmer",-938888368),null,new cljs.core.Keyword(null,"centered?","centered?",-109742703),null,new cljs.core.Keyword(null,"inline?","inline?",-1674483791),null,new cljs.core.Keyword(null,"floated","floated",739819667),null,new cljs.core.Keyword(null,"label","label",1718410804),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"shape","shape",1190694006),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181),null,new cljs.core.Keyword(null,"wrapped","wrapped",1775172701),null,new cljs.core.Keyword(null,"href","href",-793805698),null,new cljs.core.Keyword(null,"height","height",1025178622),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10277__auto__) #{:Fluid :children :vertical-align :key :alt :as :ui? :avatar? :width :spadced :bordered? :src :on-click :size :style :dimmer :centered? :inline? :floated :label :id :shape :class-name :disabled? :wrapped :href :height})"));
}

return sodium.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.Image,sodium.utils.camelize_map_keys.call(null,params__10277__auto__)], null),body__10278__auto__);
});

sodium.core.image.cljs$lang$maxFixedArity = (1);

sodium.core.image.cljs$lang$applyTo = (function (seq16638){
var G__16639 = cljs.core.first.call(null,seq16638);
var seq16638__$1 = cljs.core.next.call(null,seq16638);
return sodium.core.image.cljs$core$IFn$_invoke$arity$variadic(G__16639,seq16638__$1);
});

sodium.core.icon = (function sodium$core$icon(var_args){
var args__10068__auto__ = [];
var len__10061__auto___16651 = arguments.length;
var i__10062__auto___16652 = (0);
while(true){
if((i__10062__auto___16652 < len__10061__auto___16651)){
args__10068__auto__.push((arguments[i__10062__auto___16652]));

var G__16653 = (i__10062__auto___16652 + (1));
i__10062__auto___16652 = G__16653;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.icon.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.icon.cljs$core$IFn$_invoke$arity$variadic = (function (p__16648,body__10278__auto__){
var map__16649 = p__16648;
var map__16649__$1 = ((((!((map__16649 == null)))?((((map__16649.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16649.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16649):map__16649);
var params__10277__auto__ = map__16649__$1;
var flipped = cljs.core.get.call(null,map__16649__$1,new cljs.core.Keyword(null,"flipped","flipped",567173306));
var disabled_QMARK_ = cljs.core.get.call(null,map__16649__$1,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181));
var inverted_QMARK_ = cljs.core.get.call(null,map__16649__$1,new cljs.core.Keyword(null,"inverted?","inverted?",-676420704));
var children = cljs.core.get.call(null,map__16649__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var rotated = cljs.core.get.call(null,map__16649__$1,new cljs.core.Keyword(null,"rotated","rotated",1509433122));
var corner_QMARK_ = cljs.core.get.call(null,map__16649__$1,new cljs.core.Keyword(null,"corner?","corner?",-1091864636));
var key = cljs.core.get.call(null,map__16649__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var circular_QMARK_ = cljs.core.get.call(null,map__16649__$1,new cljs.core.Keyword(null,"circular?","circular?",-827286875));
var color = cljs.core.get.call(null,map__16649__$1,new cljs.core.Keyword(null,"color","color",1011675173));
var name = cljs.core.get.call(null,map__16649__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var loading_QMARK_ = cljs.core.get.call(null,map__16649__$1,new cljs.core.Keyword(null,"loading?","loading?",1905707049));
var as = cljs.core.get.call(null,map__16649__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var bordered_QMARK_ = cljs.core.get.call(null,map__16649__$1,new cljs.core.Keyword(null,"bordered?","bordered?",562358476));
var on_click = cljs.core.get.call(null,map__16649__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var size = cljs.core.get.call(null,map__16649__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var link_QMARK_ = cljs.core.get.call(null,map__16649__$1,new cljs.core.Keyword(null,"link?","link?",-1241171248));
var style = cljs.core.get.call(null,map__16649__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var id = cljs.core.get.call(null,map__16649__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var fitted_QMARK_ = cljs.core.get.call(null,map__16649__$1,new cljs.core.Keyword(null,"fitted?","fitted?",-1576243243));
var class_name = cljs.core.get.call(null,map__16649__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10277__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [new cljs.core.Keyword(null,"inverted?","inverted?",-676420704),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"rotated","rotated",1509433122),null,new cljs.core.Keyword(null,"corner?","corner?",-1091864636),null,new cljs.core.Keyword(null,"color","color",1011675173),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"circular?","circular?",-827286875),null,new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"loading?","loading?",1905707049),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"bordered?","bordered?",562358476),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"link?","link?",-1241171248),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"fitted?","fitted?",-1576243243),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"flipped","flipped",567173306),null,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10277__auto__) #{:inverted? :children :rotated :corner? :color :key :circular? :name :loading? :as :bordered? :on-click :size :style :link? :id :fitted? :class-name :flipped :disabled?})"));
}

return sodium.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.Icon,sodium.utils.camelize_map_keys.call(null,params__10277__auto__)], null),body__10278__auto__);
});

sodium.core.icon.cljs$lang$maxFixedArity = (1);

sodium.core.icon.cljs$lang$applyTo = (function (seq16646){
var G__16647 = cljs.core.first.call(null,seq16646);
var seq16646__$1 = cljs.core.next.call(null,seq16646);
return sodium.core.icon.cljs$core$IFn$_invoke$arity$variadic(G__16647,seq16646__$1);
});

sodium.core.icon_group = (function sodium$core$icon_group(var_args){
var args__10068__auto__ = [];
var len__10061__auto___16659 = arguments.length;
var i__10062__auto___16660 = (0);
while(true){
if((i__10062__auto___16660 < len__10061__auto___16659)){
args__10068__auto__.push((arguments[i__10062__auto___16660]));

var G__16661 = (i__10062__auto___16660 + (1));
i__10062__auto___16660 = G__16661;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.icon_group.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.icon_group.cljs$core$IFn$_invoke$arity$variadic = (function (p__16656,body__10278__auto__){
var map__16657 = p__16656;
var map__16657__$1 = ((((!((map__16657 == null)))?((((map__16657.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16657.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16657):map__16657);
var params__10277__auto__ = map__16657__$1;
var children = cljs.core.get.call(null,map__16657__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var key = cljs.core.get.call(null,map__16657__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var as = cljs.core.get.call(null,map__16657__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var on_click = cljs.core.get.call(null,map__16657__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var size = cljs.core.get.call(null,map__16657__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var style = cljs.core.get.call(null,map__16657__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var id = cljs.core.get.call(null,map__16657__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var class_name = cljs.core.get.call(null,map__16657__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10277__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10277__auto__) #{:children :key :as :on-click :size :style :id :class-name})"));
}

return sodium.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.IconGroup,sodium.utils.camelize_map_keys.call(null,params__10277__auto__)], null),body__10278__auto__);
});

sodium.core.icon_group.cljs$lang$maxFixedArity = (1);

sodium.core.icon_group.cljs$lang$applyTo = (function (seq16654){
var G__16655 = cljs.core.first.call(null,seq16654);
var seq16654__$1 = cljs.core.next.call(null,seq16654);
return sodium.core.icon_group.cljs$core$IFn$_invoke$arity$variadic(G__16655,seq16654__$1);
});

sodium.core.input = (function sodium$core$input(var_args){
var args__10068__auto__ = [];
var len__10061__auto___16667 = arguments.length;
var i__10062__auto___16668 = (0);
while(true){
if((i__10062__auto___16668 < len__10061__auto___16667)){
args__10068__auto__.push((arguments[i__10062__auto___16668]));

var G__16669 = (i__10062__auto___16668 + (1));
i__10062__auto___16668 = G__16669;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.input.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.input.cljs$core$IFn$_invoke$arity$variadic = (function (p__16664,body__10278__auto__){
var map__16665 = p__16664;
var map__16665__$1 = ((((!((map__16665 == null)))?((((map__16665.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16665.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16665):map__16665);
var params__10277__auto__ = map__16665__$1;
var input = cljs.core.get.call(null,map__16665__$1,new cljs.core.Keyword(null,"input","input",556931961));
var action_position = cljs.core.get.call(null,map__16665__$1,new cljs.core.Keyword(null,"action-position","action-position",-704217959));
var error_QMARK_ = cljs.core.get.call(null,map__16665__$1,new cljs.core.Keyword(null,"error?","error?",-460689159));
var disabled_QMARK_ = cljs.core.get.call(null,map__16665__$1,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181));
var on_change = cljs.core.get.call(null,map__16665__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
var step = cljs.core.get.call(null,map__16665__$1,new cljs.core.Keyword(null,"step","step",1288888124));
var fluid_QMARK_ = cljs.core.get.call(null,map__16665__$1,new cljs.core.Keyword(null,"fluid?","fluid?",-742121890));
var label_position = cljs.core.get.call(null,map__16665__$1,new cljs.core.Keyword(null,"label-position","label-position",-1546831329));
var inverted_QMARK_ = cljs.core.get.call(null,map__16665__$1,new cljs.core.Keyword(null,"inverted?","inverted?",-676420704));
var tab_index = cljs.core.get.call(null,map__16665__$1,new cljs.core.Keyword(null,"tab-index","tab-index",895755393));
var children = cljs.core.get.call(null,map__16665__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var required_QMARK_ = cljs.core.get.call(null,map__16665__$1,new cljs.core.Keyword(null,"required?","required?",-872514462));
var key = cljs.core.get.call(null,map__16665__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var placeholder = cljs.core.get.call(null,map__16665__$1,new cljs.core.Keyword(null,"placeholder","placeholder",-104873083));
var icon_position = cljs.core.get.call(null,map__16665__$1,new cljs.core.Keyword(null,"icon-position","icon-position",-1720359034));
var focus_QMARK_ = cljs.core.get.call(null,map__16665__$1,new cljs.core.Keyword(null,"focus?","focus?",-3018488));
var value = cljs.core.get.call(null,map__16665__$1,new cljs.core.Keyword(null,"value","value",305978217));
var as = cljs.core.get.call(null,map__16665__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var default_value = cljs.core.get.call(null,map__16665__$1,new cljs.core.Keyword(null,"default-value","default-value",232220170));
var width = cljs.core.get.call(null,map__16665__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var transparent_QMARK_ = cljs.core.get.call(null,map__16665__$1,new cljs.core.Keyword(null,"transparent?","transparent?",-1446050548));
var type = cljs.core.get.call(null,map__16665__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var icon = cljs.core.get.call(null,map__16665__$1,new cljs.core.Keyword(null,"icon","icon",1679606541));
var on_click = cljs.core.get.call(null,map__16665__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var size = cljs.core.get.call(null,map__16665__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var style = cljs.core.get.call(null,map__16665__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var inline_QMARK_ = cljs.core.get.call(null,map__16665__$1,new cljs.core.Keyword(null,"inline?","inline?",-1674483791));
var list = cljs.core.get.call(null,map__16665__$1,new cljs.core.Keyword(null,"list","list",765357683));
var loading = cljs.core.get.call(null,map__16665__$1,new cljs.core.Keyword(null,"loading","loading",-737050189));
var label = cljs.core.get.call(null,map__16665__$1,new cljs.core.Keyword(null,"label","label",1718410804));
var id = cljs.core.get.call(null,map__16665__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var control = cljs.core.get.call(null,map__16665__$1,new cljs.core.Keyword(null,"control","control",1892578036));
var class_name = cljs.core.get.call(null,map__16665__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
var action = cljs.core.get.call(null,map__16665__$1,new cljs.core.Keyword(null,"action","action",-811238024));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10277__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 34, [new cljs.core.Keyword(null,"inverted?","inverted?",-676420704),null,new cljs.core.Keyword(null,"tab-index","tab-index",895755393),null,new cljs.core.Keyword(null,"required?","required?",-872514462),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),null,new cljs.core.Keyword(null,"icon-position","icon-position",-1720359034),null,new cljs.core.Keyword(null,"focus?","focus?",-3018488),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"value","value",305978217),null,new cljs.core.Keyword(null,"default-value","default-value",232220170),null,new cljs.core.Keyword(null,"width","width",-384071477),null,new cljs.core.Keyword(null,"transparent?","transparent?",-1446050548),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"icon","icon",1679606541),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"inline?","inline?",-1674483791),null,new cljs.core.Keyword(null,"loading","loading",-737050189),null,new cljs.core.Keyword(null,"list","list",765357683),null,new cljs.core.Keyword(null,"label","label",1718410804),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"control","control",1892578036),null,new cljs.core.Keyword(null,"action","action",-811238024),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"action-position","action-position",-704217959),null,new cljs.core.Keyword(null,"error?","error?",-460689159),null,new cljs.core.Keyword(null,"input","input",556931961),null,new cljs.core.Keyword(null,"on-change","on-change",-732046149),null,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181),null,new cljs.core.Keyword(null,"step","step",1288888124),null,new cljs.core.Keyword(null,"fluid?","fluid?",-742121890),null,new cljs.core.Keyword(null,"label-position","label-position",-1546831329),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10277__auto__) #{:inverted? :tab-index :required? :children :key :placeholder :icon-position :focus? :as :value :default-value :width :transparent? :type :icon :on-click :size :style :inline? :loading :list :label :id :control :action :class-name :action-position :error? :input :on-change :disabled? :step :fluid? :label-position})"));
}

return sodium.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.Input,sodium.utils.camelize_map_keys.call(null,params__10277__auto__)], null),body__10278__auto__);
});

sodium.core.input.cljs$lang$maxFixedArity = (1);

sodium.core.input.cljs$lang$applyTo = (function (seq16662){
var G__16663 = cljs.core.first.call(null,seq16662);
var seq16662__$1 = cljs.core.next.call(null,seq16662);
return sodium.core.input.cljs$core$IFn$_invoke$arity$variadic(G__16663,seq16662__$1);
});

sodium.core.label = (function sodium$core$label(var_args){
var args__10068__auto__ = [];
var len__10061__auto___16675 = arguments.length;
var i__10062__auto___16676 = (0);
while(true){
if((i__10062__auto___16676 < len__10061__auto___16675)){
args__10068__auto__.push((arguments[i__10062__auto___16676]));

var G__16677 = (i__10062__auto___16676 + (1));
i__10062__auto___16676 = G__16677;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.label.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.label.cljs$core$IFn$_invoke$arity$variadic = (function (p__16672,body__10278__auto__){
var map__16673 = p__16672;
var map__16673__$1 = ((((!((map__16673 == null)))?((((map__16673.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16673.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16673):map__16673);
var params__10277__auto__ = map__16673__$1;
var attached = cljs.core.get.call(null,map__16673__$1,new cljs.core.Keyword(null,"attached","attached",-1212764293));
var tag_QMARK_ = cljs.core.get.call(null,map__16673__$1,new cljs.core.Keyword(null,"tag?","tag?",1714008252));
var on_remove = cljs.core.get.call(null,map__16673__$1,new cljs.core.Keyword(null,"on-remove","on-remove",-268656163));
var detail = cljs.core.get.call(null,map__16673__$1,new cljs.core.Keyword(null,"detail","detail",-1545345025));
var ribbon = cljs.core.get.call(null,map__16673__$1,new cljs.core.Keyword(null,"ribbon","ribbon",-737080896));
var active_QMARK_ = cljs.core.get.call(null,map__16673__$1,new cljs.core.Keyword(null,"active?","active?",459499776));
var horizontal_QMARK_ = cljs.core.get.call(null,map__16673__$1,new cljs.core.Keyword(null,"horizontal?","horizontal?",-423282271));
var children = cljs.core.get.call(null,map__16673__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var pointing = cljs.core.get.call(null,map__16673__$1,new cljs.core.Keyword(null,"pointing","pointing",-1869969692));
var key = cljs.core.get.call(null,map__16673__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var circular_QMARK_ = cljs.core.get.call(null,map__16673__$1,new cljs.core.Keyword(null,"circular?","circular?",-827286875));
var color = cljs.core.get.call(null,map__16673__$1,new cljs.core.Keyword(null,"color","color",1011675173));
var corner = cljs.core.get.call(null,map__16673__$1,new cljs.core.Keyword(null,"corner","corner",1296717125));
var remove_icon = cljs.core.get.call(null,map__16673__$1,new cljs.core.Keyword(null,"remove-icon","remove-icon",885625702));
var content = cljs.core.get.call(null,map__16673__$1,new cljs.core.Keyword(null,"content","content",15833224));
var floating_QMARK_ = cljs.core.get.call(null,map__16673__$1,new cljs.core.Keyword(null,"floating?","floating?",509059561));
var as = cljs.core.get.call(null,map__16673__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var icon = cljs.core.get.call(null,map__16673__$1,new cljs.core.Keyword(null,"icon","icon",1679606541));
var basic_QMARK_ = cljs.core.get.call(null,map__16673__$1,new cljs.core.Keyword(null,"basic?","basic?",-2093501395));
var empty = cljs.core.get.call(null,map__16673__$1,new cljs.core.Keyword(null,"empty","empty",767870958));
var on_click = cljs.core.get.call(null,map__16673__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var size = cljs.core.get.call(null,map__16673__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var style = cljs.core.get.call(null,map__16673__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var id = cljs.core.get.call(null,map__16673__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var class_name = cljs.core.get.call(null,map__16673__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
var image = cljs.core.get.call(null,map__16673__$1,new cljs.core.Keyword(null,"image","image",-58725096));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10277__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 26, [new cljs.core.Keyword(null,"active?","active?",459499776),null,new cljs.core.Keyword(null,"ribbon","ribbon",-737080896),null,new cljs.core.Keyword(null,"horizontal?","horizontal?",-423282271),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"pointing","pointing",-1869969692),null,new cljs.core.Keyword(null,"color","color",1011675173),null,new cljs.core.Keyword(null,"corner","corner",1296717125),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"circular?","circular?",-827286875),null,new cljs.core.Keyword(null,"remove-icon","remove-icon",885625702),null,new cljs.core.Keyword(null,"content","content",15833224),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"floating?","floating?",509059561),null,new cljs.core.Keyword(null,"basic?","basic?",-2093501395),null,new cljs.core.Keyword(null,"icon","icon",1679606541),null,new cljs.core.Keyword(null,"empty","empty",767870958),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"image","image",-58725096),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"attached","attached",-1212764293),null,new cljs.core.Keyword(null,"tag?","tag?",1714008252),null,new cljs.core.Keyword(null,"on-remove","on-remove",-268656163),null,new cljs.core.Keyword(null,"detail","detail",-1545345025),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10277__auto__) #{:active? :ribbon :horizontal? :children :pointing :color :corner :key :circular? :remove-icon :content :as :floating? :basic? :icon :empty :on-click :size :style :id :image :class-name :attached :tag? :on-remove :detail})"));
}

return sodium.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.Label,sodium.utils.camelize_map_keys.call(null,params__10277__auto__)], null),body__10278__auto__);
});

sodium.core.label.cljs$lang$maxFixedArity = (1);

sodium.core.label.cljs$lang$applyTo = (function (seq16670){
var G__16671 = cljs.core.first.call(null,seq16670);
var seq16670__$1 = cljs.core.next.call(null,seq16670);
return sodium.core.label.cljs$core$IFn$_invoke$arity$variadic(G__16671,seq16670__$1);
});

sodium.core.list_na = (function sodium$core$list_na(var_args){
var args__10068__auto__ = [];
var len__10061__auto___16683 = arguments.length;
var i__10062__auto___16684 = (0);
while(true){
if((i__10062__auto___16684 < len__10061__auto___16683)){
args__10068__auto__.push((arguments[i__10062__auto___16684]));

var G__16685 = (i__10062__auto___16684 + (1));
i__10062__auto___16684 = G__16685;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.list_na.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.list_na.cljs$core$IFn$_invoke$arity$variadic = (function (p__16680,body__10278__auto__){
var map__16681 = p__16680;
var map__16681__$1 = ((((!((map__16681 == null)))?((((map__16681.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16681.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16681):map__16681);
var params__10277__auto__ = map__16681__$1;
var items = cljs.core.get.call(null,map__16681__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var divided_QMARK_ = cljs.core.get.call(null,map__16681__$1,new cljs.core.Keyword(null,"divided?","divided?",-706929476));
var relaxed = cljs.core.get.call(null,map__16681__$1,new cljs.core.Keyword(null,"relaxed","relaxed",-939075907));
var ordered_QMARK_ = cljs.core.get.call(null,map__16681__$1,new cljs.core.Keyword(null,"ordered?","ordered?",812162688));
var inverted_QMARK_ = cljs.core.get.call(null,map__16681__$1,new cljs.core.Keyword(null,"inverted?","inverted?",-676420704));
var horizontal_QMARK_ = cljs.core.get.call(null,map__16681__$1,new cljs.core.Keyword(null,"horizontal?","horizontal?",-423282271));
var children = cljs.core.get.call(null,map__16681__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var bulleted_QMARK_ = cljs.core.get.call(null,map__16681__$1,new cljs.core.Keyword(null,"bulleted?","bulleted?",680239204));
var animated_QMARK_ = cljs.core.get.call(null,map__16681__$1,new cljs.core.Keyword(null,"animated?","animated?",-1143981820));
var key = cljs.core.get.call(null,map__16681__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var on_item_click = cljs.core.get.call(null,map__16681__$1,new cljs.core.Keyword(null,"on-item-click","on-item-click",-1809586363));
var vertical_align = cljs.core.get.call(null,map__16681__$1,new cljs.core.Keyword(null,"vertical-align","vertical-align",651007333));
var as = cljs.core.get.call(null,map__16681__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var selection_QMARK_ = cljs.core.get.call(null,map__16681__$1,new cljs.core.Keyword(null,"selection?","selection?",804764555));
var on_click = cljs.core.get.call(null,map__16681__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var size = cljs.core.get.call(null,map__16681__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var link_QMARK_ = cljs.core.get.call(null,map__16681__$1,new cljs.core.Keyword(null,"link?","link?",-1241171248));
var style = cljs.core.get.call(null,map__16681__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var floated = cljs.core.get.call(null,map__16681__$1,new cljs.core.Keyword(null,"floated","floated",739819667));
var id = cljs.core.get.call(null,map__16681__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var celled_QMARK_ = cljs.core.get.call(null,map__16681__$1,new cljs.core.Keyword(null,"celled?","celled?",-266703115));
var class_name = cljs.core.get.call(null,map__16681__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10277__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 22, [new cljs.core.Keyword(null,"ordered?","ordered?",812162688),null,new cljs.core.Keyword(null,"inverted?","inverted?",-676420704),null,new cljs.core.Keyword(null,"horizontal?","horizontal?",-423282271),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"bulleted?","bulleted?",680239204),null,new cljs.core.Keyword(null,"animated?","animated?",-1143981820),null,new cljs.core.Keyword(null,"vertical-align","vertical-align",651007333),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"on-item-click","on-item-click",-1809586363),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"selection?","selection?",804764555),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"link?","link?",-1241171248),null,new cljs.core.Keyword(null,"floated","floated",739819667),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"celled?","celled?",-266703115),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"items","items",1031954938),null,new cljs.core.Keyword(null,"divided?","divided?",-706929476),null,new cljs.core.Keyword(null,"relaxed","relaxed",-939075907),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10277__auto__) #{:ordered? :inverted? :horizontal? :children :bulleted? :animated? :vertical-align :key :on-item-click :as :selection? :on-click :size :style :link? :floated :id :celled? :class-name :items :divided? :relaxed})"));
}

return sodium.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.ListSA,sodium.utils.camelize_map_keys.call(null,params__10277__auto__)], null),body__10278__auto__);
});

sodium.core.list_na.cljs$lang$maxFixedArity = (1);

sodium.core.list_na.cljs$lang$applyTo = (function (seq16678){
var G__16679 = cljs.core.first.call(null,seq16678);
var seq16678__$1 = cljs.core.next.call(null,seq16678);
return sodium.core.list_na.cljs$core$IFn$_invoke$arity$variadic(G__16679,seq16678__$1);
});

sodium.core.list_item = (function sodium$core$list_item(var_args){
var args__10068__auto__ = [];
var len__10061__auto___16691 = arguments.length;
var i__10062__auto___16692 = (0);
while(true){
if((i__10062__auto___16692 < len__10061__auto___16691)){
args__10068__auto__.push((arguments[i__10062__auto___16692]));

var G__16693 = (i__10062__auto___16692 + (1));
i__10062__auto___16692 = G__16693;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.list_item.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.list_item.cljs$core$IFn$_invoke$arity$variadic = (function (p__16688,body__10278__auto__){
var map__16689 = p__16688;
var map__16689__$1 = ((((!((map__16689 == null)))?((((map__16689.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16689.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16689):map__16689);
var params__10277__auto__ = map__16689__$1;
var disabled_QMARK_ = cljs.core.get.call(null,map__16689__$1,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181));
var active_QMARK_ = cljs.core.get.call(null,map__16689__$1,new cljs.core.Keyword(null,"active?","active?",459499776));
var description = cljs.core.get.call(null,map__16689__$1,new cljs.core.Keyword(null,"description","description",-1428560544));
var children = cljs.core.get.call(null,map__16689__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var key = cljs.core.get.call(null,map__16689__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var content = cljs.core.get.call(null,map__16689__$1,new cljs.core.Keyword(null,"content","content",15833224));
var value = cljs.core.get.call(null,map__16689__$1,new cljs.core.Keyword(null,"value","value",305978217));
var as = cljs.core.get.call(null,map__16689__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var icon = cljs.core.get.call(null,map__16689__$1,new cljs.core.Keyword(null,"icon","icon",1679606541));
var header = cljs.core.get.call(null,map__16689__$1,new cljs.core.Keyword(null,"header","header",119441134));
var on_click = cljs.core.get.call(null,map__16689__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var style = cljs.core.get.call(null,map__16689__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var id = cljs.core.get.call(null,map__16689__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var class_name = cljs.core.get.call(null,map__16689__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
var image = cljs.core.get.call(null,map__16689__$1,new cljs.core.Keyword(null,"image","image",-58725096));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10277__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, [new cljs.core.Keyword(null,"active?","active?",459499776),null,new cljs.core.Keyword(null,"description","description",-1428560544),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"content","content",15833224),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"value","value",305978217),null,new cljs.core.Keyword(null,"icon","icon",1679606541),null,new cljs.core.Keyword(null,"header","header",119441134),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"image","image",-58725096),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10277__auto__) #{:active? :description :children :key :content :as :value :icon :header :on-click :style :id :image :class-name :disabled?})"));
}

return sodium.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.ListItem,sodium.utils.camelize_map_keys.call(null,params__10277__auto__)], null),body__10278__auto__);
});

sodium.core.list_item.cljs$lang$maxFixedArity = (1);

sodium.core.list_item.cljs$lang$applyTo = (function (seq16686){
var G__16687 = cljs.core.first.call(null,seq16686);
var seq16686__$1 = cljs.core.next.call(null,seq16686);
return sodium.core.list_item.cljs$core$IFn$_invoke$arity$variadic(G__16687,seq16686__$1);
});

sodium.core.menu = (function sodium$core$menu(var_args){
var args__10068__auto__ = [];
var len__10061__auto___16699 = arguments.length;
var i__10062__auto___16700 = (0);
while(true){
if((i__10062__auto___16700 < len__10061__auto___16699)){
args__10068__auto__.push((arguments[i__10062__auto___16700]));

var G__16701 = (i__10062__auto___16700 + (1));
i__10062__auto___16700 = G__16701;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.menu.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.menu.cljs$core$IFn$_invoke$arity$variadic = (function (p__16696,body__10278__auto__){
var map__16697 = p__16696;
var map__16697__$1 = ((((!((map__16697 == null)))?((((map__16697.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16697.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16697):map__16697);
var params__10277__auto__ = map__16697__$1;
var items = cljs.core.get.call(null,map__16697__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var fixed = cljs.core.get.call(null,map__16697__$1,new cljs.core.Keyword(null,"fixed","fixed",-562004358));
var secondary_QMARK_ = cljs.core.get.call(null,map__16697__$1,new cljs.core.Keyword(null,"secondary?","secondary?",357634042));
var attached = cljs.core.get.call(null,map__16697__$1,new cljs.core.Keyword(null,"attached","attached",-1212764293));
var fluid_QMARK_ = cljs.core.get.call(null,map__16697__$1,new cljs.core.Keyword(null,"fluid?","fluid?",-742121890));
var inverted_QMARK_ = cljs.core.get.call(null,map__16697__$1,new cljs.core.Keyword(null,"inverted?","inverted?",-676420704));
var active_index = cljs.core.get.call(null,map__16697__$1,new cljs.core.Keyword(null,"active-index","active-index",864399296));
var text_QMARK_ = cljs.core.get.call(null,map__16697__$1,new cljs.core.Keyword(null,"text?","text?",-934411583));
var tabular_QMARK_ = cljs.core.get.call(null,map__16697__$1,new cljs.core.Keyword(null,"tabular?","tabular?",-1146013791));
var children = cljs.core.get.call(null,map__16697__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var borderless_QMARK_ = cljs.core.get.call(null,map__16697__$1,new cljs.core.Keyword(null,"borderless?","borderless?",-732642494));
var stackable_QMARK_ = cljs.core.get.call(null,map__16697__$1,new cljs.core.Keyword(null,"stackable?","stackable?",-1877083005));
var key = cljs.core.get.call(null,map__16697__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var on_item_click = cljs.core.get.call(null,map__16697__$1,new cljs.core.Keyword(null,"on-item-click","on-item-click",-1809586363));
var color = cljs.core.get.call(null,map__16697__$1,new cljs.core.Keyword(null,"color","color",1011675173));
var as = cljs.core.get.call(null,map__16697__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var icon = cljs.core.get.call(null,map__16697__$1,new cljs.core.Keyword(null,"icon","icon",1679606541));
var on_click = cljs.core.get.call(null,map__16697__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var size = cljs.core.get.call(null,map__16697__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var widths = cljs.core.get.call(null,map__16697__$1,new cljs.core.Keyword(null,"widths","widths",-1467327440));
var pointing_QMARK_ = cljs.core.get.call(null,map__16697__$1,new cljs.core.Keyword(null,"pointing?","pointing?",2129239216));
var style = cljs.core.get.call(null,map__16697__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var compact_QMARK_ = cljs.core.get.call(null,map__16697__$1,new cljs.core.Keyword(null,"compact?","compact?",1216893298));
var floated = cljs.core.get.call(null,map__16697__$1,new cljs.core.Keyword(null,"floated","floated",739819667));
var id = cljs.core.get.call(null,map__16697__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var vertical_QMARK_ = cljs.core.get.call(null,map__16697__$1,new cljs.core.Keyword(null,"vertical?","vertical?",-1522630444));
var pagination_QMARK_ = cljs.core.get.call(null,map__16697__$1,new cljs.core.Keyword(null,"pagination?","pagination?",-1661715944));
var default_active_index = cljs.core.get.call(null,map__16697__$1,new cljs.core.Keyword(null,"default-active-index","default-active-index",1260382968));
var class_name = cljs.core.get.call(null,map__16697__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10277__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 29, [new cljs.core.Keyword(null,"inverted?","inverted?",-676420704),null,new cljs.core.Keyword(null,"active-index","active-index",864399296),null,new cljs.core.Keyword(null,"text?","text?",-934411583),null,new cljs.core.Keyword(null,"tabular?","tabular?",-1146013791),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"borderless?","borderless?",-732642494),null,new cljs.core.Keyword(null,"stackable?","stackable?",-1877083005),null,new cljs.core.Keyword(null,"color","color",1011675173),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"on-item-click","on-item-click",-1809586363),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"icon","icon",1679606541),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"widths","widths",-1467327440),null,new cljs.core.Keyword(null,"pointing?","pointing?",2129239216),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"compact?","compact?",1216893298),null,new cljs.core.Keyword(null,"floated","floated",739819667),null,new cljs.core.Keyword(null,"vertical?","vertical?",-1522630444),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"pagination?","pagination?",-1661715944),null,new cljs.core.Keyword(null,"default-active-index","default-active-index",1260382968),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"items","items",1031954938),null,new cljs.core.Keyword(null,"fixed","fixed",-562004358),null,new cljs.core.Keyword(null,"secondary?","secondary?",357634042),null,new cljs.core.Keyword(null,"attached","attached",-1212764293),null,new cljs.core.Keyword(null,"fluid?","fluid?",-742121890),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10277__auto__) #{:inverted? :active-index :text? :tabular? :children :borderless? :stackable? :color :key :on-item-click :as :icon :on-click :size :widths :pointing? :style :compact? :floated :vertical? :id :pagination? :default-active-index :class-name :items :fixed :secondary? :attached :fluid?})"));
}

return sodium.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.Menu,sodium.utils.camelize_map_keys.call(null,params__10277__auto__)], null),body__10278__auto__);
});

sodium.core.menu.cljs$lang$maxFixedArity = (1);

sodium.core.menu.cljs$lang$applyTo = (function (seq16694){
var G__16695 = cljs.core.first.call(null,seq16694);
var seq16694__$1 = cljs.core.next.call(null,seq16694);
return sodium.core.menu.cljs$core$IFn$_invoke$arity$variadic(G__16695,seq16694__$1);
});

sodium.core.menu_header = (function sodium$core$menu_header(var_args){
var args__10068__auto__ = [];
var len__10061__auto___16707 = arguments.length;
var i__10062__auto___16708 = (0);
while(true){
if((i__10062__auto___16708 < len__10061__auto___16707)){
args__10068__auto__.push((arguments[i__10062__auto___16708]));

var G__16709 = (i__10062__auto___16708 + (1));
i__10062__auto___16708 = G__16709;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.menu_header.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.menu_header.cljs$core$IFn$_invoke$arity$variadic = (function (p__16704,body__10278__auto__){
var map__16705 = p__16704;
var map__16705__$1 = ((((!((map__16705 == null)))?((((map__16705.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16705.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16705):map__16705);
var params__10277__auto__ = map__16705__$1;
var children = cljs.core.get.call(null,map__16705__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var key = cljs.core.get.call(null,map__16705__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var content = cljs.core.get.call(null,map__16705__$1,new cljs.core.Keyword(null,"content","content",15833224));
var as = cljs.core.get.call(null,map__16705__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var on_click = cljs.core.get.call(null,map__16705__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var style = cljs.core.get.call(null,map__16705__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var id = cljs.core.get.call(null,map__16705__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var class_name = cljs.core.get.call(null,map__16705__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10277__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"content","content",15833224),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10277__auto__) #{:children :key :content :as :on-click :style :id :class-name})"));
}

return sodium.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.MenuHeader,sodium.utils.camelize_map_keys.call(null,params__10277__auto__)], null),body__10278__auto__);
});

sodium.core.menu_header.cljs$lang$maxFixedArity = (1);

sodium.core.menu_header.cljs$lang$applyTo = (function (seq16702){
var G__16703 = cljs.core.first.call(null,seq16702);
var seq16702__$1 = cljs.core.next.call(null,seq16702);
return sodium.core.menu_header.cljs$core$IFn$_invoke$arity$variadic(G__16703,seq16702__$1);
});

sodium.core.menu_item = (function sodium$core$menu_item(var_args){
var args__10068__auto__ = [];
var len__10061__auto___16715 = arguments.length;
var i__10062__auto___16716 = (0);
while(true){
if((i__10062__auto___16716 < len__10061__auto___16715)){
args__10068__auto__.push((arguments[i__10062__auto___16716]));

var G__16717 = (i__10062__auto___16716 + (1));
i__10062__auto___16716 = G__16717;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.menu_item.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.menu_item.cljs$core$IFn$_invoke$arity$variadic = (function (p__16712,body__10278__auto__){
var map__16713 = p__16712;
var map__16713__$1 = ((((!((map__16713 == null)))?((((map__16713.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16713.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16713):map__16713);
var params__10277__auto__ = map__16713__$1;
var disabled_QMARK_ = cljs.core.get.call(null,map__16713__$1,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181));
var fitted = cljs.core.get.call(null,map__16713__$1,new cljs.core.Keyword(null,"fitted","fitted",531153693));
var active_QMARK_ = cljs.core.get.call(null,map__16713__$1,new cljs.core.Keyword(null,"active?","active?",459499776));
var children = cljs.core.get.call(null,map__16713__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var key = cljs.core.get.call(null,map__16713__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var index = cljs.core.get.call(null,map__16713__$1,new cljs.core.Keyword(null,"index","index",-1531685915));
var color = cljs.core.get.call(null,map__16713__$1,new cljs.core.Keyword(null,"color","color",1011675173));
var content = cljs.core.get.call(null,map__16713__$1,new cljs.core.Keyword(null,"content","content",15833224));
var name = cljs.core.get.call(null,map__16713__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var as = cljs.core.get.call(null,map__16713__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var header_QMARK_ = cljs.core.get.call(null,map__16713__$1,new cljs.core.Keyword(null,"header?","header?",-106649173));
var icon = cljs.core.get.call(null,map__16713__$1,new cljs.core.Keyword(null,"icon","icon",1679606541));
var on_click = cljs.core.get.call(null,map__16713__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var link_QMARK_ = cljs.core.get.call(null,map__16713__$1,new cljs.core.Keyword(null,"link?","link?",-1241171248));
var style = cljs.core.get.call(null,map__16713__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var id = cljs.core.get.call(null,map__16713__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var class_name = cljs.core.get.call(null,map__16713__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
var position = cljs.core.get.call(null,map__16713__$1,new cljs.core.Keyword(null,"position","position",-2011731912));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10277__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [new cljs.core.Keyword(null,"active?","active?",459499776),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"color","color",1011675173),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"index","index",-1531685915),null,new cljs.core.Keyword(null,"content","content",15833224),null,new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"header?","header?",-106649173),null,new cljs.core.Keyword(null,"icon","icon",1679606541),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"link?","link?",-1241171248),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"position","position",-2011731912),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181),null,new cljs.core.Keyword(null,"fitted","fitted",531153693),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10277__auto__) #{:active? :children :color :key :index :content :name :as :header? :icon :on-click :style :link? :id :position :class-name :disabled? :fitted})"));
}

return sodium.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.MenuItem,sodium.utils.camelize_map_keys.call(null,params__10277__auto__)], null),body__10278__auto__);
});

sodium.core.menu_item.cljs$lang$maxFixedArity = (1);

sodium.core.menu_item.cljs$lang$applyTo = (function (seq16710){
var G__16711 = cljs.core.first.call(null,seq16710);
var seq16710__$1 = cljs.core.next.call(null,seq16710);
return sodium.core.menu_item.cljs$core$IFn$_invoke$arity$variadic(G__16711,seq16710__$1);
});

sodium.core.menu_menu = (function sodium$core$menu_menu(var_args){
var args__10068__auto__ = [];
var len__10061__auto___16723 = arguments.length;
var i__10062__auto___16724 = (0);
while(true){
if((i__10062__auto___16724 < len__10061__auto___16723)){
args__10068__auto__.push((arguments[i__10062__auto___16724]));

var G__16725 = (i__10062__auto___16724 + (1));
i__10062__auto___16724 = G__16725;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.menu_menu.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.menu_menu.cljs$core$IFn$_invoke$arity$variadic = (function (p__16720,body__10278__auto__){
var map__16721 = p__16720;
var map__16721__$1 = ((((!((map__16721 == null)))?((((map__16721.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16721.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16721):map__16721);
var params__10277__auto__ = map__16721__$1;
var children = cljs.core.get.call(null,map__16721__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var key = cljs.core.get.call(null,map__16721__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var as = cljs.core.get.call(null,map__16721__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var on_click = cljs.core.get.call(null,map__16721__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var style = cljs.core.get.call(null,map__16721__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var id = cljs.core.get.call(null,map__16721__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var class_name = cljs.core.get.call(null,map__16721__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
var position = cljs.core.get.call(null,map__16721__$1,new cljs.core.Keyword(null,"position","position",-2011731912));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10277__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"position","position",-2011731912),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10277__auto__) #{:children :key :as :on-click :style :id :position :class-name})"));
}

return sodium.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.MenuMenu,sodium.utils.camelize_map_keys.call(null,params__10277__auto__)], null),body__10278__auto__);
});

sodium.core.menu_menu.cljs$lang$maxFixedArity = (1);

sodium.core.menu_menu.cljs$lang$applyTo = (function (seq16718){
var G__16719 = cljs.core.first.call(null,seq16718);
var seq16718__$1 = cljs.core.next.call(null,seq16718);
return sodium.core.menu_menu.cljs$core$IFn$_invoke$arity$variadic(G__16719,seq16718__$1);
});

sodium.core.modal = (function sodium$core$modal(var_args){
var args__10068__auto__ = [];
var len__10061__auto___16731 = arguments.length;
var i__10062__auto___16732 = (0);
while(true){
if((i__10062__auto___16732 < len__10061__auto___16731)){
args__10068__auto__.push((arguments[i__10062__auto___16732]));

var G__16733 = (i__10062__auto___16732 + (1));
i__10062__auto___16732 = G__16733;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.modal.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.modal.cljs$core$IFn$_invoke$arity$variadic = (function (p__16728,body__10278__auto__){
var map__16729 = p__16728;
var map__16729__$1 = ((((!((map__16729 == null)))?((((map__16729.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16729.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16729):map__16729);
var params__10277__auto__ = map__16729__$1;
var mount_node = cljs.core.get.call(null,map__16729__$1,new cljs.core.Keyword(null,"mount-node","mount-node",1448014937));
var on_open = cljs.core.get.call(null,map__16729__$1,new cljs.core.Keyword(null,"on-open","on-open",-1391088163));
var close_on_dimmer_click_QMARK_ = cljs.core.get.call(null,map__16729__$1,new cljs.core.Keyword(null,"close-on-dimmer-click?","close-on-dimmer-click?",-1661039169));
var on_mount = cljs.core.get.call(null,map__16729__$1,new cljs.core.Keyword(null,"on-mount","on-mount",-1236735840));
var close_on_document_click_QMARK_ = cljs.core.get.call(null,map__16729__$1,new cljs.core.Keyword(null,"close-on-document-click?","close-on-document-click?",-948414079));
var children = cljs.core.get.call(null,map__16729__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var on_action_click = cljs.core.get.call(null,map__16729__$1,new cljs.core.Keyword(null,"on-action-click","on-action-click",1894902179));
var event_pool = cljs.core.get.call(null,map__16729__$1,new cljs.core.Keyword(null,"event-pool","event-pool",302831908));
var key = cljs.core.get.call(null,map__16729__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var on_close = cljs.core.get.call(null,map__16729__$1,new cljs.core.Keyword(null,"on-close","on-close",-761178394));
var content = cljs.core.get.call(null,map__16729__$1,new cljs.core.Keyword(null,"content","content",15833224));
var as = cljs.core.get.call(null,map__16729__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var close_icon = cljs.core.get.call(null,map__16729__$1,new cljs.core.Keyword(null,"close-icon","close-icon",-659435027));
var basic_QMARK_ = cljs.core.get.call(null,map__16729__$1,new cljs.core.Keyword(null,"basic?","basic?",-2093501395));
var header = cljs.core.get.call(null,map__16729__$1,new cljs.core.Keyword(null,"header","header",119441134));
var actions = cljs.core.get.call(null,map__16729__$1,new cljs.core.Keyword(null,"actions","actions",-812656882));
var on_click = cljs.core.get.call(null,map__16729__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var size = cljs.core.get.call(null,map__16729__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var dimmer = cljs.core.get.call(null,map__16729__$1,new cljs.core.Keyword(null,"dimmer","dimmer",-938888368));
var style = cljs.core.get.call(null,map__16729__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var id = cljs.core.get.call(null,map__16729__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var on_unmount = cljs.core.get.call(null,map__16729__$1,new cljs.core.Keyword(null,"on-unmount","on-unmount",245689269));
var open_QMARK_ = cljs.core.get.call(null,map__16729__$1,new cljs.core.Keyword(null,"open?","open?",1238443125));
var default_open_QMARK_ = cljs.core.get.call(null,map__16729__$1,new cljs.core.Keyword(null,"default-open?","default-open?",-2082763144));
var class_name = cljs.core.get.call(null,map__16729__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10277__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 25, [new cljs.core.Keyword(null,"on-mount","on-mount",-1236735840),null,new cljs.core.Keyword(null,"close-on-document-click?","close-on-document-click?",-948414079),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"on-action-click","on-action-click",1894902179),null,new cljs.core.Keyword(null,"event-pool","event-pool",302831908),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"on-close","on-close",-761178394),null,new cljs.core.Keyword(null,"content","content",15833224),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"basic?","basic?",-2093501395),null,new cljs.core.Keyword(null,"close-icon","close-icon",-659435027),null,new cljs.core.Keyword(null,"header","header",119441134),null,new cljs.core.Keyword(null,"actions","actions",-812656882),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"dimmer","dimmer",-938888368),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"open?","open?",1238443125),null,new cljs.core.Keyword(null,"on-unmount","on-unmount",245689269),null,new cljs.core.Keyword(null,"default-open?","default-open?",-2082763144),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"mount-node","mount-node",1448014937),null,new cljs.core.Keyword(null,"on-open","on-open",-1391088163),null,new cljs.core.Keyword(null,"close-on-dimmer-click?","close-on-dimmer-click?",-1661039169),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10277__auto__) #{:on-mount :close-on-document-click? :children :on-action-click :event-pool :key :on-close :content :as :basic? :close-icon :header :actions :on-click :size :style :dimmer :id :open? :on-unmount :default-open? :class-name :mount-node :on-open :close-on-dimmer-click?})"));
}

return sodium.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.Modal,sodium.utils.camelize_map_keys.call(null,params__10277__auto__)], null),body__10278__auto__);
});

sodium.core.modal.cljs$lang$maxFixedArity = (1);

sodium.core.modal.cljs$lang$applyTo = (function (seq16726){
var G__16727 = cljs.core.first.call(null,seq16726);
var seq16726__$1 = cljs.core.next.call(null,seq16726);
return sodium.core.modal.cljs$core$IFn$_invoke$arity$variadic(G__16727,seq16726__$1);
});

sodium.core.modal_header = (function sodium$core$modal_header(var_args){
var args__10068__auto__ = [];
var len__10061__auto___16739 = arguments.length;
var i__10062__auto___16740 = (0);
while(true){
if((i__10062__auto___16740 < len__10061__auto___16739)){
args__10068__auto__.push((arguments[i__10062__auto___16740]));

var G__16741 = (i__10062__auto___16740 + (1));
i__10062__auto___16740 = G__16741;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.modal_header.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.modal_header.cljs$core$IFn$_invoke$arity$variadic = (function (p__16736,body__10278__auto__){
var map__16737 = p__16736;
var map__16737__$1 = ((((!((map__16737 == null)))?((((map__16737.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16737.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16737):map__16737);
var params__10277__auto__ = map__16737__$1;
var children = cljs.core.get.call(null,map__16737__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var key = cljs.core.get.call(null,map__16737__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var content = cljs.core.get.call(null,map__16737__$1,new cljs.core.Keyword(null,"content","content",15833224));
var as = cljs.core.get.call(null,map__16737__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var on_click = cljs.core.get.call(null,map__16737__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var style = cljs.core.get.call(null,map__16737__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var id = cljs.core.get.call(null,map__16737__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var class_name = cljs.core.get.call(null,map__16737__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10277__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"content","content",15833224),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10277__auto__) #{:children :key :content :as :on-click :style :id :class-name})"));
}

return sodium.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.ModalHeader,sodium.utils.camelize_map_keys.call(null,params__10277__auto__)], null),body__10278__auto__);
});

sodium.core.modal_header.cljs$lang$maxFixedArity = (1);

sodium.core.modal_header.cljs$lang$applyTo = (function (seq16734){
var G__16735 = cljs.core.first.call(null,seq16734);
var seq16734__$1 = cljs.core.next.call(null,seq16734);
return sodium.core.modal_header.cljs$core$IFn$_invoke$arity$variadic(G__16735,seq16734__$1);
});

sodium.core.modal_content = (function sodium$core$modal_content(var_args){
var args__10068__auto__ = [];
var len__10061__auto___16747 = arguments.length;
var i__10062__auto___16748 = (0);
while(true){
if((i__10062__auto___16748 < len__10061__auto___16747)){
args__10068__auto__.push((arguments[i__10062__auto___16748]));

var G__16749 = (i__10062__auto___16748 + (1));
i__10062__auto___16748 = G__16749;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.modal_content.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.modal_content.cljs$core$IFn$_invoke$arity$variadic = (function (p__16744,body__10278__auto__){
var map__16745 = p__16744;
var map__16745__$1 = ((((!((map__16745 == null)))?((((map__16745.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16745.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16745):map__16745);
var params__10277__auto__ = map__16745__$1;
var scrolling_QMARK_ = cljs.core.get.call(null,map__16745__$1,new cljs.core.Keyword(null,"scrolling?","scrolling?",-365022499));
var children = cljs.core.get.call(null,map__16745__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var key = cljs.core.get.call(null,map__16745__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var content = cljs.core.get.call(null,map__16745__$1,new cljs.core.Keyword(null,"content","content",15833224));
var as = cljs.core.get.call(null,map__16745__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var on_click = cljs.core.get.call(null,map__16745__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var style = cljs.core.get.call(null,map__16745__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var id = cljs.core.get.call(null,map__16745__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var class_name = cljs.core.get.call(null,map__16745__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
var image_QMARK_ = cljs.core.get.call(null,map__16745__$1,new cljs.core.Keyword(null,"image?","image?",1951967096));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10277__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 10, [new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"content","content",15833224),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"image?","image?",1951967096),null,new cljs.core.Keyword(null,"scrolling?","scrolling?",-365022499),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10277__auto__) #{:children :key :content :as :on-click :style :id :class-name :image? :scrolling?})"));
}

return sodium.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.ModalContent,sodium.utils.camelize_map_keys.call(null,params__10277__auto__)], null),body__10278__auto__);
});

sodium.core.modal_content.cljs$lang$maxFixedArity = (1);

sodium.core.modal_content.cljs$lang$applyTo = (function (seq16742){
var G__16743 = cljs.core.first.call(null,seq16742);
var seq16742__$1 = cljs.core.next.call(null,seq16742);
return sodium.core.modal_content.cljs$core$IFn$_invoke$arity$variadic(G__16743,seq16742__$1);
});

sodium.core.modal_description = (function sodium$core$modal_description(var_args){
var args__10068__auto__ = [];
var len__10061__auto___16755 = arguments.length;
var i__10062__auto___16756 = (0);
while(true){
if((i__10062__auto___16756 < len__10061__auto___16755)){
args__10068__auto__.push((arguments[i__10062__auto___16756]));

var G__16757 = (i__10062__auto___16756 + (1));
i__10062__auto___16756 = G__16757;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.modal_description.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.modal_description.cljs$core$IFn$_invoke$arity$variadic = (function (p__16752,body__10278__auto__){
var map__16753 = p__16752;
var map__16753__$1 = ((((!((map__16753 == null)))?((((map__16753.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16753.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16753):map__16753);
var params__10277__auto__ = map__16753__$1;
var children = cljs.core.get.call(null,map__16753__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var key = cljs.core.get.call(null,map__16753__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var as = cljs.core.get.call(null,map__16753__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var on_click = cljs.core.get.call(null,map__16753__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var style = cljs.core.get.call(null,map__16753__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var id = cljs.core.get.call(null,map__16753__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var class_name = cljs.core.get.call(null,map__16753__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10277__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10277__auto__) #{:children :key :as :on-click :style :id :class-name})"));
}

return sodium.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.ModalDescription,sodium.utils.camelize_map_keys.call(null,params__10277__auto__)], null),body__10278__auto__);
});

sodium.core.modal_description.cljs$lang$maxFixedArity = (1);

sodium.core.modal_description.cljs$lang$applyTo = (function (seq16750){
var G__16751 = cljs.core.first.call(null,seq16750);
var seq16750__$1 = cljs.core.next.call(null,seq16750);
return sodium.core.modal_description.cljs$core$IFn$_invoke$arity$variadic(G__16751,seq16750__$1);
});

sodium.core.modal_actions = (function sodium$core$modal_actions(var_args){
var args__10068__auto__ = [];
var len__10061__auto___16763 = arguments.length;
var i__10062__auto___16764 = (0);
while(true){
if((i__10062__auto___16764 < len__10061__auto___16763)){
args__10068__auto__.push((arguments[i__10062__auto___16764]));

var G__16765 = (i__10062__auto___16764 + (1));
i__10062__auto___16764 = G__16765;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.modal_actions.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.modal_actions.cljs$core$IFn$_invoke$arity$variadic = (function (p__16760,body__10278__auto__){
var map__16761 = p__16760;
var map__16761__$1 = ((((!((map__16761 == null)))?((((map__16761.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16761.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16761):map__16761);
var params__10277__auto__ = map__16761__$1;
var children = cljs.core.get.call(null,map__16761__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var on_action_click = cljs.core.get.call(null,map__16761__$1,new cljs.core.Keyword(null,"on-action-click","on-action-click",1894902179));
var key = cljs.core.get.call(null,map__16761__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var as = cljs.core.get.call(null,map__16761__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var actions = cljs.core.get.call(null,map__16761__$1,new cljs.core.Keyword(null,"actions","actions",-812656882));
var on_click = cljs.core.get.call(null,map__16761__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var style = cljs.core.get.call(null,map__16761__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var id = cljs.core.get.call(null,map__16761__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var class_name = cljs.core.get.call(null,map__16761__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10277__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, [new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"on-action-click","on-action-click",1894902179),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"actions","actions",-812656882),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10277__auto__) #{:children :on-action-click :key :as :actions :on-click :style :id :class-name})"));
}

return sodium.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.ModalActions,sodium.utils.camelize_map_keys.call(null,params__10277__auto__)], null),body__10278__auto__);
});

sodium.core.modal_actions.cljs$lang$maxFixedArity = (1);

sodium.core.modal_actions.cljs$lang$applyTo = (function (seq16758){
var G__16759 = cljs.core.first.call(null,seq16758);
var seq16758__$1 = cljs.core.next.call(null,seq16758);
return sodium.core.modal_actions.cljs$core$IFn$_invoke$arity$variadic(G__16759,seq16758__$1);
});

sodium.core.rail = (function sodium$core$rail(var_args){
var args__10068__auto__ = [];
var len__10061__auto___16771 = arguments.length;
var i__10062__auto___16772 = (0);
while(true){
if((i__10062__auto___16772 < len__10061__auto___16771)){
args__10068__auto__.push((arguments[i__10062__auto___16772]));

var G__16773 = (i__10062__auto___16772 + (1));
i__10062__auto___16772 = G__16773;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.rail.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.rail.cljs$core$IFn$_invoke$arity$variadic = (function (p__16768,body__10278__auto__){
var map__16769 = p__16768;
var map__16769__$1 = ((((!((map__16769 == null)))?((((map__16769.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16769.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16769):map__16769);
var params__10277__auto__ = map__16769__$1;
var attached_QMARK_ = cljs.core.get.call(null,map__16769__$1,new cljs.core.Keyword(null,"attached?","attached?",548719296));
var children = cljs.core.get.call(null,map__16769__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var key = cljs.core.get.call(null,map__16769__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var dividing_QMARK_ = cljs.core.get.call(null,map__16769__$1,new cljs.core.Keyword(null,"dividing?","dividing?",-966834650));
var as = cljs.core.get.call(null,map__16769__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var close = cljs.core.get.call(null,map__16769__$1,new cljs.core.Keyword(null,"close","close",1835149582));
var on_click = cljs.core.get.call(null,map__16769__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var internal_QMARK_ = cljs.core.get.call(null,map__16769__$1,new cljs.core.Keyword(null,"internal?","internal?",-383058705));
var size = cljs.core.get.call(null,map__16769__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var style = cljs.core.get.call(null,map__16769__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var id = cljs.core.get.call(null,map__16769__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var class_name = cljs.core.get.call(null,map__16769__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
var position = cljs.core.get.call(null,map__16769__$1,new cljs.core.Keyword(null,"position","position",-2011731912));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10277__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [new cljs.core.Keyword(null,"attached?","attached?",548719296),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"dividing?","dividing?",-966834650),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"internal?","internal?",-383058705),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"position","position",-2011731912),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10277__auto__) #{:attached? :children :key :dividing? :as :close :on-click :internal? :size :style :id :position :class-name})"));
}

return sodium.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.Rail,sodium.utils.camelize_map_keys.call(null,params__10277__auto__)], null),body__10278__auto__);
});

sodium.core.rail.cljs$lang$maxFixedArity = (1);

sodium.core.rail.cljs$lang$applyTo = (function (seq16766){
var G__16767 = cljs.core.first.call(null,seq16766);
var seq16766__$1 = cljs.core.next.call(null,seq16766);
return sodium.core.rail.cljs$core$IFn$_invoke$arity$variadic(G__16767,seq16766__$1);
});

sodium.core.search = (function sodium$core$search(var_args){
var args__10068__auto__ = [];
var len__10061__auto___16779 = arguments.length;
var i__10062__auto___16780 = (0);
while(true){
if((i__10062__auto___16780 < len__10061__auto___16779)){
args__10068__auto__.push((arguments[i__10062__auto___16780]));

var G__16781 = (i__10062__auto___16780 + (1));
i__10062__auto___16780 = G__16781;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.search.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.search.cljs$core$IFn$_invoke$arity$variadic = (function (p__16776,body__10278__auto__){
var map__16777 = p__16776;
var map__16777__$1 = ((((!((map__16777 == null)))?((((map__16777.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16777.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16777):map__16777);
var params__10277__auto__ = map__16777__$1;
var input = cljs.core.get.call(null,map__16777__$1,new cljs.core.Keyword(null,"input","input",556931961));
var on_search_change = cljs.core.get.call(null,map__16777__$1,new cljs.core.Keyword(null,"on-search-change","on-search-change",-179605351));
var result_renderer = cljs.core.get.call(null,map__16777__$1,new cljs.core.Keyword(null,"result-renderer","result-renderer",2139760218));
var category_renderer = cljs.core.get.call(null,map__16777__$1,new cljs.core.Keyword(null,"category-renderer","category-renderer",277355995));
var category_QMARK_ = cljs.core.get.call(null,map__16777__$1,new cljs.core.Keyword(null,"category?","category?",1508694237));
var fluid_QMARK_ = cljs.core.get.call(null,map__16777__$1,new cljs.core.Keyword(null,"fluid?","fluid?",-742121890));
var results = cljs.core.get.call(null,map__16777__$1,new cljs.core.Keyword(null,"results","results",-1134170113));
var children = cljs.core.get.call(null,map__16777__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var select_first_result_QMARK_ = cljs.core.get.call(null,map__16777__$1,new cljs.core.Keyword(null,"select-first-result?","select-first-result?",-1374852926));
var key = cljs.core.get.call(null,map__16777__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var on_focus = cljs.core.get.call(null,map__16777__$1,new cljs.core.Keyword(null,"on-focus","on-focus",-13737624));
var value = cljs.core.get.call(null,map__16777__$1,new cljs.core.Keyword(null,"value","value",305978217));
var loading_QMARK_ = cljs.core.get.call(null,map__16777__$1,new cljs.core.Keyword(null,"loading?","loading?",1905707049));
var as = cljs.core.get.call(null,map__16777__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var default_value = cljs.core.get.call(null,map__16777__$1,new cljs.core.Keyword(null,"default-value","default-value",232220170));
var on_blur = cljs.core.get.call(null,map__16777__$1,new cljs.core.Keyword(null,"on-blur","on-blur",814300747));
var no_results_description = cljs.core.get.call(null,map__16777__$1,new cljs.core.Keyword(null,"no-results-description","no-results-description",-108447765));
var aligned = cljs.core.get.call(null,map__16777__$1,new cljs.core.Keyword(null,"aligned","aligned",-1015148916));
var on_results_select = cljs.core.get.call(null,map__16777__$1,new cljs.core.Keyword(null,"on-results-select","on-results-select",-1899813844));
var no_results_message = cljs.core.get.call(null,map__16777__$1,new cljs.core.Keyword(null,"no-results-message","no-results-message",-668792660));
var icon = cljs.core.get.call(null,map__16777__$1,new cljs.core.Keyword(null,"icon","icon",1679606541));
var on_mouse_down = cljs.core.get.call(null,map__16777__$1,new cljs.core.Keyword(null,"on-mouse-down","on-mouse-down",1147755470));
var on_click = cljs.core.get.call(null,map__16777__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var size = cljs.core.get.call(null,map__16777__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var style = cljs.core.get.call(null,map__16777__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var on_selection_change = cljs.core.get.call(null,map__16777__$1,new cljs.core.Keyword(null,"on-selection-change","on-selection-change",-1774232910));
var min_characters = cljs.core.get.call(null,map__16777__$1,new cljs.core.Keyword(null,"min-characters","min-characters",1196301908));
var id = cljs.core.get.call(null,map__16777__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var open_QMARK_ = cljs.core.get.call(null,map__16777__$1,new cljs.core.Keyword(null,"open?","open?",1238443125));
var show_no_results_QMARK_ = cljs.core.get.call(null,map__16777__$1,new cljs.core.Keyword(null,"show-no-results?","show-no-results?",768730806));
var default_open_QMARK_ = cljs.core.get.call(null,map__16777__$1,new cljs.core.Keyword(null,"default-open?","default-open?",-2082763144));
var class_name = cljs.core.get.call(null,map__16777__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10277__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 32, [new cljs.core.Keyword(null,"select-first-result?","select-first-result?",-1374852926),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"on-focus","on-focus",-13737624),null,new cljs.core.Keyword(null,"loading?","loading?",1905707049),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"value","value",305978217),null,new cljs.core.Keyword(null,"default-value","default-value",232220170),null,new cljs.core.Keyword(null,"on-blur","on-blur",814300747),null,new cljs.core.Keyword(null,"no-results-description","no-results-description",-108447765),null,new cljs.core.Keyword(null,"on-results-select","on-results-select",-1899813844),null,new cljs.core.Keyword(null,"no-results-message","no-results-message",-668792660),null,new cljs.core.Keyword(null,"aligned","aligned",-1015148916),null,new cljs.core.Keyword(null,"icon","icon",1679606541),null,new cljs.core.Keyword(null,"on-mouse-down","on-mouse-down",1147755470),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"on-selection-change","on-selection-change",-1774232910),null,new cljs.core.Keyword(null,"min-characters","min-characters",1196301908),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"open?","open?",1238443125),null,new cljs.core.Keyword(null,"show-no-results?","show-no-results?",768730806),null,new cljs.core.Keyword(null,"default-open?","default-open?",-2082763144),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"on-search-change","on-search-change",-179605351),null,new cljs.core.Keyword(null,"input","input",556931961),null,new cljs.core.Keyword(null,"result-renderer","result-renderer",2139760218),null,new cljs.core.Keyword(null,"category-renderer","category-renderer",277355995),null,new cljs.core.Keyword(null,"category?","category?",1508694237),null,new cljs.core.Keyword(null,"fluid?","fluid?",-742121890),null,new cljs.core.Keyword(null,"results","results",-1134170113),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10277__auto__) #{:select-first-result? :children :key :on-focus :loading? :as :value :default-value :on-blur :no-results-description :on-results-select :no-results-message :aligned :icon :on-mouse-down :on-click :size :style :on-selection-change :min-characters :id :open? :show-no-results? :default-open? :class-name :on-search-change :input :result-renderer :category-renderer :category? :fluid? :results})"));
}

return sodium.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.Search,sodium.utils.camelize_map_keys.call(null,params__10277__auto__)], null),body__10278__auto__);
});

sodium.core.search.cljs$lang$maxFixedArity = (1);

sodium.core.search.cljs$lang$applyTo = (function (seq16774){
var G__16775 = cljs.core.first.call(null,seq16774);
var seq16774__$1 = cljs.core.next.call(null,seq16774);
return sodium.core.search.cljs$core$IFn$_invoke$arity$variadic(G__16775,seq16774__$1);
});

sodium.core.segment = (function sodium$core$segment(var_args){
var args__10068__auto__ = [];
var len__10061__auto___16787 = arguments.length;
var i__10062__auto___16788 = (0);
while(true){
if((i__10062__auto___16788 < len__10061__auto___16787)){
args__10068__auto__.push((arguments[i__10062__auto___16788]));

var G__16789 = (i__10062__auto___16788 + (1));
i__10062__auto___16788 = G__16789;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.segment.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.segment.cljs$core$IFn$_invoke$arity$variadic = (function (p__16784,body__10278__auto__){
var map__16785 = p__16784;
var map__16785__$1 = ((((!((map__16785 == null)))?((((map__16785.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16785.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16785):map__16785);
var params__10277__auto__ = map__16785__$1;
var secondary_QMARK_ = cljs.core.get.call(null,map__16785__$1,new cljs.core.Keyword(null,"secondary?","secondary?",357634042));
var disabled_QMARK_ = cljs.core.get.call(null,map__16785__$1,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181));
var attached = cljs.core.get.call(null,map__16785__$1,new cljs.core.Keyword(null,"attached","attached",-1212764293));
var stacked_QMARK_ = cljs.core.get.call(null,map__16785__$1,new cljs.core.Keyword(null,"stacked?","stacked?",784188446));
var inverted_QMARK_ = cljs.core.get.call(null,map__16785__$1,new cljs.core.Keyword(null,"inverted?","inverted?",-676420704));
var raised_QMARK_ = cljs.core.get.call(null,map__16785__$1,new cljs.core.Keyword(null,"raised?","raised?",145778912));
var children = cljs.core.get.call(null,map__16785__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var key = cljs.core.get.call(null,map__16785__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var circular_QMARK_ = cljs.core.get.call(null,map__16785__$1,new cljs.core.Keyword(null,"circular?","circular?",-827286875));
var color = cljs.core.get.call(null,map__16785__$1,new cljs.core.Keyword(null,"color","color",1011675173));
var text_align = cljs.core.get.call(null,map__16785__$1,new cljs.core.Keyword(null,"text-align","text-align",1786091845));
var loading_QMARK_ = cljs.core.get.call(null,map__16785__$1,new cljs.core.Keyword(null,"loading?","loading?",1905707049));
var as = cljs.core.get.call(null,map__16785__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var piled_QMARK_ = cljs.core.get.call(null,map__16785__$1,new cljs.core.Keyword(null,"piled?","piled?",991468937));
var basic_QMARK_ = cljs.core.get.call(null,map__16785__$1,new cljs.core.Keyword(null,"basic?","basic?",-2093501395));
var tertiary_QMARK_ = cljs.core.get.call(null,map__16785__$1,new cljs.core.Keyword(null,"tertiary?","tertiary?",469980846));
var on_click = cljs.core.get.call(null,map__16785__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var size = cljs.core.get.call(null,map__16785__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var style = cljs.core.get.call(null,map__16785__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var clearing_QMARK_ = cljs.core.get.call(null,map__16785__$1,new cljs.core.Keyword(null,"clearing?","clearing?",-1821736270));
var compact_QMARK_ = cljs.core.get.call(null,map__16785__$1,new cljs.core.Keyword(null,"compact?","compact?",1216893298));
var floated = cljs.core.get.call(null,map__16785__$1,new cljs.core.Keyword(null,"floated","floated",739819667));
var id = cljs.core.get.call(null,map__16785__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var vertical_QMARK_ = cljs.core.get.call(null,map__16785__$1,new cljs.core.Keyword(null,"vertical?","vertical?",-1522630444));
var padded = cljs.core.get.call(null,map__16785__$1,new cljs.core.Keyword(null,"padded","padded",1434297910));
var class_name = cljs.core.get.call(null,map__16785__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10277__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 26, [new cljs.core.Keyword(null,"raised?","raised?",145778912),null,new cljs.core.Keyword(null,"inverted?","inverted?",-676420704),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"color","color",1011675173),null,new cljs.core.Keyword(null,"text-align","text-align",1786091845),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"circular?","circular?",-827286875),null,new cljs.core.Keyword(null,"loading?","loading?",1905707049),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"piled?","piled?",991468937),null,new cljs.core.Keyword(null,"basic?","basic?",-2093501395),null,new cljs.core.Keyword(null,"tertiary?","tertiary?",469980846),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"compact?","compact?",1216893298),null,new cljs.core.Keyword(null,"clearing?","clearing?",-1821736270),null,new cljs.core.Keyword(null,"floated","floated",739819667),null,new cljs.core.Keyword(null,"vertical?","vertical?",-1522630444),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"padded","padded",1434297910),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"secondary?","secondary?",357634042),null,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181),null,new cljs.core.Keyword(null,"attached","attached",-1212764293),null,new cljs.core.Keyword(null,"stacked?","stacked?",784188446),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10277__auto__) #{:raised? :inverted? :children :color :text-align :key :circular? :loading? :as :piled? :basic? :tertiary? :on-click :size :style :compact? :clearing? :floated :vertical? :id :padded :class-name :secondary? :disabled? :attached :stacked?})"));
}

return sodium.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.Segment,sodium.utils.camelize_map_keys.call(null,params__10277__auto__)], null),body__10278__auto__);
});

sodium.core.segment.cljs$lang$maxFixedArity = (1);

sodium.core.segment.cljs$lang$applyTo = (function (seq16782){
var G__16783 = cljs.core.first.call(null,seq16782);
var seq16782__$1 = cljs.core.next.call(null,seq16782);
return sodium.core.segment.cljs$core$IFn$_invoke$arity$variadic(G__16783,seq16782__$1);
});

sodium.core.segment_group = (function sodium$core$segment_group(var_args){
var args__10068__auto__ = [];
var len__10061__auto___16795 = arguments.length;
var i__10062__auto___16796 = (0);
while(true){
if((i__10062__auto___16796 < len__10061__auto___16795)){
args__10068__auto__.push((arguments[i__10062__auto___16796]));

var G__16797 = (i__10062__auto___16796 + (1));
i__10062__auto___16796 = G__16797;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.segment_group.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.segment_group.cljs$core$IFn$_invoke$arity$variadic = (function (p__16792,body__10278__auto__){
var map__16793 = p__16792;
var map__16793__$1 = ((((!((map__16793 == null)))?((((map__16793.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16793.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16793):map__16793);
var params__10277__auto__ = map__16793__$1;
var stacked_QMARK_ = cljs.core.get.call(null,map__16793__$1,new cljs.core.Keyword(null,"stacked?","stacked?",784188446));
var raised_QMARK_ = cljs.core.get.call(null,map__16793__$1,new cljs.core.Keyword(null,"raised?","raised?",145778912));
var horizontal_QMARK_ = cljs.core.get.call(null,map__16793__$1,new cljs.core.Keyword(null,"horizontal?","horizontal?",-423282271));
var children = cljs.core.get.call(null,map__16793__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var key = cljs.core.get.call(null,map__16793__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var as = cljs.core.get.call(null,map__16793__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var piled_QMARK_ = cljs.core.get.call(null,map__16793__$1,new cljs.core.Keyword(null,"piled?","piled?",991468937));
var on_click = cljs.core.get.call(null,map__16793__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var size = cljs.core.get.call(null,map__16793__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var style = cljs.core.get.call(null,map__16793__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var compact_QMARK_ = cljs.core.get.call(null,map__16793__$1,new cljs.core.Keyword(null,"compact?","compact?",1216893298));
var id = cljs.core.get.call(null,map__16793__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var class_name = cljs.core.get.call(null,map__16793__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10277__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [new cljs.core.Keyword(null,"raised?","raised?",145778912),null,new cljs.core.Keyword(null,"horizontal?","horizontal?",-423282271),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"piled?","piled?",991468937),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"compact?","compact?",1216893298),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"stacked?","stacked?",784188446),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10277__auto__) #{:raised? :horizontal? :children :key :as :piled? :on-click :size :style :compact? :id :class-name :stacked?})"));
}

return sodium.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.SegmentGroup,sodium.utils.camelize_map_keys.call(null,params__10277__auto__)], null),body__10278__auto__);
});

sodium.core.segment_group.cljs$lang$maxFixedArity = (1);

sodium.core.segment_group.cljs$lang$applyTo = (function (seq16790){
var G__16791 = cljs.core.first.call(null,seq16790);
var seq16790__$1 = cljs.core.next.call(null,seq16790);
return sodium.core.segment_group.cljs$core$IFn$_invoke$arity$variadic(G__16791,seq16790__$1);
});

sodium.core.text_area = (function sodium$core$text_area(var_args){
var args__10068__auto__ = [];
var len__10061__auto___16803 = arguments.length;
var i__10062__auto___16804 = (0);
while(true){
if((i__10062__auto___16804 < len__10061__auto___16803)){
args__10068__auto__.push((arguments[i__10062__auto___16804]));

var G__16805 = (i__10062__auto___16804 + (1));
i__10062__auto___16804 = G__16805;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return sodium.core.text_area.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

sodium.core.text_area.cljs$core$IFn$_invoke$arity$variadic = (function (p__16800,body__10278__auto__){
var map__16801 = p__16800;
var map__16801__$1 = ((((!((map__16801 == null)))?((((map__16801.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16801.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16801):map__16801);
var params__10277__auto__ = map__16801__$1;
var input = cljs.core.get.call(null,map__16801__$1,new cljs.core.Keyword(null,"input","input",556931961));
var action_position = cljs.core.get.call(null,map__16801__$1,new cljs.core.Keyword(null,"action-position","action-position",-704217959));
var error_QMARK_ = cljs.core.get.call(null,map__16801__$1,new cljs.core.Keyword(null,"error?","error?",-460689159));
var disabled_QMARK_ = cljs.core.get.call(null,map__16801__$1,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181));
var on_change = cljs.core.get.call(null,map__16801__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
var step = cljs.core.get.call(null,map__16801__$1,new cljs.core.Keyword(null,"step","step",1288888124));
var fluid_QMARK_ = cljs.core.get.call(null,map__16801__$1,new cljs.core.Keyword(null,"fluid?","fluid?",-742121890));
var label_position = cljs.core.get.call(null,map__16801__$1,new cljs.core.Keyword(null,"label-position","label-position",-1546831329));
var inverted_QMARK_ = cljs.core.get.call(null,map__16801__$1,new cljs.core.Keyword(null,"inverted?","inverted?",-676420704));
var tab_index = cljs.core.get.call(null,map__16801__$1,new cljs.core.Keyword(null,"tab-index","tab-index",895755393));
var children = cljs.core.get.call(null,map__16801__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var required_QMARK_ = cljs.core.get.call(null,map__16801__$1,new cljs.core.Keyword(null,"required?","required?",-872514462));
var key = cljs.core.get.call(null,map__16801__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var placeholder = cljs.core.get.call(null,map__16801__$1,new cljs.core.Keyword(null,"placeholder","placeholder",-104873083));
var icon_position = cljs.core.get.call(null,map__16801__$1,new cljs.core.Keyword(null,"icon-position","icon-position",-1720359034));
var focus_QMARK_ = cljs.core.get.call(null,map__16801__$1,new cljs.core.Keyword(null,"focus?","focus?",-3018488));
var value = cljs.core.get.call(null,map__16801__$1,new cljs.core.Keyword(null,"value","value",305978217));
var as = cljs.core.get.call(null,map__16801__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var default_value = cljs.core.get.call(null,map__16801__$1,new cljs.core.Keyword(null,"default-value","default-value",232220170));
var width = cljs.core.get.call(null,map__16801__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var transparent_QMARK_ = cljs.core.get.call(null,map__16801__$1,new cljs.core.Keyword(null,"transparent?","transparent?",-1446050548));
var type = cljs.core.get.call(null,map__16801__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var icon = cljs.core.get.call(null,map__16801__$1,new cljs.core.Keyword(null,"icon","icon",1679606541));
var on_click = cljs.core.get.call(null,map__16801__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var size = cljs.core.get.call(null,map__16801__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var rows = cljs.core.get.call(null,map__16801__$1,new cljs.core.Keyword(null,"rows","rows",850049680));
var style = cljs.core.get.call(null,map__16801__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var auto_height = cljs.core.get.call(null,map__16801__$1,new cljs.core.Keyword(null,"auto-height","auto-height",-960519663));
var inline_QMARK_ = cljs.core.get.call(null,map__16801__$1,new cljs.core.Keyword(null,"inline?","inline?",-1674483791));
var list = cljs.core.get.call(null,map__16801__$1,new cljs.core.Keyword(null,"list","list",765357683));
var loading = cljs.core.get.call(null,map__16801__$1,new cljs.core.Keyword(null,"loading","loading",-737050189));
var label = cljs.core.get.call(null,map__16801__$1,new cljs.core.Keyword(null,"label","label",1718410804));
var id = cljs.core.get.call(null,map__16801__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var control = cljs.core.get.call(null,map__16801__$1,new cljs.core.Keyword(null,"control","control",1892578036));
var class_name = cljs.core.get.call(null,map__16801__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
var action = cljs.core.get.call(null,map__16801__$1,new cljs.core.Keyword(null,"action","action",-811238024));
if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params__10277__auto__),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 36, [new cljs.core.Keyword(null,"inverted?","inverted?",-676420704),null,new cljs.core.Keyword(null,"tab-index","tab-index",895755393),null,new cljs.core.Keyword(null,"required?","required?",-872514462),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),null,new cljs.core.Keyword(null,"icon-position","icon-position",-1720359034),null,new cljs.core.Keyword(null,"focus?","focus?",-3018488),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"value","value",305978217),null,new cljs.core.Keyword(null,"default-value","default-value",232220170),null,new cljs.core.Keyword(null,"width","width",-384071477),null,new cljs.core.Keyword(null,"transparent?","transparent?",-1446050548),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"icon","icon",1679606541),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"rows","rows",850049680),null,new cljs.core.Keyword(null,"auto-height","auto-height",-960519663),null,new cljs.core.Keyword(null,"inline?","inline?",-1674483791),null,new cljs.core.Keyword(null,"loading","loading",-737050189),null,new cljs.core.Keyword(null,"list","list",765357683),null,new cljs.core.Keyword(null,"label","label",1718410804),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"control","control",1892578036),null,new cljs.core.Keyword(null,"action","action",-811238024),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"action-position","action-position",-704217959),null,new cljs.core.Keyword(null,"error?","error?",-460689159),null,new cljs.core.Keyword(null,"input","input",556931961),null,new cljs.core.Keyword(null,"on-change","on-change",-732046149),null,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181),null,new cljs.core.Keyword(null,"step","step",1288888124),null,new cljs.core.Keyword(null,"fluid?","fluid?",-742121890),null,new cljs.core.Keyword(null,"label-position","label-position",-1546831329),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params__10277__auto__) #{:inverted? :tab-index :required? :children :key :placeholder :icon-position :focus? :as :value :default-value :width :transparent? :type :icon :on-click :size :style :rows :auto-height :inline? :loading :list :label :id :control :action :class-name :action-position :error? :input :on-change :disabled? :step :fluid? :label-position})"));
}

return sodium.utils.vconcat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.TextArea,sodium.utils.camelize_map_keys.call(null,params__10277__auto__)], null),body__10278__auto__);
});

sodium.core.text_area.cljs$lang$maxFixedArity = (1);

sodium.core.text_area.cljs$lang$applyTo = (function (seq16798){
var G__16799 = cljs.core.first.call(null,seq16798);
var seq16798__$1 = cljs.core.next.call(null,seq16798);
return sodium.core.text_area.cljs$core$IFn$_invoke$arity$variadic(G__16799,seq16798__$1);
});

sodium.core.form_button = (function sodium$core$form_button(p__16807){
var map__16808 = p__16807;
var map__16808__$1 = ((((!((map__16808 == null)))?((((map__16808.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16808.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16808):map__16808);
var params = map__16808__$1;
var error_QMARK_ = cljs.core.get.call(null,map__16808__$1,new cljs.core.Keyword(null,"error?","error?",-460689159));
var secondary_QMARK_ = cljs.core.get.call(null,map__16808__$1,new cljs.core.Keyword(null,"secondary?","secondary?",357634042));
var disabled_QMARK_ = cljs.core.get.call(null,map__16808__$1,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181));
var attached = cljs.core.get.call(null,map__16808__$1,new cljs.core.Keyword(null,"attached","attached",-1212764293));
var primary_QMARK_ = cljs.core.get.call(null,map__16808__$1,new cljs.core.Keyword(null,"primary?","primary?",1845519164));
var toggle_QMARK_ = cljs.core.get.call(null,map__16808__$1,new cljs.core.Keyword(null,"toggle?","toggle?",-664005476));
var fluid_QMARK_ = cljs.core.get.call(null,map__16808__$1,new cljs.core.Keyword(null,"fluid?","fluid?",-742121890));
var label_position = cljs.core.get.call(null,map__16808__$1,new cljs.core.Keyword(null,"label-position","label-position",-1546831329));
var inverted_QMARK_ = cljs.core.get.call(null,map__16808__$1,new cljs.core.Keyword(null,"inverted?","inverted?",-676420704));
var active_QMARK_ = cljs.core.get.call(null,map__16808__$1,new cljs.core.Keyword(null,"active?","active?",459499776));
var tab_index = cljs.core.get.call(null,map__16808__$1,new cljs.core.Keyword(null,"tab-index","tab-index",895755393));
var children = cljs.core.get.call(null,map__16808__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var required_QMARK_ = cljs.core.get.call(null,map__16808__$1,new cljs.core.Keyword(null,"required?","required?",-872514462));
var negative_QMARK_ = cljs.core.get.call(null,map__16808__$1,new cljs.core.Keyword(null,"negative?","negative?",-1265997117));
var key = cljs.core.get.call(null,map__16808__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var circular_QMARK_ = cljs.core.get.call(null,map__16808__$1,new cljs.core.Keyword(null,"circular?","circular?",-827286875));
var color = cljs.core.get.call(null,map__16808__$1,new cljs.core.Keyword(null,"color","color",1011675173));
var positive_QMARK_ = cljs.core.get.call(null,map__16808__$1,new cljs.core.Keyword(null,"positive?","positive?",-185306841));
var content = cljs.core.get.call(null,map__16808__$1,new cljs.core.Keyword(null,"content","content",15833224));
var loading_QMARK_ = cljs.core.get.call(null,map__16808__$1,new cljs.core.Keyword(null,"loading?","loading?",1905707049));
var as = cljs.core.get.call(null,map__16808__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var animated = cljs.core.get.call(null,map__16808__$1,new cljs.core.Keyword(null,"animated","animated",129318795));
var width = cljs.core.get.call(null,map__16808__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var type = cljs.core.get.call(null,map__16808__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var icon = cljs.core.get.call(null,map__16808__$1,new cljs.core.Keyword(null,"icon","icon",1679606541));
var basic_QMARK_ = cljs.core.get.call(null,map__16808__$1,new cljs.core.Keyword(null,"basic?","basic?",-2093501395));
var on_click = cljs.core.get.call(null,map__16808__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var size = cljs.core.get.call(null,map__16808__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var style = cljs.core.get.call(null,map__16808__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var inline_QMARK_ = cljs.core.get.call(null,map__16808__$1,new cljs.core.Keyword(null,"inline?","inline?",-1674483791));
var compact_QMARK_ = cljs.core.get.call(null,map__16808__$1,new cljs.core.Keyword(null,"compact?","compact?",1216893298));
var floated = cljs.core.get.call(null,map__16808__$1,new cljs.core.Keyword(null,"floated","floated",739819667));
var label = cljs.core.get.call(null,map__16808__$1,new cljs.core.Keyword(null,"label","label",1718410804));
var id = cljs.core.get.call(null,map__16808__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var control = cljs.core.get.call(null,map__16808__$1,new cljs.core.Keyword(null,"control","control",1892578036));
var data_tooltip = cljs.core.get.call(null,map__16808__$1,new cljs.core.Keyword(null,"data-tooltip","data-tooltip",121719926));
var class_name = cljs.core.get.call(null,map__16808__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
if(cljs.core.truth_(sodium.utils.validate.call(null,cljs.spec.alpha.nilable_impl.call(null,new cljs.core.Symbol("cljs.core","ifn?","cljs.core/ifn?",1573873861,null),cljs.core.ifn_QMARK_,null),new cljs.core.Keyword(null,"on-click","on-click",1632826543).cljs$core$IFn$_invoke$arity$1(params)))){
} else {
throw (new Error("Assert failed: (utils/validate (s/nilable ifn?) (:on-click params))"));
}

if(cljs.core.truth_(sodium.utils.validate.call(null,cljs.spec.alpha.nilable_impl.call(null,new cljs.core.Symbol("cljs.core","string?","cljs.core/string?",-2072921719,null),cljs.core.string_QMARK_,null),new cljs.core.Keyword(null,"data-tooltip","data-tooltip",121719926).cljs$core$IFn$_invoke$arity$1(params)))){
} else {
throw (new Error("Assert failed: (utils/validate (s/nilable string?) (:data-tooltip params))"));
}

if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 37, [new cljs.core.Keyword(null,"active?","active?",459499776),null,new cljs.core.Keyword(null,"inverted?","inverted?",-676420704),null,new cljs.core.Keyword(null,"tab-index","tab-index",895755393),null,new cljs.core.Keyword(null,"required?","required?",-872514462),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"negative?","negative?",-1265997117),null,new cljs.core.Keyword(null,"color","color",1011675173),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"circular?","circular?",-827286875),null,new cljs.core.Keyword(null,"positive?","positive?",-185306841),null,new cljs.core.Keyword(null,"content","content",15833224),null,new cljs.core.Keyword(null,"loading?","loading?",1905707049),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"width","width",-384071477),null,new cljs.core.Keyword(null,"animated","animated",129318795),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"basic?","basic?",-2093501395),null,new cljs.core.Keyword(null,"icon","icon",1679606541),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"inline?","inline?",-1674483791),null,new cljs.core.Keyword(null,"compact?","compact?",1216893298),null,new cljs.core.Keyword(null,"floated","floated",739819667),null,new cljs.core.Keyword(null,"label","label",1718410804),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"control","control",1892578036),null,new cljs.core.Keyword(null,"data-tooltip","data-tooltip",121719926),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"error?","error?",-460689159),null,new cljs.core.Keyword(null,"secondary?","secondary?",357634042),null,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181),null,new cljs.core.Keyword(null,"attached","attached",-1212764293),null,new cljs.core.Keyword(null,"toggle?","toggle?",-664005476),null,new cljs.core.Keyword(null,"primary?","primary?",1845519164),null,new cljs.core.Keyword(null,"fluid?","fluid?",-742121890),null,new cljs.core.Keyword(null,"label-position","label-position",-1546831329),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params) #{:active? :inverted? :tab-index :required? :children :negative? :color :key :circular? :positive? :content :loading? :as :width :animated :type :basic? :icon :on-click :size :style :inline? :compact? :floated :label :id :control :data-tooltip :class-name :error? :secondary? :disabled? :attached :toggle? :primary? :fluid? :label-position})"));
}

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.FormButton,sodium.utils.camelize_map_keys.call(null,cljs.core.update.call(null,params,new cljs.core.Keyword(null,"type","type",1174270348),((function (map__16808,map__16808__$1,params,error_QMARK_,secondary_QMARK_,disabled_QMARK_,attached,primary_QMARK_,toggle_QMARK_,fluid_QMARK_,label_position,inverted_QMARK_,active_QMARK_,tab_index,children,required_QMARK_,negative_QMARK_,key,circular_QMARK_,color,positive_QMARK_,content,loading_QMARK_,as,animated,width,type,icon,basic_QMARK_,on_click,size,style,inline_QMARK_,compact_QMARK_,floated,label,id,control,data_tooltip,class_name){
return (function (p1__16806_SHARP_){
var or__8782__auto__ = p1__16806_SHARP_;
if(cljs.core.truth_(or__8782__auto__)){
return or__8782__auto__;
} else {
return "button";
}
});})(map__16808,map__16808__$1,params,error_QMARK_,secondary_QMARK_,disabled_QMARK_,attached,primary_QMARK_,toggle_QMARK_,fluid_QMARK_,label_position,inverted_QMARK_,active_QMARK_,tab_index,children,required_QMARK_,negative_QMARK_,key,circular_QMARK_,color,positive_QMARK_,content,loading_QMARK_,as,animated,width,type,icon,basic_QMARK_,on_click,size,style,inline_QMARK_,compact_QMARK_,floated,label,id,control,data_tooltip,class_name))
),new cljs.core.Keyword(null,"exclude","exclude",-1230250334),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data-tooltip","data-tooltip",121719926)], null))], null);
});
sodium.core.button = (function sodium$core$button(p__16811){
var map__16812 = p__16811;
var map__16812__$1 = ((((!((map__16812 == null)))?((((map__16812.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16812.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16812):map__16812);
var params = map__16812__$1;
var secondary_QMARK_ = cljs.core.get.call(null,map__16812__$1,new cljs.core.Keyword(null,"secondary?","secondary?",357634042));
var disabled_QMARK_ = cljs.core.get.call(null,map__16812__$1,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181));
var attached = cljs.core.get.call(null,map__16812__$1,new cljs.core.Keyword(null,"attached","attached",-1212764293));
var primary_QMARK_ = cljs.core.get.call(null,map__16812__$1,new cljs.core.Keyword(null,"primary?","primary?",1845519164));
var toggle_QMARK_ = cljs.core.get.call(null,map__16812__$1,new cljs.core.Keyword(null,"toggle?","toggle?",-664005476));
var fluid_QMARK_ = cljs.core.get.call(null,map__16812__$1,new cljs.core.Keyword(null,"fluid?","fluid?",-742121890));
var label_position = cljs.core.get.call(null,map__16812__$1,new cljs.core.Keyword(null,"label-position","label-position",-1546831329));
var inverted_QMARK_ = cljs.core.get.call(null,map__16812__$1,new cljs.core.Keyword(null,"inverted?","inverted?",-676420704));
var active_QMARK_ = cljs.core.get.call(null,map__16812__$1,new cljs.core.Keyword(null,"active?","active?",459499776));
var tab_index = cljs.core.get.call(null,map__16812__$1,new cljs.core.Keyword(null,"tab-index","tab-index",895755393));
var children = cljs.core.get.call(null,map__16812__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var negative_QMARK_ = cljs.core.get.call(null,map__16812__$1,new cljs.core.Keyword(null,"negative?","negative?",-1265997117));
var key = cljs.core.get.call(null,map__16812__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var circular_QMARK_ = cljs.core.get.call(null,map__16812__$1,new cljs.core.Keyword(null,"circular?","circular?",-827286875));
var color = cljs.core.get.call(null,map__16812__$1,new cljs.core.Keyword(null,"color","color",1011675173));
var positive_QMARK_ = cljs.core.get.call(null,map__16812__$1,new cljs.core.Keyword(null,"positive?","positive?",-185306841));
var content = cljs.core.get.call(null,map__16812__$1,new cljs.core.Keyword(null,"content","content",15833224));
var loading_QMARK_ = cljs.core.get.call(null,map__16812__$1,new cljs.core.Keyword(null,"loading?","loading?",1905707049));
var as = cljs.core.get.call(null,map__16812__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var animated = cljs.core.get.call(null,map__16812__$1,new cljs.core.Keyword(null,"animated","animated",129318795));
var icon = cljs.core.get.call(null,map__16812__$1,new cljs.core.Keyword(null,"icon","icon",1679606541));
var basic_QMARK_ = cljs.core.get.call(null,map__16812__$1,new cljs.core.Keyword(null,"basic?","basic?",-2093501395));
var on_click = cljs.core.get.call(null,map__16812__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var size = cljs.core.get.call(null,map__16812__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var style = cljs.core.get.call(null,map__16812__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var compact_QMARK_ = cljs.core.get.call(null,map__16812__$1,new cljs.core.Keyword(null,"compact?","compact?",1216893298));
var floated = cljs.core.get.call(null,map__16812__$1,new cljs.core.Keyword(null,"floated","floated",739819667));
var label = cljs.core.get.call(null,map__16812__$1,new cljs.core.Keyword(null,"label","label",1718410804));
var id = cljs.core.get.call(null,map__16812__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var data_tooltip = cljs.core.get.call(null,map__16812__$1,new cljs.core.Keyword(null,"data-tooltip","data-tooltip",121719926));
var class_name = cljs.core.get.call(null,map__16812__$1,new cljs.core.Keyword(null,"class-name","class-name",945142584));
if(cljs.core.truth_(sodium.utils.validate.call(null,cljs.spec.alpha.nilable_impl.call(null,new cljs.core.Symbol("cljs.core","ifn?","cljs.core/ifn?",1573873861,null),cljs.core.ifn_QMARK_,null),new cljs.core.Keyword(null,"on-click","on-click",1632826543).cljs$core$IFn$_invoke$arity$1(params)))){
} else {
throw (new Error("Assert failed: (utils/validate (s/nilable ifn?) (:on-click params))"));
}

if(cljs.core.truth_(sodium.utils.validate.call(null,cljs.spec.alpha.nilable_impl.call(null,new cljs.core.Symbol("cljs.core","string?","cljs.core/string?",-2072921719,null),cljs.core.string_QMARK_,null),new cljs.core.Keyword(null,"data-tooltip","data-tooltip",121719926).cljs$core$IFn$_invoke$arity$1(params)))){
} else {
throw (new Error("Assert failed: (utils/validate (s/nilable string?) (:data-tooltip params))"));
}

if(cljs.core.truth_(sodium.utils.all_keys_valid_QMARK_.call(null,cljs.core.keys.call(null,params),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 31, [new cljs.core.Keyword(null,"active?","active?",459499776),null,new cljs.core.Keyword(null,"inverted?","inverted?",-676420704),null,new cljs.core.Keyword(null,"tab-index","tab-index",895755393),null,new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"negative?","negative?",-1265997117),null,new cljs.core.Keyword(null,"color","color",1011675173),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"circular?","circular?",-827286875),null,new cljs.core.Keyword(null,"positive?","positive?",-185306841),null,new cljs.core.Keyword(null,"content","content",15833224),null,new cljs.core.Keyword(null,"loading?","loading?",1905707049),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"animated","animated",129318795),null,new cljs.core.Keyword(null,"basic?","basic?",-2093501395),null,new cljs.core.Keyword(null,"icon","icon",1679606541),null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"style","style",-496642736),null,new cljs.core.Keyword(null,"compact?","compact?",1216893298),null,new cljs.core.Keyword(null,"floated","floated",739819667),null,new cljs.core.Keyword(null,"label","label",1718410804),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"data-tooltip","data-tooltip",121719926),null,new cljs.core.Keyword(null,"class-name","class-name",945142584),null,new cljs.core.Keyword(null,"secondary?","secondary?",357634042),null,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181),null,new cljs.core.Keyword(null,"attached","attached",-1212764293),null,new cljs.core.Keyword(null,"toggle?","toggle?",-664005476),null,new cljs.core.Keyword(null,"primary?","primary?",1845519164),null,new cljs.core.Keyword(null,"fluid?","fluid?",-742121890),null,new cljs.core.Keyword(null,"label-position","label-position",-1546831329),null], null), null)))){
} else {
throw (new Error("Assert failed: (sodium.utils/all-keys-valid? (clojure.core/keys params) #{:active? :inverted? :tab-index :children :negative? :color :key :circular? :positive? :content :loading? :as :animated :basic? :icon :on-click :size :style :compact? :floated :label :id :data-tooltip :class-name :secondary? :disabled? :attached :toggle? :primary? :fluid? :label-position})"));
}

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [soda_ash.core.Button,sodium.utils.camelize_map_keys.call(null,cljs.core.update.call(null,params,new cljs.core.Keyword(null,"type","type",1174270348),((function (map__16812,map__16812__$1,params,secondary_QMARK_,disabled_QMARK_,attached,primary_QMARK_,toggle_QMARK_,fluid_QMARK_,label_position,inverted_QMARK_,active_QMARK_,tab_index,children,negative_QMARK_,key,circular_QMARK_,color,positive_QMARK_,content,loading_QMARK_,as,animated,icon,basic_QMARK_,on_click,size,style,compact_QMARK_,floated,label,id,data_tooltip,class_name){
return (function (p1__16810_SHARP_){
var or__8782__auto__ = p1__16810_SHARP_;
if(cljs.core.truth_(or__8782__auto__)){
return or__8782__auto__;
} else {
return "button";
}
});})(map__16812,map__16812__$1,params,secondary_QMARK_,disabled_QMARK_,attached,primary_QMARK_,toggle_QMARK_,fluid_QMARK_,label_position,inverted_QMARK_,active_QMARK_,tab_index,children,negative_QMARK_,key,circular_QMARK_,color,positive_QMARK_,content,loading_QMARK_,as,animated,icon,basic_QMARK_,on_click,size,style,compact_QMARK_,floated,label,id,data_tooltip,class_name))
),new cljs.core.Keyword(null,"exclude","exclude",-1230250334),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data-tooltip","data-tooltip",121719926)], null))], null);
});

//# sourceMappingURL=core.js.map
