// Compiled by ClojureScript 1.9.946 {}
goog.provide('iron.utils');
goog.require('cljs.core');
goog.require('cljs.spec.alpha');
goog.require('clojure.string');
/**
 * Variant of empty? that behaves reasonably for non-seqs too.
 */
iron.utils.negligible_QMARK_ = (function iron$utils$negligible_QMARK_(x){
if(cljs.core.seqable_QMARK_.call(null,x)){
return cljs.core.empty_QMARK_.call(null,x);
} else {
return cljs.core.not.call(null,x);
}
});
/**
 * Case-insensitive string compare
 */
iron.utils.ci_compare = (function iron$utils$ci_compare(s1,s2){
return cljs.core.compare.call(null,clojure.string.upper_case.call(null,s1),clojure.string.upper_case.call(null,s2));
});
/**
 * Case-insensitive string sort
 */
iron.utils.ci_sort = (function iron$utils$ci_sort(coll){
return cljs.core.sort_by.call(null,clojure.string.upper_case,coll);
});
/**
 * Case-insensitive string sort-by
 */
iron.utils.ci_sort_by = (function iron$utils$ci_sort_by(keyfn,coll){
return cljs.core.sort_by.call(null,cljs.core.comp.call(null,clojure.string.upper_case,keyfn),coll);
});
/**
 * Case-insensitive string inclusion test
 */
iron.utils.ci_includes_QMARK_ = (function iron$utils$ci_includes_QMARK_(s,substr){
return clojure.string.includes_QMARK_.call(null,clojure.string.upper_case.call(null,s),clojure.string.upper_case.call(null,substr));
});
/**
 * Like s/valid?, but show the error like s/assert. Useful for pre-conditions.
 */
iron.utils.validate = (function iron$utils$validate(spec,x){
var or__8782__auto__ = cljs.spec.alpha.valid_QMARK_.call(null,spec,x);
if(cljs.core.truth_(or__8782__auto__)){
return or__8782__auto__;
} else {
return cljs.spec.alpha.explain.call(null,spec,x);
}
});
/**
 * Like concat, but return a vector.
 */
iron.utils.vconcat = (function iron$utils$vconcat(var_args){
var args__10068__auto__ = [];
var len__10061__auto___13934 = arguments.length;
var i__10062__auto___13935 = (0);
while(true){
if((i__10062__auto___13935 < len__10061__auto___13934)){
args__10068__auto__.push((arguments[i__10062__auto___13935]));

var G__13936 = (i__10062__auto___13935 + (1));
i__10062__auto___13935 = G__13936;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((0) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((0)),(0),null)):null);
return iron.utils.vconcat.cljs$core$IFn$_invoke$arity$variadic(argseq__10069__auto__);
});

iron.utils.vconcat.cljs$core$IFn$_invoke$arity$variadic = (function (vecs){
return cljs.core.vec.call(null,cljs.core.apply.call(null,cljs.core.concat,vecs));
});

iron.utils.vconcat.cljs$lang$maxFixedArity = (0);

iron.utils.vconcat.cljs$lang$applyTo = (function (seq13933){
return iron.utils.vconcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq13933));
});

cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("iron.utils","event-vector","iron.utils/event-vector",-2103185245),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null),new cljs.core.Keyword(null,"params","params",710516235),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","*","cljs.spec.alpha/*",-1238084288,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null))),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"params","params",710516235)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword_QMARK_,cljs.spec.alpha.rep_impl.call(null,new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),cljs.core.any_QMARK_)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","*","cljs.spec.alpha/*",-1238084288,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null))], null)));
/**
 * Remove trailing '?' from predicate, to make suitable for JavaScript
 */
iron.utils.unpredicate = (function iron$utils$unpredicate(s){
if(clojure.string.ends_with_QMARK_.call(null,s,"?")){
return cljs.core.subs.call(null,s,(0),(cljs.core.count.call(null,s) - (1)));
} else {
return s;
}
});
/**
 * Convert a string from ClojureScript to JavaScript conventions.
 *   - Replace hyphens with camelCase
 *   - Remove trailing '?'
 */
iron.utils.camelize_str = (function iron$utils$camelize_str(s){
var vec__13937 = clojure.string.split.call(null,iron.utils.unpredicate.call(null,s),"-");
var seq__13938 = cljs.core.seq.call(null,vec__13937);
var first__13939 = cljs.core.first.call(null,seq__13938);
var seq__13938__$1 = cljs.core.next.call(null,seq__13938);
var first_word = first__13939;
var more = seq__13938__$1;
if(more){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(first_word),cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.call(null,cljs.core.map.call(null,clojure.string.capitalize,more)))].join('');
} else {
return first_word;
}
});
/**
 * Convert a keyword from ClojureScript to JavaScript conventions.
 *   - Replace hyphens with camelCase
 *   - Remove trailing '?'
 *   - Preserve namespace
 */
iron.utils.camelize_key = (function iron$utils$camelize_key(k){
return cljs.core.keyword.call(null,cljs.core.namespace.call(null,k),iron.utils.camelize_str.call(null,cljs.core.name.call(null,k)));
});
/**
 * Convert a map from ClojureScript to JavaScript conventions. Change the map
 *   keys, but leave the values alone.  For convenience, you can pass in a seq
 *   of keywords that must be excluded (left unchanged).
 */
iron.utils.camelize_map_keys = (function iron$utils$camelize_map_keys(var_args){
var args__10068__auto__ = [];
var len__10061__auto___13945 = arguments.length;
var i__10062__auto___13946 = (0);
while(true){
if((i__10062__auto___13946 < len__10061__auto___13945)){
args__10068__auto__.push((arguments[i__10062__auto___13946]));

var G__13947 = (i__10062__auto___13946 + (1));
i__10062__auto___13946 = G__13947;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((1) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((1)),(0),null)):null);
return iron.utils.camelize_map_keys.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10069__auto__);
});

iron.utils.camelize_map_keys.cljs$core$IFn$_invoke$arity$variadic = (function (m,p__13942){
var map__13943 = p__13942;
var map__13943__$1 = ((((!((map__13943 == null)))?((((map__13943.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13943.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13943):map__13943);
var exclude = cljs.core.get.call(null,map__13943__$1,new cljs.core.Keyword(null,"exclude","exclude",-1230250334));
return cljs.core.reduce_kv.call(null,((function (map__13943,map__13943__$1,exclude){
return (function (m__$1,k,v){
return cljs.core.assoc.call(null,m__$1,(cljs.core.truth_(cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([k]),exclude))?k:iron.utils.camelize_key.call(null,k)),v);
});})(map__13943,map__13943__$1,exclude))
,cljs.core.PersistentArrayMap.EMPTY,m);
});

iron.utils.camelize_map_keys.cljs$lang$maxFixedArity = (1);

iron.utils.camelize_map_keys.cljs$lang$applyTo = (function (seq13940){
var G__13941 = cljs.core.first.call(null,seq13940);
var seq13940__$1 = cljs.core.next.call(null,seq13940);
return iron.utils.camelize_map_keys.cljs$core$IFn$_invoke$arity$variadic(G__13941,seq13940__$1);
});

/**
 * Simple helper to show an error message in Clojure or ClojureScript
 */
iron.utils.err = (function iron$utils$err(var_args){
var args__10068__auto__ = [];
var len__10061__auto___13949 = arguments.length;
var i__10062__auto___13950 = (0);
while(true){
if((i__10062__auto___13950 < len__10061__auto___13949)){
args__10068__auto__.push((arguments[i__10062__auto___13950]));

var G__13951 = (i__10062__auto___13950 + (1));
i__10062__auto___13950 = G__13951;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((0) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((0)),(0),null)):null);
return iron.utils.err.cljs$core$IFn$_invoke$arity$variadic(argseq__10069__auto__);
});

iron.utils.err.cljs$core$IFn$_invoke$arity$variadic = (function (strings){
return cljs.core.apply.call(null,console.error,strings);
});

iron.utils.err.cljs$lang$maxFixedArity = (0);

iron.utils.err.cljs$lang$applyTo = (function (seq13948){
return iron.utils.err.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq13948));
});


//# sourceMappingURL=utils.js.map
