// Compiled by ClojureScript 1.9.946 {}
goog.provide('sodium.utils');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('cljs.spec.alpha');
goog.require('iron.utils');
/**
 * Check that each of keys is present in universe.
 *   If not, check more carefully to report a useful warning to the console.
 *   [TODO] Note that this is not a 100% logical place for this function. It is
 *   ClojureScript runtime support for code generated by the defcontrol macro.
 */
sodium.utils.all_keys_valid_QMARK_ = (function sodium$utils$all_keys_valid_QMARK_(keys,universe){
if(cljs.core.truth_(iron.utils.validate.call(null,cljs.core.set_QMARK_,universe))){
} else {
throw (new Error("Assert failed: (validate set? universe)"));
}

if(cljs.core.truth_(clojure.set.subset_QMARK_.call(null,cljs.core.set.call(null,keys),cljs.core.set.call(null,universe)))){
return true;
} else {
return cljs.core.run_BANG_.call(null,(function (key){
if(cljs.core.contains_QMARK_.call(null,universe,key)){
return null;
} else {
return iron.utils.err.call(null,"Keyword ",key," is invalid. Not in ",universe);
}
}),keys);
}
});

//# sourceMappingURL=utils.js.map
