;;; Author: David Goldfarb (deg@degel.com)
;;; Copyright (c) 2017, David Goldfarb

(ns sodium.utils
  (:require
   [clojure.set]
   [clojure.spec.alpha :as s]
   [iron.utils :refer [err validate]]))

(defn all-keys-valid?
  "Check that each of keys is present in universe.
  If not, check more carefully to report a useful warning to the console.
  [TODO] Note that this is not a 100% logical place for this function. It is
  ClojureScript runtime support for code generated by the defcontrol macro."
  [keys universe]
  {:pre [(validate set? universe)]}
  (if (clojure.set/subset? (set keys) (set universe))
    true
    (run! (fn [key]
            (when-not (contains? universe key)
              (err "Keyword " key " is invalid. Not in " universe)))
          keys)))
