// Compiled by ClojureScript 1.9.946 {}
goog.provide('re_frame.events');
goog.require('cljs.core');
goog.require('re_frame.db');
goog.require('re_frame.utils');
goog.require('re_frame.interop');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
goog.require('re_frame.interceptor');
goog.require('re_frame.trace');
re_frame.events.kind = new cljs.core.Keyword(null,"event","event",301435442);
if(cljs.core.truth_(re_frame.registrar.kinds.call(null,re_frame.events.kind))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * `interceptors` might have nested collections, and contain nil elements.
 *   return a flat collection, with all nils removed.
 *   This function is 9/10 about giving good error messages.
 */
re_frame.events.flatten_and_remove_nils = (function re_frame$events$flatten_and_remove_nils(id,interceptors){
var make_chain = (function (p1__15116_SHARP_){
return cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.flatten.call(null,p1__15116_SHARP_));
});
if(!(re_frame.interop.debug_enabled_QMARK_)){
return make_chain.call(null,interceptors);
} else {
if(cljs.core.coll_QMARK_.call(null,interceptors)){
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: when registering ",id,", expected a collection of interceptors, got: ",interceptors);
}

var chain = make_chain.call(null,interceptors);
if(cljs.core.empty_QMARK_.call(null,chain)){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: when registering ",id,", given an empty interceptor chain");
} else {
}

var temp__5457__auto___15117 = cljs.core.first.call(null,cljs.core.remove.call(null,re_frame.interceptor.interceptor_QMARK_,chain));
if(cljs.core.truth_(temp__5457__auto___15117)){
var not_i_15118 = temp__5457__auto___15117;
if(cljs.core.fn_QMARK_.call(null,not_i_15118)){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: when registering ",id,", got a function instead of an interceptor. Did you provide old style middleware by mistake? Got: ",not_i_15118);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: when registering ",id,", expected interceptors, but got: ",not_i_15118);
}
} else {
}

return chain;
}
});
/**
 * Associate the given event `id` with the given collection of `interceptors`.
 * 
 * `interceptors` may contain nested collections and there may be nils
 * at any level,so process this structure into a simple, nil-less vector
 * before registration.
 * 
 * Typically, an `event handler` will be at the end of the chain (wrapped
 * in an interceptor).
 */
re_frame.events.register = (function re_frame$events$register(id,interceptors){
return re_frame.registrar.register_handler.call(null,re_frame.events.kind,id,re_frame.events.flatten_and_remove_nils.call(null,id,interceptors));
});
re_frame.events._STAR_handling_STAR_ = null;
/**
 * Given an event vector `event-v`, look up the associated interceptor chain, and execute it.
 */
re_frame.events.handle = (function re_frame$events$handle(event_v){
var event_id = re_frame.utils.first_in_vector.call(null,event_v);
var temp__5455__auto__ = re_frame.registrar.get_handler.call(null,re_frame.events.kind,event_id,true);
if(cljs.core.truth_(temp__5455__auto__)){
var interceptors = temp__5455__auto__;
if(cljs.core.truth_(re_frame.events._STAR_handling_STAR_)){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: while handling \"",re_frame.events._STAR_handling_STAR_,"\", dispatch-sync was called for \"",event_v,"\". You can't call dispatch-sync within an event handler.");
} else {
var _STAR_handling_STAR_15119 = re_frame.events._STAR_handling_STAR_;
re_frame.events._STAR_handling_STAR_ = event_v;

try{if(re_frame.trace.is_trace_enabled_QMARK_.call(null)){
var _STAR_current_trace_STAR_15120 = re_frame.trace._STAR_current_trace_STAR_;
re_frame.trace._STAR_current_trace_STAR_ = re_frame.trace.start_trace.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"operation","operation",-1267664310),event_id,new cljs.core.Keyword(null,"op-type","op-type",-1636141668),re_frame.events.kind,new cljs.core.Keyword(null,"tags","tags",1771418977),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"event","event",301435442),event_v], null)], null));

try{try{return re_frame.interceptor.execute.call(null,event_v,interceptors);
}finally {if(re_frame.trace.is_trace_enabled_QMARK_.call(null)){
var end__11769__auto___15133 = re_frame.interop.now.call(null);
var duration__11770__auto___15134 = (end__11769__auto___15133 - new cljs.core.Keyword(null,"start","start",-355208981).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
var seq__15121_15135 = cljs.core.seq.call(null,cljs.core.deref.call(null,re_frame.trace.trace_cbs));
var chunk__15122_15136 = null;
var count__15123_15137 = (0);
var i__15124_15138 = (0);
while(true){
if((i__15124_15138 < count__15123_15137)){
var vec__15125_15139 = cljs.core._nth.call(null,chunk__15122_15136,i__15124_15138);
var k__11771__auto___15140 = cljs.core.nth.call(null,vec__15125_15139,(0),null);
var cb__11772__auto___15141 = cljs.core.nth.call(null,vec__15125_15139,(1),null);
try{cb__11772__auto___15141.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__11770__auto___15134,new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now.call(null))], null));
}catch (e15128){if((e15128 instanceof java.lang.Exception)){
var e__11773__auto___15142 = e15128;
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"Error thrown from trace cb",k__11771__auto___15140,"while storing",re_frame.trace._STAR_current_trace_STAR_,e__11773__auto___15142);
} else {
throw e15128;

}
}
var G__15143 = seq__15121_15135;
var G__15144 = chunk__15122_15136;
var G__15145 = count__15123_15137;
var G__15146 = (i__15124_15138 + (1));
seq__15121_15135 = G__15143;
chunk__15122_15136 = G__15144;
count__15123_15137 = G__15145;
i__15124_15138 = G__15146;
continue;
} else {
var temp__5457__auto___15147 = cljs.core.seq.call(null,seq__15121_15135);
if(temp__5457__auto___15147){
var seq__15121_15148__$1 = temp__5457__auto___15147;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__15121_15148__$1)){
var c__9713__auto___15149 = cljs.core.chunk_first.call(null,seq__15121_15148__$1);
var G__15150 = cljs.core.chunk_rest.call(null,seq__15121_15148__$1);
var G__15151 = c__9713__auto___15149;
var G__15152 = cljs.core.count.call(null,c__9713__auto___15149);
var G__15153 = (0);
seq__15121_15135 = G__15150;
chunk__15122_15136 = G__15151;
count__15123_15137 = G__15152;
i__15124_15138 = G__15153;
continue;
} else {
var vec__15129_15154 = cljs.core.first.call(null,seq__15121_15148__$1);
var k__11771__auto___15155 = cljs.core.nth.call(null,vec__15129_15154,(0),null);
var cb__11772__auto___15156 = cljs.core.nth.call(null,vec__15129_15154,(1),null);
try{cb__11772__auto___15156.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__11770__auto___15134,new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now.call(null))], null));
}catch (e15132){if((e15132 instanceof java.lang.Exception)){
var e__11773__auto___15157 = e15132;
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"Error thrown from trace cb",k__11771__auto___15155,"while storing",re_frame.trace._STAR_current_trace_STAR_,e__11773__auto___15157);
} else {
throw e15132;

}
}
var G__15158 = cljs.core.next.call(null,seq__15121_15148__$1);
var G__15159 = null;
var G__15160 = (0);
var G__15161 = (0);
seq__15121_15135 = G__15158;
chunk__15122_15136 = G__15159;
count__15123_15137 = G__15160;
i__15124_15138 = G__15161;
continue;
}
} else {
}
}
break;
}
} else {
}
}}finally {re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR_15120;
}} else {
return re_frame.interceptor.execute.call(null,event_v,interceptors);
}
}finally {re_frame.events._STAR_handling_STAR_ = _STAR_handling_STAR_15119;
}}
} else {
return null;
}
});

//# sourceMappingURL=events.js.map
