// Compiled by ClojureScript 1.9.946 {}
goog.provide('sodium.extensions');
goog.require('cljs.core');
goog.require('cljs.spec.alpha');
goog.require('reagent.core');
goog.require('re_frame.core');
goog.require('re_frame.loggers');
goog.require('iron.re_utils');
goog.require('iron.utils');
goog.require('sodium.core');
goog.require('sodium.utils');
sodium.extensions.header_maker = (function sodium$extensions$header_maker(title,size,dividing_QMARK_,sub_QMARK_){
if(cljs.core.truth_(iron.utils.validate.call(null,cljs.spec.alpha.or_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"event","event",301435442)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","string?","cljs.core/string?",-2072921719,null),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.string_QMARK_,cljs.core.vector_QMARK_], null),null),title))){
} else {
throw (new Error("Assert failed: (validate (s/or :string string? :event vector?) title)"));
}

if(cljs.core.truth_(iron.utils.validate.call(null,cljs.core.boolean_QMARK_,dividing_QMARK_))){
} else {
throw (new Error("Assert failed: (validate boolean? dividing?)"));
}

if(cljs.core.truth_(iron.utils.validate.call(null,new cljs.core.Keyword("sodium","size","sodium/size",352697062),size))){
} else {
throw (new Error("Assert failed: (validate :sodium/size size)"));
}

return sodium.core.header.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"content","content",15833224),((cljs.core.vector_QMARK_.call(null,title))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(iron.re_utils._LT_sub.call(null,title))].join(''):title),new cljs.core.Keyword(null,"size","size",1098693007),size,new cljs.core.Keyword(null,"dividing?","dividing?",-966834650),dividing_QMARK_,new cljs.core.Keyword(null,"sub?","sub?",768712042),sub_QMARK_], null));
});
/**
 * Large header. Title can be either a string or a subscription vector
 */
sodium.extensions.app_header = (function sodium$extensions$app_header(title){
return sodium.extensions.header_maker.call(null,title,new cljs.core.Keyword(null,"large","large",-196820544),true,false);
});
/**
 * Medium header. Title can be either a string or a subscription vector
 */
sodium.extensions.panel_header = (function sodium$extensions$panel_header(title){
return sodium.extensions.header_maker.call(null,title,new cljs.core.Keyword(null,"medium","medium",-1864319384),false,false);
});
/**
 * Small header. Title can be either a string or a subscription vector
 */
sodium.extensions.panel_subheader = (function sodium$extensions$panel_subheader(title){
return sodium.extensions.header_maker.call(null,title,new cljs.core.Keyword(null,"small","small",2133478704),false,false);
});
/**
 * Medium de-emphasized header. Title can be either a string or a subscription vector
 */
sodium.extensions.section_header = (function sodium$extensions$section_header(title){
return sodium.extensions.header_maker.call(null,title,new cljs.core.Keyword(null,"medium","medium",-1864319384),false,true);
});
/**
 * Small de-emphasized header. Title can be either a string or a subscription vector
 */
sodium.extensions.subsection_header = (function sodium$extensions$subsection_header(title){
return sodium.extensions.header_maker.call(null,title,new cljs.core.Keyword(null,"small","small",2133478704),false,true);
});
/**
 * Form field with a label and arbitrary content
 */
sodium.extensions.labelled_field = (function sodium$extensions$labelled_field(var_args){
var args__10068__auto__ = [];
var len__10061__auto___14595 = arguments.length;
var i__10062__auto___14596 = (0);
while(true){
if((i__10062__auto___14596 < len__10061__auto___14595)){
args__10068__auto__.push((arguments[i__10062__auto___14596]));

var G__14597 = (i__10062__auto___14596 + (1));
i__10062__auto___14596 = G__14597;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((0) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((0)),(0),null)):null);
return sodium.extensions.labelled_field.cljs$core$IFn$_invoke$arity$variadic(argseq__10069__auto__);
});

sodium.extensions.labelled_field.cljs$core$IFn$_invoke$arity$variadic = (function (p__14592){
var map__14593 = p__14592;
var map__14593__$1 = ((((!((map__14593 == null)))?((((map__14593.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14593.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14593):map__14593);
var label = cljs.core.get.call(null,map__14593__$1,new cljs.core.Keyword(null,"label","label",1718410804));
var content = cljs.core.get.call(null,map__14593__$1,new cljs.core.Keyword(null,"content","content",15833224));
var field_key = cljs.core.get.call(null,map__14593__$1,new cljs.core.Keyword(null,"field-key","field-key",313262601));
var errors = cljs.core.get.call(null,map__14593__$1,new cljs.core.Keyword(null,"errors","errors",-908790718));
var inline_QMARK_ = cljs.core.get.call(null,map__14593__$1,new cljs.core.Keyword(null,"inline?","inline?",-1674483791));
var error = (function (){var and__8770__auto__ = field_key;
if(cljs.core.truth_(and__8770__auto__)){
return field_key.call(null,errors);
} else {
return and__8770__auto__;
}
})();
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [sodium.core.form_input,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"inline?","inline?",-1674483791),inline_QMARK_,new cljs.core.Keyword(null,"label","label",1718410804),label], null),content,(cljs.core.truth_(error)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [sodium.core.rail,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"position","position",-2011731912),"right",new cljs.core.Keyword(null,"attached?","attached?",548719296),true,new cljs.core.Keyword(null,"class-name","class-name",945142584),"errmsg"], null),error], null):null)], null);
});

sodium.extensions.labelled_field.cljs$lang$maxFixedArity = (0);

sodium.extensions.labelled_field.cljs$lang$applyTo = (function (seq14591){
return sodium.extensions.labelled_field.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq14591));
});

/**
 * Simple HTML text-area, to bypass some problems in Semantic UI (temp?)
 */
sodium.extensions.native_text_area = (function sodium$extensions$native_text_area(p__14598){
var map__14599 = p__14598;
var map__14599__$1 = ((((!((map__14599 == null)))?((((map__14599.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14599.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14599):map__14599);
var params = map__14599__$1;
var on_change = cljs.core.get.call(null,map__14599__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
var placeholder = cljs.core.get.call(null,map__14599__$1,new cljs.core.Keyword(null,"placeholder","placeholder",-104873083));
var rows = cljs.core.get.call(null,map__14599__$1,new cljs.core.Keyword(null,"rows","rows",850049680));
var value = cljs.core.get.call(null,map__14599__$1,new cljs.core.Keyword(null,"value","value",305978217));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),params], null);
});
re_frame.core.reg_sub.call(null,new cljs.core.Keyword("sodium.extensions","all-tags","sodium.extensions/all-tags",-1239783332),(function (db,_){
return cljs.core.set.call(null,cljs.core.get.call(null,db,new cljs.core.Keyword("sodium.extensions","all-tags","sodium.extensions/all-tags",-1239783332)));
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("sodium.extensions","all-tags","sodium.extensions/all-tags",-1239783332),(function (db,p__14601){
var vec__14602 = p__14601;
var _ = cljs.core.nth.call(null,vec__14602,(0),null);
var tags = cljs.core.nth.call(null,vec__14602,(1),null);
return cljs.core.assoc.call(null,db,new cljs.core.Keyword("sodium.extensions","all-tags","sodium.extensions/all-tags",-1239783332),cljs.core.set.call(null,tags));
}));
re_frame.core.reg_sub.call(null,new cljs.core.Keyword("sodium.extensions","selected-tags","sodium.extensions/selected-tags",624707868),(function (db,_){
return cljs.core.set.call(null,cljs.core.get.call(null,db,new cljs.core.Keyword("sodium.extensions","selected-tags","sodium.extensions/selected-tags",624707868)));
}));
re_frame.core.reg_sub.call(null,new cljs.core.Keyword("sodium.extensions","class-of-tag","sodium.extensions/class-of-tag",-234755976),(function (db,p__14605){
var vec__14606 = p__14605;
var _ = cljs.core.nth.call(null,vec__14606,(0),null);
var tag = cljs.core.nth.call(null,vec__14606,(1),null);
return "tag";
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("sodium.extensions","selected-tags","sodium.extensions/selected-tags",624707868),(function (db,p__14609){
var vec__14610 = p__14609;
var _ = cljs.core.nth.call(null,vec__14610,(0),null);
var tags = cljs.core.nth.call(null,vec__14610,(1),null);
return cljs.core.assoc.call(null,db,new cljs.core.Keyword("sodium.extensions","selected-tags","sodium.extensions/selected-tags",624707868),cljs.core.set.call(null,tags));
}));
/**
 * Draw one tag in a list of tags. See draw-tags
 */
sodium.extensions.draw_tag = (function sodium$extensions$draw_tag(p__14613,tag){
var map__14614 = p__14613;
var map__14614__$1 = ((((!((map__14614 == null)))?((((map__14614.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14614.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14614):map__14614);
var selected_tags_sub = cljs.core.get.call(null,map__14614__$1,new cljs.core.Keyword(null,"selected-tags-sub","selected-tags-sub",-1064900210));
var set_selected_tags_event = cljs.core.get.call(null,map__14614__$1,new cljs.core.Keyword(null,"set-selected-tags-event","set-selected-tags-event",1978426974));
var class_of_tag_sub = cljs.core.get.call(null,map__14614__$1,new cljs.core.Keyword(null,"class-of-tag-sub","class-of-tag-sub",1719088835));
var selected_class = cljs.core.get.call(null,map__14614__$1,new cljs.core.Keyword(null,"selected-class","selected-class",36062910));
var unselected_class = cljs.core.get.call(null,map__14614__$1,new cljs.core.Keyword(null,"unselected-class","unselected-class",-1415871608));
var selected_tags = (function (){var or__8782__auto__ = iron.re_utils.sub__GT_fn.call(null,selected_tags_sub).call(null);
if(cljs.core.truth_(or__8782__auto__)){
return or__8782__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})();
var selected_QMARK_ = cljs.core.contains_QMARK_.call(null,selected_tags,tag);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [sodium.core.list_item,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),tag,new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (selected_tags,selected_QMARK_,map__14614,map__14614__$1,selected_tags_sub,set_selected_tags_event,class_of_tag_sub,selected_class,unselected_class){
return (function (){
return iron.re_utils._GT_evt.call(null,cljs.core.conj.call(null,set_selected_tags_event,((selected_QMARK_)?cljs.core.disj:cljs.core.conj).call(null,selected_tags,tag)));
});})(selected_tags,selected_QMARK_,map__14614,map__14614__$1,selected_tags_sub,set_selected_tags_event,class_of_tag_sub,selected_class,unselected_class))
], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(iron.re_utils._LT_sub.call(null,cljs.core.conj.call(null,class_of_tag_sub,tag)))," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((selected_QMARK_)?selected_class:unselected_class))].join('')], null),tag], null)], null);
});
/**
 * Draw a list of tags. Formatting will depend on whether the tag is in the list of
 *   selected tags. Clicking on a tag will toggle it between selected and unselected.
 * 
 *   Options:
 *   - :selected-tags-sub       - Re-frame subscription that returns the set of selected tags
 *   - :set-selected-tags-event - Re-frame event that sets the set of selected tags
 *   - :class-of-tag-sub       - Re-frame subscription that returns the CSS class for a tag
 *   - :selected-class          - CSS class name for selected tags
 *   - :unselected-class        - CSS class name for unselected tags
 *   - :sort?                   - Should the list of tags be sorted
 * 
 *   - tags                     - Set or sequence of tags to display
 */
sodium.extensions.draw_tags = (function sodium$extensions$draw_tags(p__14616,tags){
var map__14617 = p__14616;
var map__14617__$1 = ((((!((map__14617 == null)))?((((map__14617.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14617.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14617):map__14617);
var selected_tags_sub = cljs.core.get.call(null,map__14617__$1,new cljs.core.Keyword(null,"selected-tags-sub","selected-tags-sub",-1064900210),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("sodium.extensions","selected-tags","sodium.extensions/selected-tags",624707868)], null));
var set_selected_tags_event = cljs.core.get.call(null,map__14617__$1,new cljs.core.Keyword(null,"set-selected-tags-event","set-selected-tags-event",1978426974),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("sodium.extensions","selected-tags","sodium.extensions/selected-tags",624707868)], null));
var class_of_tag_sub = cljs.core.get.call(null,map__14617__$1,new cljs.core.Keyword(null,"class-of-tag-sub","class-of-tag-sub",1719088835),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("sodium.extensions","class-of-tag","sodium.extensions/class-of-tag",-234755976)], null));
var selected_class = cljs.core.get.call(null,map__14617__$1,new cljs.core.Keyword(null,"selected-class","selected-class",36062910),"selected-tag");
var unselected_class = cljs.core.get.call(null,map__14617__$1,new cljs.core.Keyword(null,"unselected-class","unselected-class",-1415871608),"unselected-tag");
var sort_QMARK_ = cljs.core.get.call(null,map__14617__$1,new cljs.core.Keyword(null,"sort?","sort?",-567661924),true);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [sodium.core.list_na,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class-name","class-name",945142584),"tags",new cljs.core.Keyword(null,"horizontal?","horizontal?",-423282271),true], null),cljs.core.doall.call(null,cljs.core.map.call(null,cljs.core.partial.call(null,sodium.extensions.draw_tag,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"selected-tags-sub","selected-tags-sub",-1064900210),selected_tags_sub,new cljs.core.Keyword(null,"set-selected-tags-event","set-selected-tags-event",1978426974),set_selected_tags_event,new cljs.core.Keyword(null,"class-of-tag-sub","class-of-tag-sub",1719088835),class_of_tag_sub,new cljs.core.Keyword(null,"selected-class","selected-class",36062910),selected_class,new cljs.core.Keyword(null,"unselected-class","unselected-class",-1415871608),unselected_class], null)),(cljs.core.truth_(sort_QMARK_)?iron.utils.ci_sort.call(null,tags):tags)))], null);
});
/**
 * Component that lets the user add a tag (existing or new) to the set of selected tags.
 * 
 *   Options:
 *   - :all-tags-sub            - Re-frame subscription that returns the set of all tags
 *   - :selected-tags-sub       - Function or re-frame subscription that returns the set of selected tags
 *   - :set-selected-tags-event - Function or re-frame event that sets the external set of selected tags
 *   - :partial-tag-text        - Atom to use to hold text of new tag before it is added. This
 *                             parameter is not often needed, but is important if something
 *                             outside us needs to watch our exact state. I use this, for
 *                             example, when I don't want to let a dialog close if the user
 *                             has started to create a new tag but has not yet saved it.   
 */
sodium.extensions.tag_adder = (function sodium$extensions$tag_adder(p__14619){
var map__14620 = p__14619;
var map__14620__$1 = ((((!((map__14620 == null)))?((((map__14620.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14620.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14620):map__14620);
var all_tags_sub = cljs.core.get.call(null,map__14620__$1,new cljs.core.Keyword(null,"all-tags-sub","all-tags-sub",-522588948),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("sodium.extensions","all-tags","sodium.extensions/all-tags",-1239783332)], null));
var selected_tags_sub = cljs.core.get.call(null,map__14620__$1,new cljs.core.Keyword(null,"selected-tags-sub","selected-tags-sub",-1064900210),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("sodium.extensions","selected-tags","sodium.extensions/selected-tags",624707868)], null));
var set_selected_tags_event = cljs.core.get.call(null,map__14620__$1,new cljs.core.Keyword(null,"set-selected-tags-event","set-selected-tags-event",1978426974),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("sodium.extensions","selected-tags","sodium.extensions/selected-tags",624707868)], null));
var partial_tag_text = cljs.core.get.call(null,map__14620__$1,new cljs.core.Keyword(null,"partial-tag-text","partial-tag-text",-39027322),reagent.core.atom.call(null,""));
return ((function (map__14620,map__14620__$1,all_tags_sub,selected_tags_sub,set_selected_tags_event,partial_tag_text){
return (function (){
var all_tags = iron.re_utils._LT_sub.call(null,all_tags_sub);
var selected_tags = (function (){var or__8782__auto__ = iron.re_utils.sub__GT_fn.call(null,selected_tags_sub).call(null);
if(cljs.core.truth_(or__8782__auto__)){
return or__8782__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})();
var available_tags = iron.utils.ci_sort.call(null,clojure.set.difference.call(null,all_tags,selected_tags));
var list_id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.call(null,"tags-"))].join('');
var input_id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.call(null,"tags-input-"))].join('');
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [sodium.core.grid,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"container?","container?",-1563620041),true], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [sodium.core.grid_row,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [sodium.extensions.draw_tags,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"selected-tags-sub","selected-tags-sub",-1064900210),selected_tags_sub,new cljs.core.Keyword(null,"set-selected-tags-event","set-selected-tags-event",1978426974),set_selected_tags_event], null),selected_tags], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [sodium.core.grid_row,cljs.core.PersistentArrayMap.EMPTY,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"datalist","datalist",-1235043474)),(function (){var x__9736__auto__ = cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"id","id",-1388402092)),(function (){var x__9736__auto__ = list_id;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9736__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9736__auto__);
})(),(function (){var x__9736__auto__ = cljs.core.map.call(null,((function (all_tags,selected_tags,available_tags,list_id,input_id,map__14620,map__14620__$1,all_tags_sub,selected_tags_sub,set_selected_tags_event,partial_tag_text){
return (function (tag){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),tag,new cljs.core.Keyword(null,"value","value",305978217),tag], null)], null);
});})(all_tags,selected_tags,available_tags,list_id,input_id,map__14620,map__14620__$1,all_tags_sub,selected_tags_sub,set_selected_tags_event,partial_tag_text))
,available_tags);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__9736__auto__);
})())))),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sodium.core.input,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"text","text",-1790561697),new cljs.core.Keyword(null,"id","id",-1388402092),input_id,new cljs.core.Keyword(null,"list","list",765357683),list_id,new cljs.core.Keyword(null,"default-value","default-value",232220170),(function (){var or__8782__auto__ = cljs.core.deref.call(null,partial_tag_text);
if(cljs.core.truth_(or__8782__auto__)){
return or__8782__auto__;
} else {
return "";
}
})(),new cljs.core.Keyword(null,"on-change","on-change",-732046149),sodium.core.value__GT_atom_fn.call(null,partial_tag_text),new cljs.core.Keyword(null,"action","action",-811238024),((cljs.core.empty_QMARK_.call(null,cljs.core.deref.call(null,partial_tag_text)))?null:new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"icon","icon",1679606541),"add",new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (all_tags,selected_tags,available_tags,list_id,input_id,map__14620,map__14620__$1,all_tags_sub,selected_tags_sub,set_selected_tags_event,partial_tag_text){
return (function (){
var tags = cljs.core.conj.call(null,selected_tags,cljs.core.deref.call(null,partial_tag_text));
if(cljs.core.vector_QMARK_.call(null,set_selected_tags_event)){
iron.re_utils._GT_evt.call(null,cljs.core.conj.call(null,set_selected_tags_event,tags));
} else {
set_selected_tags_event.call(null,tags);
}

cljs.core.reset_BANG_.call(null,partial_tag_text,"");

return document.getElementById(input_id).value = "";
});})(all_tags,selected_tags,available_tags,list_id,input_id,map__14620,map__14620__$1,all_tags_sub,selected_tags_sub,set_selected_tags_event,partial_tag_text))
], null)),new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),"add tag"], null)], null)], null)], null);
});
;})(map__14620,map__14620__$1,all_tags_sub,selected_tags_sub,set_selected_tags_event,partial_tag_text))
});
/**
 * Component that lets the user select tags
 * 
 *   Options:
 *   - :all-tags-sub            - Re-frame subscription that returns the set of all tags
 *   - :selected-tags-sub       - Re-frame subscription that returns the set of selected tags
 *   - :set-selected-tags-event - Re-frame event that sets the set of selected tags
 */
sodium.extensions.tag_selector = (function sodium$extensions$tag_selector(p__14622){
var map__14623 = p__14622;
var map__14623__$1 = ((((!((map__14623 == null)))?((((map__14623.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14623.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14623):map__14623);
var all_tags_sub = cljs.core.get.call(null,map__14623__$1,new cljs.core.Keyword(null,"all-tags-sub","all-tags-sub",-522588948),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("sodium.extensions","all-tags","sodium.extensions/all-tags",-1239783332)], null));
var selected_tags_sub = cljs.core.get.call(null,map__14623__$1,new cljs.core.Keyword(null,"selected-tags-sub","selected-tags-sub",-1064900210),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("sodium.extensions","selected-tags","sodium.extensions/selected-tags",624707868)], null));
var set_selected_tags_event = cljs.core.get.call(null,map__14623__$1,new cljs.core.Keyword(null,"set-selected-tags-event","set-selected-tags-event",1978426974),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("sodium.extensions","selected-tags","sodium.extensions/selected-tags",624707868)], null));
var available_tags = iron.utils.ci_sort.call(null,iron.re_utils._LT_sub.call(null,all_tags_sub));
var chosen_tags = iron.utils.ci_sort.call(null,iron.re_utils._LT_sub.call(null,selected_tags_sub,cljs.core.PersistentHashSet.EMPTY));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sodium.core.dropdown,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"multiple?","multiple?",-490002283),true,new cljs.core.Keyword(null,"button?","button?",-1099897092),true,new cljs.core.Keyword(null,"value","value",305978217),chosen_tags,new cljs.core.Keyword(null,"on-change","on-change",-732046149),sodium.core.value__GT_event_fn.call(null,set_selected_tags_event,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"default","default",-1987822328),cljs.core.PersistentHashSet.EMPTY,new cljs.core.Keyword(null,"coercer","coercer",1871193355),cljs.core.set], null)),new cljs.core.Keyword(null,"options","options",99638489),sodium.core.dropdown_list.call(null,available_tags,cljs.core.identity,cljs.core.identity)], null)], null);
});
/**
 * Google advert component. See
 *   https://react.semantic-ui.com/views/advertisement and
 *   https://www.google.com/adsense.
 * 
 *   - unit, ad-client, ad-slot - Supplied by your Google ad campaign
 *   - test - Text to render instead of a real ad. You will typically supply
 *   this in your development builds.
 */
sodium.extensions.google_ad = (function sodium$extensions$google_ad(var_args){
var args__10068__auto__ = [];
var len__10061__auto___14632 = arguments.length;
var i__10062__auto___14633 = (0);
while(true){
if((i__10062__auto___14633 < len__10061__auto___14632)){
args__10068__auto__.push((arguments[i__10062__auto___14633]));

var G__14634 = (i__10062__auto___14633 + (1));
i__10062__auto___14633 = G__14634;
continue;
} else {
}
break;
}

var argseq__10069__auto__ = ((((0) < args__10068__auto__.length))?(new cljs.core.IndexedSeq(args__10068__auto__.slice((0)),(0),null)):null);
return sodium.extensions.google_ad.cljs$core$IFn$_invoke$arity$variadic(argseq__10069__auto__);
});

sodium.extensions.google_ad.cljs$core$IFn$_invoke$arity$variadic = (function (p__14626){
var map__14627 = p__14626;
var map__14627__$1 = ((((!((map__14627 == null)))?((((map__14627.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14627.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14627):map__14627);
var unit = cljs.core.get.call(null,map__14627__$1,new cljs.core.Keyword(null,"unit","unit",375175175));
var ad_client = cljs.core.get.call(null,map__14627__$1,new cljs.core.Keyword(null,"ad-client","ad-client",541665022));
var ad_slot = cljs.core.get.call(null,map__14627__$1,new cljs.core.Keyword(null,"ad-slot","ad-slot",1817940310));
var test = cljs.core.get.call(null,map__14627__$1,new cljs.core.Keyword(null,"test","test",577538877));
return reagent.core.create_class.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"display-name","display-name",694513143),"google-ad",new cljs.core.Keyword(null,"component-did-mount","component-did-mount",-1126910518),((function (map__14627,map__14627__$1,unit,ad_client,ad_slot,test){
return (function (){
if(cljs.core.truth_((function (){var and__8770__auto__ = window.adsbygoogle;
if(cljs.core.truth_(and__8770__auto__)){
return cljs.core.not.call(null,test);
} else {
return and__8770__auto__;
}
})())){
return window.adsbygoogle.push(cljs.core.PersistentArrayMap.EMPTY);
} else {
return null;
}
});})(map__14627,map__14627__$1,unit,ad_client,ad_slot,test))
,new cljs.core.Keyword(null,"reagent-render","reagent-render",-985383853),((function (map__14627,map__14627__$1,unit,ad_client,ad_slot,test){
return (function() { 
var G__14635__delegate = function (p__14629){
var map__14630 = p__14629;
var map__14630__$1 = ((((!((map__14630 == null)))?((((map__14630.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14630.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14630):map__14630);
var unit__$1 = cljs.core.get.call(null,map__14630__$1,new cljs.core.Keyword(null,"unit","unit",375175175));
var ad_client__$1 = cljs.core.get.call(null,map__14630__$1,new cljs.core.Keyword(null,"ad-client","ad-client",541665022));
var ad_slot__$1 = cljs.core.get.call(null,map__14630__$1,new cljs.core.Keyword(null,"ad-slot","ad-slot",1817940310));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [sodium.core.advertisement,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"unit","unit",375175175),unit__$1,new cljs.core.Keyword(null,"centered?","centered?",-109742703),true,new cljs.core.Keyword(null,"test","test",577538877),test], null),(cljs.core.truth_(test)?null:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ins","ins",-1021983570),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"class-name","class-name",945142584),"adsbygoogle",new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"display","display",242065432),"block"], null),new cljs.core.Keyword(null,"data-ad-format","data-ad-format",679441596),"auto",new cljs.core.Keyword(null,"data-ad-client","data-ad-client",2116702865),ad_client__$1,new cljs.core.Keyword(null,"data-ad-slot","data-ad-slot",-1374104396),ad_slot__$1], null)], null))], null);
};
var G__14635 = function (var_args){
var p__14629 = null;
if (arguments.length > 0) {
var G__14636__i = 0, G__14636__a = new Array(arguments.length -  0);
while (G__14636__i < G__14636__a.length) {G__14636__a[G__14636__i] = arguments[G__14636__i + 0]; ++G__14636__i;}
  p__14629 = new cljs.core.IndexedSeq(G__14636__a,0,null);
} 
return G__14635__delegate.call(this,p__14629);};
G__14635.cljs$lang$maxFixedArity = 0;
G__14635.cljs$lang$applyTo = (function (arglist__14637){
var p__14629 = cljs.core.seq(arglist__14637);
return G__14635__delegate(p__14629);
});
G__14635.cljs$core$IFn$_invoke$arity$variadic = G__14635__delegate;
return G__14635;
})()
;})(map__14627,map__14627__$1,unit,ad_client,ad_slot,test))
], null));
});

sodium.extensions.google_ad.cljs$lang$maxFixedArity = (0);

sodium.extensions.google_ad.cljs$lang$applyTo = (function (seq14625){
return sodium.extensions.google_ad.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq14625));
});


//# sourceMappingURL=extensions.js.map
