// Compiled by ClojureScript 1.9.671 {}
goog.provide('re_frame.fx');
goog.require('cljs.core');
goog.require('re_frame.router');
goog.require('re_frame.db');
goog.require('re_frame.interceptor');
goog.require('re_frame.interop');
goog.require('re_frame.events');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
re_frame.fx.kind = new cljs.core.Keyword(null,"fx","fx",-1237829572);
if(cljs.core.truth_(re_frame.registrar.kinds.call(null,re_frame.fx.kind))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
re_frame.fx.register = cljs.core.partial.call(null,re_frame.registrar.register_handler,re_frame.fx.kind);
/**
 * An interceptor which actions a `context's` (side) `:effects`.
 * 
 *   For each key in the `:effects` map, call the `effects handler` previously
 *   registered using `reg-fx`.
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 *   call the registered effects handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"do-fx","do-fx",1194163050),new cljs.core.Keyword(null,"after","after",594996914),(function re_frame$fx$do_fx_after(context){
var seq__9913 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__9914 = null;
var count__9915 = (0);
var i__9916 = (0);
while(true){
if((i__9916 < count__9915)){
var vec__9917 = cljs.core._nth.call(null,chunk__9914,i__9916);
var effect_k = cljs.core.nth.call(null,vec__9917,(0),null);
var value = cljs.core.nth.call(null,vec__9917,(1),null);
var temp__5276__auto___9923 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_k,true);
if(cljs.core.truth_(temp__5276__auto___9923)){
var effect_fn_9924 = temp__5276__auto___9923;
effect_fn_9924.call(null,value);
} else {
}

var G__9925 = seq__9913;
var G__9926 = chunk__9914;
var G__9927 = count__9915;
var G__9928 = (i__9916 + (1));
seq__9913 = G__9925;
chunk__9914 = G__9926;
count__9915 = G__9927;
i__9916 = G__9928;
continue;
} else {
var temp__5278__auto__ = cljs.core.seq.call(null,seq__9913);
if(temp__5278__auto__){
var seq__9913__$1 = temp__5278__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__9913__$1)){
var c__8350__auto__ = cljs.core.chunk_first.call(null,seq__9913__$1);
var G__9929 = cljs.core.chunk_rest.call(null,seq__9913__$1);
var G__9930 = c__8350__auto__;
var G__9931 = cljs.core.count.call(null,c__8350__auto__);
var G__9932 = (0);
seq__9913 = G__9929;
chunk__9914 = G__9930;
count__9915 = G__9931;
i__9916 = G__9932;
continue;
} else {
var vec__9920 = cljs.core.first.call(null,seq__9913__$1);
var effect_k = cljs.core.nth.call(null,vec__9920,(0),null);
var value = cljs.core.nth.call(null,vec__9920,(1),null);
var temp__5276__auto___9933 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_k,true);
if(cljs.core.truth_(temp__5276__auto___9933)){
var effect_fn_9934 = temp__5276__auto___9933;
effect_fn_9934.call(null,value);
} else {
}

var G__9935 = cljs.core.next.call(null,seq__9913__$1);
var G__9936 = null;
var G__9937 = (0);
var G__9938 = (0);
seq__9913 = G__9935;
chunk__9914 = G__9936;
count__9915 = G__9937;
i__9916 = G__9938;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.register.call(null,new cljs.core.Keyword(null,"dispatch-later","dispatch-later",291951390),(function (value){
var seq__9939 = cljs.core.seq.call(null,value);
var chunk__9940 = null;
var count__9941 = (0);
var i__9942 = (0);
while(true){
if((i__9942 < count__9941)){
var map__9943 = cljs.core._nth.call(null,chunk__9940,i__9942);
var map__9943__$1 = ((((!((map__9943 == null)))?((((map__9943.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9943.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__9943):map__9943);
var effect = map__9943__$1;
var ms = cljs.core.get.call(null,map__9943__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.call(null,map__9943__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if((cljs.core.empty_QMARK_.call(null,dispatch)) || (!(typeof ms === 'number'))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-later value:",effect);
} else {
re_frame.interop.set_timeout_BANG_.call(null,((function (seq__9939,chunk__9940,count__9941,i__9942,map__9943,map__9943__$1,effect,ms,dispatch){
return (function (){
return re_frame.router.dispatch.call(null,dispatch);
});})(seq__9939,chunk__9940,count__9941,i__9942,map__9943,map__9943__$1,effect,ms,dispatch))
,ms);
}

var G__9947 = seq__9939;
var G__9948 = chunk__9940;
var G__9949 = count__9941;
var G__9950 = (i__9942 + (1));
seq__9939 = G__9947;
chunk__9940 = G__9948;
count__9941 = G__9949;
i__9942 = G__9950;
continue;
} else {
var temp__5278__auto__ = cljs.core.seq.call(null,seq__9939);
if(temp__5278__auto__){
var seq__9939__$1 = temp__5278__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__9939__$1)){
var c__8350__auto__ = cljs.core.chunk_first.call(null,seq__9939__$1);
var G__9951 = cljs.core.chunk_rest.call(null,seq__9939__$1);
var G__9952 = c__8350__auto__;
var G__9953 = cljs.core.count.call(null,c__8350__auto__);
var G__9954 = (0);
seq__9939 = G__9951;
chunk__9940 = G__9952;
count__9941 = G__9953;
i__9942 = G__9954;
continue;
} else {
var map__9945 = cljs.core.first.call(null,seq__9939__$1);
var map__9945__$1 = ((((!((map__9945 == null)))?((((map__9945.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9945.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__9945):map__9945);
var effect = map__9945__$1;
var ms = cljs.core.get.call(null,map__9945__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.call(null,map__9945__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if((cljs.core.empty_QMARK_.call(null,dispatch)) || (!(typeof ms === 'number'))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-later value:",effect);
} else {
re_frame.interop.set_timeout_BANG_.call(null,((function (seq__9939,chunk__9940,count__9941,i__9942,map__9945,map__9945__$1,effect,ms,dispatch,seq__9939__$1,temp__5278__auto__){
return (function (){
return re_frame.router.dispatch.call(null,dispatch);
});})(seq__9939,chunk__9940,count__9941,i__9942,map__9945,map__9945__$1,effect,ms,dispatch,seq__9939__$1,temp__5278__auto__))
,ms);
}

var G__9955 = cljs.core.next.call(null,seq__9939__$1);
var G__9956 = null;
var G__9957 = (0);
var G__9958 = (0);
seq__9939 = G__9955;
chunk__9940 = G__9956;
count__9941 = G__9957;
i__9942 = G__9958;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.register.call(null,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),(function (value){
if(!(cljs.core.vector_QMARK_.call(null,value))){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value);
} else {
return re_frame.router.dispatch.call(null,value);
}
}));
re_frame.fx.register.call(null,new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),(function (value){
if(!(cljs.core.sequential_QMARK_.call(null,value))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-n value. Expected a collection, got got:",value);
} else {
}

var seq__9959 = cljs.core.seq.call(null,value);
var chunk__9960 = null;
var count__9961 = (0);
var i__9962 = (0);
while(true){
if((i__9962 < count__9961)){
var event = cljs.core._nth.call(null,chunk__9960,i__9962);
re_frame.router.dispatch.call(null,event);

var G__9963 = seq__9959;
var G__9964 = chunk__9960;
var G__9965 = count__9961;
var G__9966 = (i__9962 + (1));
seq__9959 = G__9963;
chunk__9960 = G__9964;
count__9961 = G__9965;
i__9962 = G__9966;
continue;
} else {
var temp__5278__auto__ = cljs.core.seq.call(null,seq__9959);
if(temp__5278__auto__){
var seq__9959__$1 = temp__5278__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__9959__$1)){
var c__8350__auto__ = cljs.core.chunk_first.call(null,seq__9959__$1);
var G__9967 = cljs.core.chunk_rest.call(null,seq__9959__$1);
var G__9968 = c__8350__auto__;
var G__9969 = cljs.core.count.call(null,c__8350__auto__);
var G__9970 = (0);
seq__9959 = G__9967;
chunk__9960 = G__9968;
count__9961 = G__9969;
i__9962 = G__9970;
continue;
} else {
var event = cljs.core.first.call(null,seq__9959__$1);
re_frame.router.dispatch.call(null,event);

var G__9971 = cljs.core.next.call(null,seq__9959__$1);
var G__9972 = null;
var G__9973 = (0);
var G__9974 = (0);
seq__9959 = G__9971;
chunk__9960 = G__9972;
count__9961 = G__9973;
i__9962 = G__9974;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.register.call(null,new cljs.core.Keyword(null,"deregister-event-handler","deregister-event-handler",-1096518994),(function (value){
var clear_event = cljs.core.partial.call(null,re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_.call(null,value)){
var seq__9975 = cljs.core.seq.call(null,((cljs.core.sequential_QMARK_.call(null,value))?value:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [value], null)));
var chunk__9976 = null;
var count__9977 = (0);
var i__9978 = (0);
while(true){
if((i__9978 < count__9977)){
var event = cljs.core._nth.call(null,chunk__9976,i__9978);
clear_event.call(null,event);

var G__9979 = seq__9975;
var G__9980 = chunk__9976;
var G__9981 = count__9977;
var G__9982 = (i__9978 + (1));
seq__9975 = G__9979;
chunk__9976 = G__9980;
count__9977 = G__9981;
i__9978 = G__9982;
continue;
} else {
var temp__5278__auto__ = cljs.core.seq.call(null,seq__9975);
if(temp__5278__auto__){
var seq__9975__$1 = temp__5278__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__9975__$1)){
var c__8350__auto__ = cljs.core.chunk_first.call(null,seq__9975__$1);
var G__9983 = cljs.core.chunk_rest.call(null,seq__9975__$1);
var G__9984 = c__8350__auto__;
var G__9985 = cljs.core.count.call(null,c__8350__auto__);
var G__9986 = (0);
seq__9975 = G__9983;
chunk__9976 = G__9984;
count__9977 = G__9985;
i__9978 = G__9986;
continue;
} else {
var event = cljs.core.first.call(null,seq__9975__$1);
clear_event.call(null,event);

var G__9987 = cljs.core.next.call(null,seq__9975__$1);
var G__9988 = null;
var G__9989 = (0);
var G__9990 = (0);
seq__9975 = G__9987;
chunk__9976 = G__9988;
count__9977 = G__9989;
i__9978 = G__9990;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
}));
re_frame.fx.register.call(null,new cljs.core.Keyword(null,"db","db",993250759),(function (value){
return cljs.core.reset_BANG_.call(null,re_frame.db.app_db,value);
}));

//# sourceMappingURL=fx.js.map