/*
 * Decompiled with CFR 0.152.
 */
package io.millesabords.camel.component.arangodb;

import com.arangodb.ArangoDriver;
import com.arangodb.ArangoException;
import com.arangodb.CursorResult;
import com.arangodb.entity.BaseDocument;
import com.arangodb.entity.DocumentEntity;
import io.millesabords.camel.component.arangodb.ArangoDbConstants;
import io.millesabords.camel.component.arangodb.ArangoDbEndpoint;
import io.millesabords.camel.component.arangodb.CamelArangoDbException;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArangoDbProducer
extends DefaultProducer
implements ArangoDbConstants {
    private static final Logger LOG = LoggerFactory.getLogger(ArangoDbProducer.class);
    private final ArangoDbEndpoint endpoint;
    private final ArangoDriver driver;

    public ArangoDbProducer(ArangoDbEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.driver = endpoint.getDriver();
    }

    public void process(Exchange exchange) throws Exception {
        String operation = this.getOperation(exchange);
        LOG.debug("Process operation {}", (Object)operation);
        if ("insert".equals(operation)) {
            this.doInsertDoc(exchange);
        } else if ("update".equals(operation)) {
            this.doUpdateDoc(exchange);
        } else if ("delete".equals(operation)) {
            this.doDeleteDoc(exchange);
        } else if ("get".equals(operation)) {
            this.doGetDoc(exchange);
        } else if ("aql_query".equals(operation)) {
            this.doQuery(exchange);
        } else {
            throw new CamelArangoDbException("Unknown operation " + operation);
        }
    }

    private String getOperation(Exchange exchange) throws CamelArangoDbException {
        String operation = this.endpoint.getOperation();
        if (operation == null) {
            operation = (String)exchange.getIn().getHeader("_arango.operation", String.class);
        }
        if (operation == null) {
            throw new CamelArangoDbException("No operation");
        }
        return operation;
    }

    private String getCollection(Exchange exchange) throws CamelArangoDbException {
        String collection = this.endpoint.getCollection();
        if (collection == null) {
            collection = (String)exchange.getIn().getHeader("_arango.collection", String.class);
        }
        if (collection == null) {
            throw new CamelArangoDbException("No collection");
        }
        return collection;
    }

    private String getQuery(Exchange exchange) throws CamelArangoDbException {
        String aqlQuery = this.endpoint.getAql();
        if (aqlQuery == null) {
            aqlQuery = (String)exchange.getIn().getHeader("_arango.aql_query", String.class);
        }
        if (aqlQuery == null) {
            throw new CamelArangoDbException("No query");
        }
        return aqlQuery;
    }

    private void doInsertDoc(Exchange exchange) throws ArangoException, CamelArangoDbException {
        Object obj = exchange.getIn().getBody();
        DocumentEntity doc = this.driver.createDocument(this.getCollection(exchange), obj);
        exchange.getOut().setBody((Object)doc);
    }

    private void doUpdateDoc(Exchange exchange) throws ArangoException, CamelArangoDbException {
        BaseDocument newdoc = (BaseDocument)exchange.getIn().getBody(BaseDocument.class);
        DocumentEntity doc = this.driver.updateDocument(this.getCollection(exchange), newdoc.getDocumentKey(), (Object)newdoc);
        exchange.getOut().setBody(doc.getEntity());
    }

    private void doGetDoc(Exchange exchange) throws ArangoException, CamelArangoDbException {
        BaseDocument doc;
        block3: {
            String key = (String)exchange.getIn().getBody(String.class);
            doc = null;
            try {
                DocumentEntity entity = this.driver.getDocument(this.getCollection(exchange), key, BaseDocument.class);
                if (entity != null) {
                    doc = (BaseDocument)entity.getEntity();
                }
            }
            catch (ArangoException e) {
                if (e.getCode() == 404) break block3;
                throw e;
            }
        }
        exchange.getOut().setBody(doc);
    }

    private void doDeleteDoc(Exchange exchange) throws ArangoException, CamelArangoDbException {
        DocumentEntity doc = null;
        String documentKey = (String)exchange.getIn().getBody(String.class);
        if (documentKey == null) {
            throw new CamelArangoDbException("No document key");
        }
        doc = this.driver.deleteDocument(this.getCollection(exchange), documentKey);
        exchange.getOut().setBody((Object)doc);
    }

    private void doQuery(Exchange exchange) throws ArangoException, CamelArangoDbException {
        String query = this.getQuery(exchange);
        Map bindVars = (Map)exchange.getIn().getHeader("_arango.aql_query_vars", Map.class);
        CursorResult cursor = this.driver.executeAqlQuery(query, bindVars, null, BaseDocument.class);
        exchange.getOut().setBody((Object)(cursor != null ? cursor.iterator() : null));
    }
}

