/*
 * Decompiled with CFR 0.152.
 */
package org.httpkit.server;

import clojure.lang.IFn;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.httpkit.HeaderMap;
import org.httpkit.HttpUtils;
import org.httpkit.PrefixThreadFactory;
import org.httpkit.server.AsyncChannel;
import org.httpkit.server.Frame;
import org.httpkit.server.HttpHandler;
import org.httpkit.server.HttpRequest;
import org.httpkit.server.IHandler;
import org.httpkit.server.LinkingRunnable;
import org.httpkit.server.RespCallback;
import org.httpkit.server.WSHandler;

public class RingHandler
implements IHandler {
    final ExecutorService execs;
    final IFn handler;

    public RingHandler(int thread, IFn handler, String prefix, int queueSize) {
        PrefixThreadFactory factory = new PrefixThreadFactory(prefix);
        ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(queueSize);
        this.execs = new ThreadPoolExecutor(thread, thread, 0L, TimeUnit.MILLISECONDS, queue, factory);
        this.handler = handler;
    }

    @Override
    public void handle(HttpRequest req, RespCallback cb) {
        try {
            this.execs.submit(new HttpHandler(req, cb, this.handler));
        }
        catch (RejectedExecutionException e) {
            HttpUtils.printError("increase :queue-size if this happens often", e);
            cb.run(HttpUtils.HttpEncode(503, new HeaderMap(), "Server is overloaded, please try later"));
        }
    }

    @Override
    public void close(int timeoutTs) {
        if (timeoutTs > 0) {
            this.execs.shutdown();
            try {
                if (!this.execs.awaitTermination(timeoutTs, TimeUnit.MILLISECONDS)) {
                    this.execs.shutdownNow();
                }
            }
            catch (InterruptedException ie) {
                this.execs.shutdownNow();
                Thread.currentThread().interrupt();
            }
        } else {
            this.execs.shutdownNow();
        }
    }

    @Override
    public void handle(AsyncChannel channel, Frame frame) {
        WSHandler task = new WSHandler(channel, frame);
        LinkingRunnable job = new LinkingRunnable(task);
        LinkingRunnable old = channel.serialTask;
        channel.serialTask = job;
        try {
            if (old == null) {
                this.execs.submit(job);
            } else if (!old.next.compareAndSet(null, job)) {
                this.execs.submit(job);
            }
        }
        catch (RejectedExecutionException e) {
            HttpUtils.printError("increase :queue-size if this happens often", e);
        }
    }

    @Override
    public void clientClose(final AsyncChannel channel, final int status) {
        if (channel.closedRan == 0) {
            if (channel.closeHandler != null) {
                try {
                    this.execs.submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                channel.onClose(status);
                            }
                            catch (Exception e) {
                                HttpUtils.printError("on close handler", e);
                            }
                        }
                    });
                }
                catch (RejectedExecutionException e) {
                    HttpUtils.printError("increase :queue-size if this happens often", e);
                }
            } else {
                AsyncChannel.unsafe.putOrderedInt(channel, AsyncChannel.closedRanOffset, 1);
            }
        }
    }
}

