/*
 * Decompiled with CFR 0.152.
 */
package org.httpkit.server;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.httpkit.ProtocolException;
import org.httpkit.server.Frame;

public class WSDecoder {
    public static final byte OPCODE_CONT = 0;
    public static final byte OPCODE_TEXT = 1;
    public static final byte OPCODE_BINARY = 2;
    public static final byte OPCODE_CLOSE = 8;
    public static final byte OPCODE_PING = 9;
    public static final byte OPCODE_PONG = 10;
    private final int maxSize;
    private State state = State.FRAME_START;
    private byte[] content;
    private int idx = 0;
    private int payloadLength;
    private int payloadRead;
    private int maskingKey;
    private boolean finalFlag;
    private int opcode = -1;
    private int framePayloadIndex;
    private ByteBuffer tmpBuffer = ByteBuffer.allocate(8);

    public WSDecoder(int maxSize) {
        this.maxSize = maxSize;
    }

    private boolean isAvailable(ByteBuffer src, int length) {
        while (this.tmpBuffer.position() < length) {
            if (src.hasRemaining()) {
                this.tmpBuffer.put(src.get());
                continue;
            }
            return false;
        }
        this.tmpBuffer.flip();
        return true;
    }

    public Frame decode(ByteBuffer buffer) throws ProtocolException {
        while (buffer.hasRemaining()) {
            switch (this.state) {
                case FRAME_START: {
                    byte b = buffer.get();
                    this.finalFlag = (b & 0x80) != 0;
                    int tmpOp = b & 0xF;
                    if (this.opcode != -1 && tmpOp != this.opcode) {
                        throw new ProtocolException("opcode mismatch: pre: " + this.opcode + ", now: " + tmpOp);
                    }
                    this.opcode = tmpOp;
                    this.state = State.READ_LENGTH;
                    break;
                }
                case READ_LENGTH: {
                    boolean masked;
                    byte b = buffer.get();
                    boolean bl = masked = (b & 0x80) != 0;
                    if (!masked) {
                        throw new ProtocolException("unmasked client to server frame");
                    }
                    this.payloadLength = b & 0x7F;
                    if (this.payloadLength == 126) {
                        this.state = State.READ_2_LENGTH;
                        break;
                    }
                    if (this.payloadLength == 127) {
                        this.state = State.READ_8_LENGTH;
                        break;
                    }
                    this.state = State.MASKING_KEY;
                    break;
                }
                case READ_2_LENGTH: {
                    if (!this.isAvailable(buffer, 2)) break;
                    this.payloadLength = this.tmpBuffer.getShort() & 0xFFFF;
                    this.tmpBuffer.clear();
                    if (this.payloadLength < 126) {
                        throw new ProtocolException("invalid data frame length (not using minimal length encoding)");
                    }
                    this.state = State.MASKING_KEY;
                    break;
                }
                case READ_8_LENGTH: {
                    if (!this.isAvailable(buffer, 8)) break;
                    long length = this.tmpBuffer.getLong();
                    this.tmpBuffer.clear();
                    if (length < 65536L) {
                        throw new ProtocolException("invalid data frame length. max payload length 4M");
                    }
                    this.abortIfTooLarge(length);
                    this.payloadLength = (int)length;
                    this.state = State.MASKING_KEY;
                    break;
                }
                case MASKING_KEY: {
                    if (!this.isAvailable(buffer, 4)) break;
                    this.maskingKey = this.tmpBuffer.getInt();
                    this.tmpBuffer.clear();
                    if (this.content == null) {
                        this.content = new byte[this.payloadLength];
                    } else if (this.payloadLength > 0) {
                        this.abortIfTooLarge(this.content.length + this.payloadLength);
                        this.content = Arrays.copyOf(this.content, this.content.length + this.payloadLength);
                    }
                    this.framePayloadIndex = 0;
                    this.state = State.PAYLOAD;
                }
                case PAYLOAD: {
                    int read = Math.min(buffer.remaining(), this.payloadLength - this.payloadRead);
                    if (read > 0) {
                        buffer.get(this.content, this.idx, read);
                        byte[] mask = ByteBuffer.allocate(4).putInt(this.maskingKey).array();
                        for (int i = 0; i < read; ++i) {
                            this.content[i + this.idx] = (byte)(this.content[i + this.idx] ^ mask[(this.framePayloadIndex + i) % 4]);
                        }
                        this.payloadRead += read;
                        this.idx += read;
                    }
                    this.framePayloadIndex += read;
                    if (this.payloadRead != this.payloadLength) break;
                    if (this.finalFlag) {
                        switch (this.opcode) {
                            case 1: {
                                return new Frame.TextFrame(this.content);
                            }
                            case 2: {
                                return new Frame.BinaryFrame(this.content);
                            }
                            case 9: {
                                return new Frame.PingFrame(this.content);
                            }
                            case 8: {
                                return new Frame.CloseFrame(this.content);
                            }
                            case 10: {
                                return new Frame.PingFrame(this.content);
                            }
                        }
                        throw new ProtocolException("not impl for opcode: " + this.opcode);
                    }
                    this.state = State.FRAME_START;
                    this.payloadRead = 0;
                }
            }
        }
        return null;
    }

    public void abortIfTooLarge(long length) throws ProtocolException {
        if (length > (long)this.maxSize) {
            throw new ProtocolException("Max payload length 4m, get: " + length);
        }
    }

    public void reset() {
        this.state = State.FRAME_START;
        this.payloadRead = 0;
        this.idx = 0;
        this.opcode = -1;
        this.content = null;
        this.framePayloadIndex = 0;
    }

    public static enum State {
        FRAME_START,
        READ_LENGTH,
        READ_2_LENGTH,
        READ_8_LENGTH,
        MASKING_KEY,
        PAYLOAD,
        CORRUPT;

    }
}

