/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangPid;
import com.ericsson.otp.erlang.OtpErlangString;
import com.ericsson.otp.erlang.OtpInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.zip.DeflaterOutputStream;

public class OtpOutputStream
extends ByteArrayOutputStream {
    public static final int defaultInitialSize = 2048;
    public static final int defaultIncrement = 2048;
    private static final DecimalFormat eform = new DecimalFormat("e+00;e-00");
    private static final BigDecimal ten = new BigDecimal(10.0);
    private static final BigDecimal one = new BigDecimal(1.0);

    public OtpOutputStream() {
        this(2048);
    }

    public OtpOutputStream(int n) {
        super(n);
    }

    public OtpOutputStream(OtpErlangObject otpErlangObject) {
        this();
        this.write_any(otpErlangObject);
    }

    OtpInputStream getOtpInputStream(int n) {
        return new OtpInputStream(this.buf, n, this.count - n, 0);
    }

    public int getPos() {
        return this.count;
    }

    public void write(byte by) {
        if (this.count >= this.buf.length) {
            byte[] byArray = new byte[this.buf.length + 2048];
            System.arraycopy(this.buf, 0, byArray, 0, this.count);
            this.buf = byArray;
        }
        this.buf[this.count++] = by;
    }

    public void write(byte[] byArray) {
        if (this.count + byArray.length > this.buf.length) {
            byte[] byArray2 = new byte[this.buf.length + byArray.length + 2048];
            System.arraycopy(this.buf, 0, byArray2, 0, this.count);
            this.buf = byArray2;
        }
        System.arraycopy(byArray, 0, this.buf, this.count, byArray.length);
        this.count += byArray.length;
    }

    public void write1(long l) {
        this.write((byte)(l & 0xFFL));
    }

    public void writeN(byte[] byArray) {
        this.write(byArray);
    }

    public int length() {
        return this.buf.length;
    }

    @Deprecated
    public int count() {
        return this.count;
    }

    public void write2BE(long l) {
        this.write((byte)((l & 0xFF00L) >> 8));
        this.write((byte)(l & 0xFFL));
    }

    public void write4BE(long l) {
        this.write((byte)((l & 0xFFFFFFFFFF000000L) >> 24));
        this.write((byte)((l & 0xFF0000L) >> 16));
        this.write((byte)((l & 0xFF00L) >> 8));
        this.write((byte)(l & 0xFFL));
    }

    public void write8BE(long l) {
        this.write((byte)(l >> 56 & 0xFFL));
        this.write((byte)(l >> 48 & 0xFFL));
        this.write((byte)(l >> 40 & 0xFFL));
        this.write((byte)(l >> 32 & 0xFFL));
        this.write((byte)(l >> 24 & 0xFFL));
        this.write((byte)(l >> 16 & 0xFFL));
        this.write((byte)(l >> 8 & 0xFFL));
        this.write((byte)(l & 0xFFL));
    }

    public void writeLE(long l, int n) {
        for (int i = 0; i < n; ++i) {
            this.write((byte)(l & 0xFFL));
            l >>= 8;
        }
    }

    public void write2LE(long l) {
        this.write((byte)(l & 0xFFL));
        this.write((byte)((l & 0xFF00L) >> 8));
    }

    public void write4LE(long l) {
        this.write((byte)(l & 0xFFL));
        this.write((byte)((l & 0xFF00L) >> 8));
        this.write((byte)((l & 0xFF0000L) >> 16));
        this.write((byte)((l & 0xFFFFFFFFFF000000L) >> 24));
    }

    public void write8LE(long l) {
        this.write((byte)(l & 0xFFL));
        this.write((byte)(l >> 8 & 0xFFL));
        this.write((byte)(l >> 16 & 0xFFL));
        this.write((byte)(l >> 24 & 0xFFL));
        this.write((byte)(l >> 32 & 0xFFL));
        this.write((byte)(l >> 40 & 0xFFL));
        this.write((byte)(l >> 48 & 0xFFL));
        this.write((byte)(l >> 56 & 0xFFL));
    }

    public void poke4BE(int n, long l) {
        if (n < this.count) {
            this.buf[n + 0] = (byte)((l & 0xFFFFFFFFFF000000L) >> 24);
            this.buf[n + 1] = (byte)((l & 0xFF0000L) >> 16);
            this.buf[n + 2] = (byte)((l & 0xFF00L) >> 8);
            this.buf[n + 3] = (byte)(l & 0xFFL);
        }
    }

    public void write_atom(String string) {
        this.write1(100L);
        this.write2BE(string.length());
        this.writeN(string.getBytes());
    }

    public void write_binary(byte[] byArray) {
        this.write1(109L);
        this.write4BE(byArray.length);
        this.writeN(byArray);
    }

    public void write_bitstr(byte[] byArray, int n) {
        if (n == 0) {
            this.write_binary(byArray);
            return;
        }
        this.write1(77L);
        this.write4BE(byArray.length);
        this.write1(8 - n);
        this.writeN(byArray);
    }

    public void write_boolean(boolean bl) {
        this.write_atom(String.valueOf(bl));
    }

    public void write_byte(byte by) {
        this.write_long((long)by & 0xFFL, true);
    }

    public void write_char(char c) {
        this.write_long((long)c & 0xFFFFL, true);
    }

    public void write_double(double d) {
        this.write1(70L);
        this.write8BE(Double.doubleToLongBits(d));
    }

    public void write_float(float f) {
        this.write_double(f);
    }

    public void write_big_integer(BigInteger bigInteger) {
        if (bigInteger.bitLength() < 64) {
            this.write_long(bigInteger.longValue(), true);
            return;
        }
        int n = bigInteger.signum();
        if (n < 0) {
            bigInteger = bigInteger.negate();
        }
        byte[] byArray = bigInteger.toByteArray();
        int n2 = byArray.length;
        int n3 = n2;
        for (int i = 0; i < n3--; ++i) {
            byte by = byArray[i];
            byArray[i] = byArray[n3];
            byArray[n3] = by;
        }
        if ((n2 & 0xFF) == n2) {
            this.write1(110L);
            this.write1(n2);
        } else {
            this.write1(111L);
            this.write4BE(n2);
        }
        this.write1(n < 0 ? 1L : 0L);
        this.writeN(byArray);
    }

    void write_long(long l, boolean bl) {
        if ((l & 0xFFL) == l) {
            this.write1(97L);
            this.write1(l);
        } else if (l < 0L && bl || l < -134217728L || l > 0x7FFFFFFL) {
            long l2;
            long l3 = bl ? l : (l2 = l < 0L ? -l : l);
            int n = bl ? 0 : (l < 0L ? 1 : 0);
            long l4 = 0xFFFFFFFFL;
            int n2 = 4;
            while ((l2 & l4) != l2) {
                ++n2;
                l4 = l4 << 8 | 0xFFL;
            }
            this.write1(110L);
            this.write1(n2);
            this.write1(n);
            this.writeLE(l2, n2);
        } else {
            this.write1(98L);
            this.write4BE(l);
        }
    }

    public void write_long(long l) {
        this.write_long(l, false);
    }

    public void write_ulong(long l) {
        this.write_long(l, true);
    }

    public void write_int(int n) {
        this.write_long(n, false);
    }

    public void write_uint(int n) {
        this.write_long((long)n & 0xFFFFFFFFL, true);
    }

    public void write_short(short s) {
        this.write_long(s, false);
    }

    public void write_ushort(short s) {
        this.write_long((long)s & 0xFFFFL, true);
    }

    public void write_list_head(int n) {
        if (n == 0) {
            this.write_nil();
        } else {
            this.write1(108L);
            this.write4BE(n);
        }
    }

    public void write_nil() {
        this.write1(106L);
    }

    public void write_tuple_head(int n) {
        if (n < 255) {
            this.write1(104L);
            this.write1(n);
        } else {
            this.write1(105L);
            this.write4BE(n);
        }
    }

    public void write_pid(String string, int n, int n2, int n3) {
        this.write1(103L);
        this.write_atom(string);
        this.write4BE(n & Short.MAX_VALUE);
        this.write4BE(n2 & 0x1FFF);
        this.write1(n3 & 3);
    }

    public void write_port(String string, int n, int n2) {
        this.write1(102L);
        this.write_atom(string);
        this.write4BE(n & 0xFFFFFFF);
        this.write1(n2 & 3);
    }

    public void write_ref(String string, int n, int n2) {
        this.write1(101L);
        this.write_atom(string);
        this.write4BE(n & 0x3FFFF);
        this.write1(n2 & 3);
    }

    public void write_ref(String string, int[] nArray, int n) {
        int n2 = nArray.length;
        if (n2 > 3) {
            n2 = 3;
        }
        if (n2 == 1) {
            this.write_ref(string, nArray[0], n);
        } else {
            this.write1(114L);
            this.write2BE(n2);
            this.write_atom(string);
            this.write1(n & 3);
            this.write4BE(nArray[0] & 0x3FFFF);
            for (int i = 1; i < n2; ++i) {
                this.write4BE(nArray[i]);
            }
        }
    }

    public void write_string(String string) {
        int n = string.length();
        switch (n) {
            case 0: {
                this.write_nil();
                break;
            }
            default: {
                if (n <= 65535 && this.is8bitString(string)) {
                    try {
                        byte[] byArray = string.getBytes("ISO-8859-1");
                        this.write1(107L);
                        this.write2BE(n);
                        this.writeN(byArray);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        this.write_nil();
                    }
                    break;
                }
                char[] cArray = string.toCharArray();
                int[] nArray = OtpErlangString.stringToCodePoints(string);
                this.write_list_head(nArray.length);
                for (int n2 : nArray) {
                    this.write_int(n2);
                }
                this.write_nil();
            }
        }
    }

    private boolean is8bitString(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= '\u0000' && c <= '\u00ff') continue;
            return false;
        }
        return true;
    }

    public void write_compressed(OtpErlangObject otpErlangObject) {
        OtpOutputStream otpOutputStream = new OtpOutputStream(otpErlangObject);
        this.write1(80L);
        this.write4BE(otpOutputStream.size());
        FilterOutputStream filterOutputStream = new FilterOutputStream(this);
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(filterOutputStream);
        try {
            otpOutputStream.writeTo(deflaterOutputStream);
            deflaterOutputStream.close();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Intremediate stream failed for Erlang object " + otpErlangObject);
        }
    }

    public void write_any(OtpErlangObject otpErlangObject) {
        otpErlangObject.encode(this);
    }

    public void write_fun(OtpErlangPid otpErlangPid, String string, long l, int n, byte[] byArray, long l2, long l3, OtpErlangObject[] otpErlangObjectArray) {
        if (n == -1) {
            this.write1(117L);
            this.write4BE(otpErlangObjectArray.length);
            otpErlangPid.encode(this);
            this.write_atom(string);
            this.write_long(l2);
            this.write_long(l3);
            for (OtpErlangObject otpErlangObject : otpErlangObjectArray) {
                otpErlangObject.encode(this);
            }
        } else {
            this.write1(112L);
            int n2 = this.getPos();
            this.write4BE(0L);
            this.write1(n);
            this.writeN(byArray);
            this.write4BE(l2);
            this.write4BE(otpErlangObjectArray.length);
            this.write_atom(string);
            this.write_long(l);
            this.write_long(l3);
            otpErlangPid.encode(this);
            for (OtpErlangObject otpErlangObject : otpErlangObjectArray) {
                otpErlangObject.encode(this);
            }
            this.poke4BE(n2, this.getPos() - n2);
        }
    }

    public void write_external_fun(String string, String string2, int n) {
        this.write1(113L);
        this.write_atom(string);
        this.write_atom(string2);
        this.write_long(n);
    }
}

