(ns exoscale.mania.bc
  "Backward compatibility utils")

(def legacy-keys-ns {:config :exoscale.mania.config
                     :system :exoscale.mania.system
                     :cli :exoscale.mania.cli
                     :hooks :exoscale.mania.hooks
                     :program :exoscale.mania.service})

(defn adapt
  "Rewrite v0 keys to new format"
  [config]
  (-> (reduce-kv (fn [m k v]
                   (let [ns (namespace k)
                         n (name k)]
                     (assoc m
                            (if-let [new-ns (get legacy-keys-ns (keyword ns))]
                              (let [new-key (keyword (name new-ns) n)]
                                (println (format "WARNING: %s is deprecated, use %s instead"
                                                 k
                                                 new-key))
                                new-key)
                              k)
                            v)))
                 {}
                 config)))
