(ns exoscale.mania.reloadable
  (:require [com.stuartsierra.component :as component])
  (:import java.util.concurrent.ScheduledThreadPoolExecutor
           java.util.concurrent.TimeUnit))

(defprotocol Reloadable
  (reload [this]
    "Causes the given component to reload its config.
     Returns a new updated instance of the component."))

;; No-op implementation if the component doesn't supply one
(extend-protocol Reloadable
  java.lang.Object
  (reload [this] this))

;; A simple component which will reload a given system at a configurable interval
(defrecord IntervalReloader [action interval ^ScheduledThreadPoolExecutor executor]
  component/Lifecycle
  (start [this]
    (let [executor (ScheduledThreadPoolExecutor. 1)
          action (reify java.lang.Runnable (run [_] (action)))]
      (.scheduleAtFixedRate executor action interval interval TimeUnit/SECONDS)
      (assoc this
             :executor executor)))
  (stop [this]
    (when (some? executor) (.shutdown executor))
    (assoc this :executor nil)))
