(ns exoscale.mania.service
  (:require [clojure.string :as str]
            [clojure.spec.alpha :as s]
            [clojure.java.io :as io])
  (:import (java.net URL)))

(s/def :exoscale.mania.service/name string?)
(s/def :exoscale.mania.service/version string?)

(defn manifest
  [class]
  (try
    (with-open [r (-> (URL. (format "jar:%s!/META-INF/MANIFEST.MF"
                                    (-> ^Class class
                                        .getProtectionDomain
                                        .getCodeSource
                                        .getLocation)))
                      io/reader)]
      (into {}
            (keep #(some-> %
                           not-empty
                           (str/split #": ")))
            (line-seq r)))
    (catch Exception _
      ;; silently return nil
      )))

(defn version
  [ns]
  (or (some-> (io/resource "VERSION") slurp)
      (some-> (symbol (str ns) "-main")
              find-var
              deref
              class
              manifest
              (get "Leiningen-Project-Version"))))
