(ns exoscale.mania.env
  (:require [aero.core :as aero]))

(defn- get-env [s]
  (System/getenv (str s)))

(defn- get-file
  [value]
  (when-let [file-path (get-env (format "%s_FILE" value))]
    (slurp file-path)))

;; #env-file ENV takes an environment variable, and returns it
;; if unset, but the same variable ending in _FILE is set, the contents of the file will be returned
(defmethod aero/reader 'env-file
  [_ _ value]
  (or (get-env value) (get-file value)))
