(ns exoscale.mania.repl
  (:require [nrepl.server :as srv]
            [clojure.tools.logging :as log]
            [clojure.spec.alpha :as s])
  (:import (java.net URI)))

(s/def :exoscale.mania.repl/bind string?)
(s/def :exoscale.mania.repl/port pos-int?)

(defn parse-repl-uri
  [uri]
  (let [uri (URI. (str "repl://" uri))]
    (s/assert* (s/keys)
               {:exoscale.mania.repl/bind (.getHost uri)
                :exoscale.mania.repl/port (.getPort uri)})))

(def ^:redef server nil)

(defn start!
  [{:exoscale.mania.repl/keys [bind port]
    :or {bind "127.0.0.1"
         port "7999"}}]
  (alter-var-root #'server
                  (fn [_]
                    (log/infof "Starting nREPL server on %s:%s" bind port)
                    (srv/start-server :port port
                                      :bind bind))))
(defn stop! []
  (log/infof "Stopping nREPL server")
  (some-> server srv/stop-server))
