/*
 * Decompiled with CFR 0.152.
 */
package com.factual.data_science_toolkit;

import com.factual.data_science_toolkit.Coord;
import com.factual.driver.FactualApiException;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.common.io.Closeables;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import org.json.JSONException;
import org.json.JSONObject;

public class DataScienceToolkit {
    private static final HttpRequestFactory REQ_FACTORY = new NetHttpTransport().createRequestFactory();
    private final String home = "http://www.datasciencetoolkit.org/";

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Coord streetToCoord(String text) {
        BufferedReader br;
        block5: {
            Coord coord;
            GenericUrl url = new GenericUrl("http://www.datasciencetoolkit.org/street2coordinates/");
            url.appendRawPath(text);
            br = null;
            try {
                HttpRequest request = REQ_FACTORY.buildGetRequest(url);
                br = new BufferedReader(new InputStreamReader(request.execute().getContent()));
                JSONObject rootJsonObj = new JSONObject(br.readLine());
                String key = rootJsonObj.keys().next().toString();
                Object hit = rootJsonObj.get(key);
                if (!(hit instanceof JSONObject)) break block5;
                coord = new Coord((JSONObject)hit);
            }
            catch (IOException e) {
                try {
                    throw new FactualApiException(e);
                    catch (JSONException e2) {
                        throw new FactualApiException((Exception)((Object)e2));
                    }
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(br);
                    throw throwable;
                }
            }
            Closeables.closeQuietly((Closeable)br);
            return coord;
        }
        Closeables.closeQuietly((Closeable)br);
        return null;
    }
}

