/*
 * Decompiled with CFR 0.152.
 */
package com.factual.driver;

import com.factual.driver.Crosswalk;
import com.factual.driver.Response;
import com.google.common.collect.Lists;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CrosswalkResponse
extends Response {
    private final List<Crosswalk> crosswalks = Lists.newArrayList();
    private final String json;

    public CrosswalkResponse(String json) {
        this.json = json;
        try {
            JSONObject rootJsonObj = new JSONObject(json);
            Response.withMeta(this, rootJsonObj);
            this.parseCrosswalks(rootJsonObj.getJSONObject("response").getJSONArray("data"));
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getJson() {
        return this.json;
    }

    public List<Crosswalk> getCrosswalks() {
        return this.crosswalks;
    }

    public Crosswalk first() {
        if (this.crosswalks.isEmpty()) {
            return null;
        }
        return this.crosswalks.get(0);
    }

    public int size() {
        return this.crosswalks.size();
    }

    private void parseCrosswalks(JSONArray arr) throws JSONException {
        int i = 0;
        while (i < arr.length()) {
            this.crosswalks.add(CrosswalkResponse.crosswalkFrom(arr.getJSONObject(i)));
            ++i;
        }
    }

    private static Crosswalk crosswalkFrom(JSONObject jo) throws JSONException {
        Crosswalk cw = new Crosswalk();
        cw.setFactualId(jo.getString("factual_id"));
        cw.setNamespace(jo.getString("namespace"));
        cw.setNamespaceId(jo.getString("namespace_id"));
        cw.setUrl(jo.getString("url"));
        return cw;
    }
}

