/*
 * Decompiled with CFR 0.152.
 */
package com.factual.driver;

import com.factual.driver.Crosswalk;
import com.factual.driver.CrosswalkQuery;
import com.factual.driver.CrosswalkResponse;
import com.factual.driver.FactualApiException;
import com.factual.driver.Query;
import com.factual.driver.ReadResponse;
import com.factual.driver.ResolveQuery;
import com.factual.driver.SchemaResponse;
import com.google.api.client.auth.oauth.OAuthHmacSigner;
import com.google.api.client.auth.oauth.OAuthParameters;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.common.io.Closeables;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Map;

public class Factual {
    private static final String DRIVER_HEADER_TAG = "factual-java-driver-v1.0.2";
    private String factHome = "http://api.v3.factual.com/";
    private final String key;
    private final OAuthHmacSigner signer;

    public Factual(String key, String secret) {
        this.key = key;
        this.signer = new OAuthHmacSigner();
        this.signer.clientSharedSecret = secret;
    }

    public void setFactHome(String urlBase) {
        this.factHome = urlBase;
    }

    public ReadResponse fetch(String tableName, Query query) {
        return new ReadResponse(this.request(this.urlForFetch(tableName, query)));
    }

    public List<Crosswalk> crosswalks(String table, CrosswalkQuery query) {
        return this.fetch(table, query).getCrosswalks();
    }

    public CrosswalkResponse fetch(String tableName, CrosswalkQuery query) {
        return new CrosswalkResponse(this.request(this.urlForCrosswalk(tableName, query)));
    }

    public ReadResponse resolves(ResolveQuery query) {
        return this.fetch("places", query);
    }

    public Map<String, Object> resolve(ResolveQuery query) {
        return this.resolves(query).first();
    }

    public ReadResponse fetch(String tableName, ResolveQuery query) {
        return new ReadResponse(this.request(this.urlForResolve(tableName, query)));
    }

    public SchemaResponse schema(String tableName) {
        return new SchemaResponse(this.request(this.urlForSchema(tableName)));
    }

    private String urlForSchema(String tableName) {
        return String.valueOf(this.factHome) + "t/" + tableName + "/schema";
    }

    private String urlForCrosswalk(String tableName, CrosswalkQuery query) {
        return String.valueOf(this.factHome) + tableName + "/crosswalk?" + query.toUrlQuery();
    }

    private String urlForResolve(String tableName, ResolveQuery query) {
        return String.valueOf(this.factHome) + tableName + "/resolve?" + query.toUrlQuery();
    }

    private String urlForFetch(String tableName, Query query) {
        return String.valueOf(this.factHome) + "t/" + tableName + "?" + query.toUrlQuery();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String request(String urlStr) {
        String string;
        GenericUrl url = new GenericUrl(urlStr);
        String requestMethod = "GET";
        OAuthParameters params = new OAuthParameters();
        params.consumerKey = this.key;
        params.computeNonce();
        params.computeTimestamp();
        params.signer = this.signer;
        BufferedReader br = null;
        try {
            params.computeSignature(requestMethod, url);
            NetHttpTransport transport = new NetHttpTransport();
            HttpRequestFactory f = transport.createRequestFactory((HttpRequestInitializer)params);
            HttpRequest request = f.buildGetRequest(url);
            HttpHeaders headers = new HttpHeaders();
            headers.set("X-Factual-Lib", (Object)DRIVER_HEADER_TAG);
            request.headers = headers;
            br = new BufferedReader(new InputStreamReader(request.execute().getContent()));
            string = br.readLine();
        }
        catch (HttpResponseException e) {
            try {
                throw new FactualApiException((Exception)((Object)e)).requestUrl(urlStr).requestMethod(requestMethod).response(e.response);
                catch (IOException e2) {
                    throw new FactualApiException(e2).requestUrl(urlStr).requestMethod(requestMethod);
                }
                catch (GeneralSecurityException e3) {
                    throw new RuntimeException(e3);
                }
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(br);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)br);
        return string;
    }
}

