/*
 * Decompiled with CFR 0.152.
 */
package com.factual.driver;

import com.factual.driver.Filter;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class FilterGroup
implements Filter {
    private final List<Filter> filters;
    private String op = "$and";

    public FilterGroup(List<Filter> filters) {
        this.filters = filters;
    }

    public FilterGroup(Filter ... filters) {
        this.filters = Lists.newArrayList();
        Filter[] filterArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            Filter f = filterArray[n2];
            this.filters.add(f);
            ++n2;
        }
    }

    public FilterGroup op(String op) {
        this.op = op;
        return this;
    }

    public FilterGroup asOR() {
        return this.op("$or");
    }

    public void add(Filter filter) {
        this.filters.add(filter);
    }

    @Override
    public String toJsonStr() {
        return "{\"" + this.op + "\":[" + this.logicJsonStr() + "]}";
    }

    private String logicJsonStr() {
        ArrayList logics = Lists.newArrayList();
        for (Filter f : this.filters) {
            logics.add(f.toJsonStr());
        }
        return Joiner.on((String)",").join((Iterable)logics);
    }
}

