/*
 * Decompiled with CFR 0.152.
 */
package com.factual.driver;

import com.factual.data_science_toolkit.Coord;
import com.factual.data_science_toolkit.DataScienceToolkit;
import com.factual.driver.Circle;
import com.factual.driver.FactualApiException;
import com.factual.driver.Filter;
import com.factual.driver.FilterGroup;
import com.factual.driver.QueryBuilder;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.List;

public class Query {
    private String fullTextSearch;
    private String[] selectFields;
    private long limit;
    private long offset;
    private boolean includeRowCount;
    private Circle circle;
    private final List<Filter> rowFilters = Lists.newArrayList();
    private final List<String> sorts = Lists.newArrayList();

    public Query search(String term) {
        this.fullTextSearch = term;
        return this;
    }

    public Query limit(long limit) {
        this.limit = limit;
        return this;
    }

    public Query only(String ... fields) {
        this.selectFields = fields;
        return this;
    }

    public String[] getSelectFields() {
        return this.selectFields;
    }

    public Query sortAsc(String field) {
        this.sorts.add(String.valueOf(field) + ":asc");
        return this;
    }

    public Query sortDesc(String field) {
        this.sorts.add(String.valueOf(field) + ":desc");
        return this;
    }

    public Query offset(long offset) {
        this.offset = offset;
        return this;
    }

    public Query includeRowCount() {
        return this.includeRowCount(true);
    }

    public Query includeRowCount(boolean includeRowCount) {
        this.includeRowCount = includeRowCount;
        return this;
    }

    public QueryBuilder criteria(String field) {
        return new QueryBuilder(this, field);
    }

    public QueryBuilder field(String field) {
        return new QueryBuilder(this, field);
    }

    public Query near(String text, int meters) {
        Coord coord = new DataScienceToolkit().streetToCoord(text);
        if (coord != null) {
            return this.within(new Circle(coord, meters));
        }
        throw new FactualApiException("Could not locate place based on text: '" + text + "'");
    }

    public Query within(Circle circle) {
        this.circle = circle;
        return this;
    }

    public Query and(Query ... queries) {
        return this.popFilters("$and", queries);
    }

    public Query or(Query ... queries) {
        return this.popFilters("$or", queries);
    }

    public void add(Filter filter) {
        this.rowFilters.add(filter);
    }

    protected String toUrlQuery() {
        return Joiner.on((String)"&").skipNulls().join((Object)this.urlPair("select", this.fieldsJsonOrNull()), (Object)this.urlPair("q", this.fullTextSearch), new Object[]{this.urlPair("sort", this.sortsJsonOrNull()), this.limit > 0L ? this.urlPair("limit", this.limit) : null, this.offset > 0L ? this.urlPair("offset", this.offset) : null, this.includeRowCount ? this.urlPair("include_count", true) : null, this.urlPair("filters", this.rowFiltersJsonOrNull()), this.urlPair("geo", this.geoBoundsJsonOrNull())});
    }

    public String toString() {
        try {
            return URLDecoder.decode(this.toUrlQuery(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private String urlPair(String name, Object val) {
        if (val != null) {
            try {
                return String.valueOf(name) + "=" + (val instanceof String ? URLEncoder.encode(val.toString(), "UTF-8") : val);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private String fieldsJsonOrNull() {
        if (this.selectFields != null) {
            return Joiner.on((String)",").join((Object[])this.selectFields);
        }
        return null;
    }

    private String sortsJsonOrNull() {
        if (!this.sorts.isEmpty()) {
            return Joiner.on((String)",").join(this.sorts);
        }
        return null;
    }

    private String geoBoundsJsonOrNull() {
        if (this.circle != null) {
            return this.circle.toJsonStr();
        }
        return null;
    }

    private String rowFiltersJsonOrNull() {
        if (this.rowFilters.isEmpty()) {
            return null;
        }
        if (this.rowFilters.size() == 1) {
            return this.rowFilters.get(0).toJsonStr();
        }
        return new FilterGroup(this.rowFilters).toJsonStr();
    }

    private Query popFilters(String op, Query ... queries) {
        FilterGroup group = new FilterGroup(new Filter[0]).op(op);
        Query[] queryArray = queries;
        int n = queries.length;
        int n2 = 0;
        while (n2 < n) {
            Query q = queryArray[n2];
            group.add(this.pop(q.rowFilters));
            ++n2;
        }
        this.add(group);
        return this;
    }

    private Filter pop(List<Filter> list) {
        return list.remove(list.size() - 1);
    }
}

