/*
 * Decompiled with CFR 0.152.
 */
package com.factual.driver;

import com.factual.driver.FieldFilter;
import com.factual.driver.Query;
import com.google.common.base.Joiner;
import java.util.List;

public class QueryBuilder {
    private final Query query;
    private final String fieldName;

    public QueryBuilder(Query query, String fieldName) {
        this.query = query;
        this.fieldName = fieldName;
    }

    public Query search(Object arg) {
        return this.addFilter("$search", arg);
    }

    public Query equal(Object arg) {
        return this.addFilter("$eq", arg);
    }

    public Query notEqual(Object arg) {
        return this.addFilter("$neq", arg);
    }

    public Query in(List<Object> args) {
        return this.addFilter("$in", Joiner.on((String)",").join(args));
    }

    public Query in(Object ... args) {
        return this.addFilter("$in", Joiner.on((String)",").join(args));
    }

    public Query notIn(List<Object> args) {
        return this.addFilter("$nin", Joiner.on((String)",").join(args));
    }

    public Query notIn(Object ... args) {
        return this.addFilter("$nin", Joiner.on((String)",").join(args));
    }

    public Query beginsWith(String arg) {
        return this.addFilter("$bw", arg);
    }

    public Query notBeginsWith(String arg) {
        return this.addFilter("$nbw", arg);
    }

    public Query beginsWithAny(Object ... args) {
        return this.addFilter("$bwin", Joiner.on((String)",").join(args));
    }

    public Query notBeginsWithAny(Object ... args) {
        return this.addFilter("$nbwin", Joiner.on((String)",").join(args));
    }

    public Query blank() {
        return this.addFilter("$blank", true);
    }

    public Query notBlank() {
        return this.addFilter("$blank", false);
    }

    public Query greaterThan(Object arg) {
        return this.addFilter("$gt", arg);
    }

    public Query greaterThanOrEqual(Object arg) {
        return this.addFilter("$gte", arg);
    }

    public Query lessThan(Object arg) {
        return this.addFilter("$lt", arg);
    }

    public Query lessThanOrEqual(Object arg) {
        return this.addFilter("$lte", arg);
    }

    private Query addFilter(String op, Object arg) {
        this.query.add(new FieldFilter(op, this.fieldName, arg));
        return this.query;
    }
}

