/*
 * Decompiled with CFR 0.152.
 */
package com.factual.driver;

import com.factual.driver.JsonUtil;
import com.factual.driver.Response;
import com.factual.driver.Tabular;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class ReadResponse
extends Response
implements Tabular {
    private final String json;
    private List<Map<String, Object>> data = Lists.newArrayList();

    public ReadResponse(String json) {
        this.json = json;
        try {
            JSONObject rootJsonObj = new JSONObject(json);
            Response.withMeta(this, rootJsonObj);
            this.data = JsonUtil.data(rootJsonObj.getJSONObject("response").getJSONArray("data"));
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getJson() {
        return this.json;
    }

    public Map<String, Object> first() {
        if (this.data.isEmpty()) {
            return null;
        }
        return this.data.get(0);
    }

    @Override
    public List<Map<String, Object>> getData() {
        return this.data;
    }

    public int size() {
        return this.data.size();
    }

    public Collection<String> mapStrings(final String field) {
        return Collections2.transform(this.data, (Function)new Function<Map<String, Object>, String>(){

            public String apply(Map<String, Object> row) {
                Object val = row.get(field);
                return val != null ? val.toString() : null;
            }
        });
    }
}

