/*
 * Decompiled with CFR 0.152.
 */
package com.factual.driver;

import org.json.JSONException;
import org.json.JSONObject;

public abstract class Response {
    public static final int UNDEFINED = -1;
    private String version;
    private String status;
    private int totalRowCount = -1;
    private int includedRows;

    public String getStatus() {
        return this.status;
    }

    public String getVersion() {
        return this.version;
    }

    public int getTotalRowCount() {
        return this.totalRowCount;
    }

    public int getIncludedRowCount() {
        return this.includedRows;
    }

    public boolean isEmpty() {
        return this.includedRows == 0;
    }

    public static void withMeta(Response resp, JSONObject rootJsonObj) {
        try {
            resp.version = rootJsonObj.getString("version");
            resp.status = rootJsonObj.getString("status");
            JSONObject respJson = rootJsonObj.getJSONObject("response");
            if (respJson.has("total_row_count")) {
                resp.totalRowCount = respJson.getInt("total_row_count");
            }
            if (respJson.has("included_rows")) {
                resp.includedRows = respJson.getInt("included_rows");
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.getJson();
    }

    public abstract String getJson();
}

