/*
 * Decompiled with CFR 0.152.
 */
package com.factual.driver;

import com.factual.driver.ColumnSchema;
import com.factual.driver.JsonUtil;
import com.factual.driver.Response;
import com.factual.driver.Tabular;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class SchemaResponse
extends Response
implements Tabular {
    private final String json;
    private final Map<String, ColumnSchema> columnSchemas;
    private final String title;
    private final boolean searchEnabled;
    private final boolean geoEnabled;
    private final String description;
    private final List<Map<String, Object>> data;

    public SchemaResponse(String json) {
        this.json = json;
        try {
            JSONObject rootJsonObj = new JSONObject(json);
            Response.withMeta(this, rootJsonObj);
            JSONObject respObj = rootJsonObj.getJSONObject("response");
            JSONObject view = respObj.getJSONObject("view");
            this.data = JsonUtil.data(view.getJSONArray("fields"));
            this.columnSchemas = this.makeColumnSchemas(this.data);
            this.title = view.getString("title");
            this.description = view.getString("description");
            this.searchEnabled = view.getBoolean("search_enabled");
            this.geoEnabled = view.getBoolean("geo_enabled");
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, ColumnSchema> makeColumnSchemas(List<Map<String, Object>> data) {
        HashMap schemas = Maps.newHashMap();
        for (Map<String, Object> smap : data) {
            schemas.put(smap.get("name").toString(), new ColumnSchema(smap));
        }
        return schemas;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isSearchEnabled() {
        return this.searchEnabled;
    }

    public boolean isGeoEnabled() {
        return this.geoEnabled;
    }

    @Override
    public String getJson() {
        return this.json;
    }

    public int size() {
        return this.columnSchemas.size();
    }

    public Map<String, ColumnSchema> getColumnSchemas() {
        return this.columnSchemas;
    }

    public ColumnSchema getColumnSchema(String columnName) {
        return this.columnSchemas.get(columnName);
    }

    @Override
    public List<Map<String, Object>> getData() {
        return this.data;
    }
}

