(ns com.wsscode.tailwind-garden.components.accessibility)

(defn screen-readers
  "https://tailwindcss.com/docs/screen-readers"
  []
  [[:.sr-only {:position     "absolute"
               :width        "1px"
               :height       "1px"
               :padding      "0"
               :margin       "-1px"
               :overflow     "hidden"
               :clip         "rect(0, 0, 0, 0)"
               :white-space  "nowrap"
               :border-width "0"}]
   [:.not-sr-only {:position    "static"
                   :width       "auto"
                   :height      "auto"
                   :padding     "0"
                   :margin      "0"
                   :overflow    "visible"
                   :clip        "auto"
                   :white-space "normal"}]])
