/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.avro.schemagenerator.data;

import com.flipkart.aesop.avro.schemagenerator.data.MysqlToAvroMapper;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableRecord {
    private String name;
    private String type;
    private String doc;
    private String namespace;
    private String meta;
    private List<Field> fields;

    public TableRecord(String name, String type, String doc, String namespace, List<String> primaryKeys, List<Field> fields) {
        this.name = name;
        this.type = type;
        this.doc = doc;
        this.namespace = namespace;
        this.meta = "pk=" + StringUtils.join(primaryKeys, (String)",");
        this.fields = fields;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDoc() {
        return this.doc;
    }

    public void setDoc(String doc) {
        this.doc = doc;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getMeta() {
        return this.meta;
    }

    public void setMeta(String meta) {
        this.meta = meta;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public static class Field {
        private String name;
        private String[] type;
        private String meta;

        public Field(String dbFieldName, String dbFieldType, int dbFieldPosition) {
            this.name = dbFieldName;
            this.type = new String[]{MysqlToAvroMapper.valueOf(dbFieldType.toUpperCase()).getAvroType(), "null"};
            this.meta = "dbFieldName=" + dbFieldName + ";dbFieldPosition=" + dbFieldPosition + ";dbFieldType=" + dbFieldType;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String[] getType() {
            return this.type;
        }

        public void setType(String[] type) {
            this.type = type;
        }

        public String getMeta() {
            return this.meta;
        }

        public void setMeta(String meta) {
            this.meta = meta;
        }
    }
}

