/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.avro.schemagenerator.main;

import com.flipkart.aesop.avro.schemagenerator.main.SchemaGenerator;
import com.flipkart.aesop.avro.schemagenerator.mysql.DataSourceConfig;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.lang.StringUtils;

public class SchemaGeneratorCli {
    public static void main(String[] commandLineArguments) {
        GnuParser cmdLineGnuParser = new GnuParser();
        Options gnuOptions = SchemaGeneratorCli.constructOptions();
        try {
            CommandLine commandLine = cmdLineGnuParser.parse(gnuOptions, commandLineArguments);
            if (commandLine.hasOption("help")) {
                SchemaGeneratorCli.printHelp(StringUtils.join((Object[])commandLineArguments, (String)" "), gnuOptions, 80, "", "", 3, 5, true, System.out);
                return;
            }
            if (!commandLine.hasOption("d")) {
                throw new Exception("mandatory parameter db missing;");
            }
            ArrayList<DataSourceConfig> dataSourceConfigs = new ArrayList<DataSourceConfig>();
            HashMap<String, List<String>> tablesInclusionListMap = new HashMap<String, List<String>>();
            HashMap<String, List<String>> tablesExclusionListMap = new HashMap<String, List<String>>();
            DataSourceConfig dataSourceConfig = new DataSourceConfig();
            dataSourceConfig.setDbName(commandLine.getOptionValue("d"));
            dataSourceConfig.setHostName(commandLine.hasOption("h") ? commandLine.getOptionValue("h") : "localhost");
            dataSourceConfig.setPort(commandLine.hasOption("o") ? commandLine.getOptionValue("o") : "3306");
            dataSourceConfig.setUserName(commandLine.hasOption("u") ? commandLine.getOptionValue("u") : "root");
            dataSourceConfig.setPassword(commandLine.hasOption("p") ? commandLine.getOptionValue("p") : "");
            dataSourceConfigs.add(dataSourceConfig);
            List<String> dbInclusionTableList = commandLine.hasOption("i") ? Arrays.asList(commandLine.getOptionValues("i")) : null;
            List<String> dbExclusionTableList = commandLine.hasOption("e") ? Arrays.asList(commandLine.getOptionValues("e")) : null;
            tablesInclusionListMap.put(commandLine.getOptionValue("d"), dbInclusionTableList);
            tablesExclusionListMap.put(commandLine.getOptionValue("d"), dbExclusionTableList);
            SchemaGenerator schemaGenerator = new SchemaGenerator(dataSourceConfigs, tablesInclusionListMap, tablesExclusionListMap);
            System.out.println("Generating Schema ...\n");
            if (commandLine.hasOption("t")) {
                String schema = schemaGenerator.generateSchema(commandLine.getOptionValue("d"), commandLine.getOptionValue("t"));
                System.out.println(schema);
            } else {
                Map<String, String> tableNameToSchema = schemaGenerator.generateSchemaForAllTables(commandLine.getOptionValue("d"));
                for (String tableName : tableNameToSchema.keySet()) {
                    System.out.println("\n=====" + tableName + "=====\n");
                    System.out.println(tableNameToSchema.get(tableName));
                    System.out.println("\n=====End=====\n");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Options constructOptions() {
        Options gnuOptions = new Options();
        Options options = gnuOptions.addOption("h", "host", true, "host name for connection ; default localhost").addOption("o", "port", true, "port for connection ; default 3306").addOption("u", "user", true, "user name for connection ; default root").addOption("p", "password", true, "password for the connection ; default empty string").addOption("t", "table", true, "table name for schema generation ; default all ").addOption("e", "exclusion-list", true, "exclusion list ; default none").addOption("i", "inclusion-list", true, "inclusion list ; default all").addOption("?", "help", false, "help");
        OptionBuilder.withArgName((String)"dbName");
        OptionBuilder.withLongOpt((String)"db");
        OptionBuilder.withDescription((String)"db name for connection");
        OptionBuilder.hasArg();
        Options options2 = options.addOption(OptionBuilder.create((char)'d'));
        OptionBuilder.withArgName((String)"args");
        OptionBuilder.withLongOpt((String)"exclusion-list");
        OptionBuilder.withDescription((String)"exclusion list ; default none");
        OptionBuilder.hasArgs();
        Options options3 = options2.addOption(OptionBuilder.create((char)'e'));
        OptionBuilder.withArgName((String)"args");
        OptionBuilder.withLongOpt((String)"inclusion-list");
        OptionBuilder.withDescription((String)"inclusion list ; default none");
        OptionBuilder.hasArgs();
        options3.addOption(OptionBuilder.create((char)'i'));
        return gnuOptions;
    }

    public static void printHelp(String commandLineSyntax, Options options, int printedRowWidth, String header, String footer, int spacesBeforeOption, int spacesBeforeOptionDescription, boolean displayUsage, OutputStream out) {
        PrintWriter writer = new PrintWriter(out);
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp(writer, printedRowWidth, commandLineSyntax, header, options, spacesBeforeOption, spacesBeforeOptionDescription, footer, displayUsage);
        writer.flush();
    }
}

