/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.avro.schemagenerator.main.common;

import java.io.IOException;
import java.util.List;
import jline.Completor;
import jline.ConsoleReader;
import jline.SimpleCompletor;

public class JLineHelper {
    static ConsoleReader _reader;
    static Completor _currentCompletor;

    static {
        _currentCompletor = null;
    }

    public JLineHelper(String prompt) {
        try {
            _reader = new ConsoleReader();
            _reader.setDefaultPrompt(prompt);
            _reader.setBellEnabled(false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String checkAndRead() throws IOException {
        String line = _reader.readLine();
        if (line == null) {
            System.out.println("Unable to read a valid input from the console");
            return null;
        }
        return line.trim();
    }

    public void addArrayToCompletor(String[] completorArray) {
        this.removeCurrentCompletor();
        if (completorArray == null || completorArray.length == 0) {
            return;
        }
        _currentCompletor = new SimpleCompletor(completorArray);
        _reader.addCompletor(_currentCompletor);
    }

    public void removeCurrentCompletor() {
        if (_currentCompletor != null) {
            _reader.removeCompletor(_currentCompletor);
        }
        _currentCompletor = null;
    }

    public void addListToCompletor(List<String> completorList) {
        if (completorList == null || completorList.size() == 0) {
            return;
        }
        String[] completorArray = completorList.toArray(new String[completorList.size()]);
        this.addArrayToCompletor(completorArray);
    }
}

