/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.avro.schemagenerator.main;

import com.flipkart.aesop.avro.schemagenerator.main.SchemaGenerator;
import com.flipkart.aesop.avro.schemagenerator.main.common.JLineHelper;
import com.flipkart.aesop.avro.schemagenerator.mysql.DataSourceConfig;
import com.flipkart.aesop.avro.schemagenerator.mysql.MysqlUtils;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractiveSchemaGenerator {
    private State currentState = State.WELCOME;
    boolean _verbose = true;
    String _database;
    String _databasehost = "localhost";
    String _userName = "root";
    String _password;
    List<String> _tableNames;
    List<String> _primaryKeys = null;
    List<String> _userFields = null;
    JLineHelper jlineObj;
    SchemaGenerator schemaGenerator;

    public static void main(String[] args) throws Exception {
        InteractiveSchemaGenerator obj = new InteractiveSchemaGenerator();
        obj.run();
    }

    public void run() throws Exception {
        this.printWelcomeMessage();
        this.jlineObj = new JLineHelper("SchemaGen>");
        this.processInput();
    }

    private void printWelcomeMessage() {
        System.out.println("Welcome to AVRO schema generation tool.");
    }

    private void processInput() throws Exception {
        boolean done = false;
        block7: while (!done) {
            switch (this.currentState) {
                case WELCOME: {
                    System.out.println("This tools will only work for Mysql to get Avro schemas. Press enter to continue...");
                    String line = this.jlineObj.checkAndRead();
                    if (!line.isEmpty()) {
                        System.out.println("Wrong input.");
                        continue block7;
                    }
                    this.currentState = State.INITIATECONN;
                }
                case INITIATECONN: {
                    System.out.println("Enter the Databse Name:");
                    this._database = this.jlineObj.checkAndRead();
                    System.out.println("Enter the Databse host:");
                    this._databasehost = this.jlineObj.checkAndRead();
                    System.out.println("Enter the Username for the Database:");
                    this._userName = this.jlineObj.checkAndRead();
                    System.out.println("Enter the password for the database:");
                    this._password = this.jlineObj.checkAndRead();
                    System.out.println("Attempting to connect with the database..");
                    this.currentState = State.TABLEINFO;
                    this.initilizeDB(this._database, this._databasehost, this._userName, this._password);
                    continue block7;
                }
                case TABLEINFO: {
                    List<String> tablesList = null;
                    tablesList = MysqlUtils.getTablesInDB(this._database);
                    this.jlineObj.addListToCompletor(tablesList);
                    System.out.println("Enter the name of table you would like to generate the schema for (use tab to autocomplete table names), Hit enter to generate for all tables...");
                    String line = this.jlineObj.checkAndRead();
                    if (line == null || line.isEmpty()) {
                        this._tableNames = tablesList;
                    } else {
                        this._tableNames = new ArrayList<String>(Arrays.asList(line.split(",")));
                        if (!this.areTablesValid()) continue block7;
                    }
                    System.out.println("Generating schema for [" + this._tableNames + "]");
                    this.jlineObj.removeCurrentCompletor();
                    this.currentState = State.SCHEMA_MANIPULATION;
                    continue block7;
                }
                case SCHEMA_MANIPULATION: {
                    this.runSchemaGenTool();
                    this.currentState = State.EXIT;
                    continue block7;
                }
                case EXIT: {
                    System.out.println("Schema generation is complete");
                    done = true;
                    continue block7;
                }
            }
            throw new Exception("Undefined state!");
        }
    }

    public boolean runSchemaGenTool() {
        for (String table : this._tableNames) {
            try {
                System.out.println(this.schemaGenerator.generateSchema(this._database, table));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private List<String> fieldToList(String database, String fieldList, String table) {
        String[] fieldArray = fieldList.split(",");
        ArrayList<String> fieldArrayList = new ArrayList<String>();
        if (fieldList.length() == 0) {
            return null;
        }
        for (String field : fieldArray) {
            if (!MysqlUtils.isValidField(this._database, field.trim(), table)) {
                System.out.println("The field " + field + " is not a valid field in the table, please retry");
                return null;
            }
            fieldArrayList.add(field.trim().toUpperCase(Locale.ENGLISH));
        }
        return fieldArrayList;
    }

    private void initilizeDB(String _database, String _databasehost, String _userName, String _password) {
        DataSourceConfig dataSourceConfig = new DataSourceConfig();
        dataSourceConfig.setDbName(_database);
        dataSourceConfig.setHostName(_databasehost);
        dataSourceConfig.setUserName(_userName);
        dataSourceConfig.setPassword(_password);
        ArrayList<DataSourceConfig> dataSourceConfigs = new ArrayList<DataSourceConfig>();
        dataSourceConfigs.add(dataSourceConfig);
        try {
            this.schemaGenerator = new SchemaGenerator(dataSourceConfigs);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
    }

    private boolean areTablesValid() {
        for (String table : this._tableNames) {
            if (MysqlUtils.isValidTable(this._database, table)) continue;
            System.out.println("This table [" + table + "] doesn't appear to be valid table or view, please retry");
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        WELCOME,
        INITIATECONN,
        TABLEINFO,
        SCHEMA_MANIPULATION,
        GENERATE_RELAY_SRC_CONFIGS,
        EXIT;

    }
}

