/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.avro.schemagenerator.main;

import com.flipkart.aesop.avro.schemagenerator.data.TableRecord;
import com.flipkart.aesop.avro.schemagenerator.mysql.DataSourceConfig;
import com.flipkart.aesop.avro.schemagenerator.mysql.MysqlConnectionProvider;
import com.flipkart.aesop.avro.schemagenerator.mysql.MysqlUtils;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.InitializingBean;

public class SchemaGenerator
implements InitializingBean {
    private List<DataSourceConfig> dataSourceConfigs = new ArrayList<DataSourceConfig>();
    private Map<String, List<String>> tablesInclusionListMap = new HashMap<String, List<String>>();
    private Map<String, List<String>> tablesExclusionListMap = new HashMap<String, List<String>>();
    private ObjectMapper objectMapper = new ObjectMapper();
    private JsonFactory jsonFactory = new JsonFactory();
    private SimpleDateFormat df = new SimpleDateFormat("MMM dd, yyyy hh:mm:ss a zzz");

    public SchemaGenerator(List<DataSourceConfig> dataSourceConfigs, Map<String, List<String>> tablesInclusionListMap, Map<String, List<String>> tablesExclusionListMap) throws PropertyVetoException {
        for (DataSourceConfig dataSourceConfig : dataSourceConfigs) {
            MysqlConnectionProvider.getInstance().addDataSource(dataSourceConfig);
        }
        this.tablesInclusionListMap = tablesInclusionListMap;
        this.tablesExclusionListMap = tablesExclusionListMap;
    }

    public SchemaGenerator(List<DataSourceConfig> dataSourceConfigs) throws PropertyVetoException {
        for (DataSourceConfig dataSourceConfig : dataSourceConfigs) {
            MysqlConnectionProvider.getInstance().addDataSource(dataSourceConfig);
        }
    }

    public SchemaGenerator() {
    }

    public Map<String, String> generateSchemaForAllTables(String dbName) throws IOException {
        HashMap<String, String> tableNameToSchemaMap = new HashMap<String, String>();
        List<String> tableNameList = MysqlUtils.getTablesInDB(dbName);
        for (String tableName : tableNameList) {
            if (this.tablesExclusionListMap.get(dbName) != null && this.tablesExclusionListMap.get(dbName).contains(tableName) || this.tablesInclusionListMap.get(dbName) != null && !this.tablesInclusionListMap.get(dbName).contains(tableName)) continue;
            tableNameToSchemaMap.put(tableName, this.generateSchema(dbName, tableName));
        }
        return tableNameToSchemaMap;
    }

    public String generateSchema(String dbName, String tableName) throws IOException, IllegalArgumentException {
        if (this.tablesExclusionListMap.get(dbName) != null && this.tablesExclusionListMap.get(dbName).contains(tableName) || this.tablesInclusionListMap.get(dbName) != null && !this.tablesInclusionListMap.get(dbName).contains(tableName)) {
            throw new IllegalArgumentException("table is excluded for the schema generation in the settings");
        }
        List<TableRecord.Field> fields = MysqlUtils.getFieldDetails(dbName, tableName);
        List<String> primaryKeys = MysqlUtils.getPrimaryKeys(dbName, tableName);
        String namespace = dbName;
        String doc = "Auto-generated Avro schema for " + tableName + ". Generated at " + this.df.format(new Date(System.currentTimeMillis()));
        TableRecord tableRecord = new TableRecord(tableName, "record", doc, namespace, primaryKeys, fields);
        StringWriter writer = new StringWriter();
        JsonGenerator jsonGenerator = this.jsonFactory.createJsonGenerator((Writer)writer);
        jsonGenerator.useDefaultPrettyPrinter();
        this.objectMapper.writeValue(jsonGenerator, (Object)tableRecord);
        return writer.getBuffer().toString();
    }

    public void afterPropertiesSet() throws PropertyVetoException {
        for (DataSourceConfig dataSourceConfig : this.dataSourceConfigs) {
            MysqlConnectionProvider.getInstance().addDataSource(dataSourceConfig);
        }
    }

    public List<DataSourceConfig> getDataSourceConfigs() {
        return this.dataSourceConfigs;
    }

    public void setDataSourceConfigs(List<DataSourceConfig> dataSourceConfigs) {
        this.dataSourceConfigs = dataSourceConfigs;
    }

    public Map<String, List<String>> getTablesInclusionListMap() {
        return this.tablesInclusionListMap;
    }

    public void setTablesInclusionListMap(Map<String, List<String>> tablesInclusionListMap) {
        this.tablesInclusionListMap = tablesInclusionListMap;
    }

    public Map<String, List<String>> getTablesExclusionListMap() {
        return this.tablesExclusionListMap;
    }

    public void setTablesExclusionListMap(Map<String, List<String>> tablesExclusionListMap) {
        this.tablesExclusionListMap = tablesExclusionListMap;
    }
}

