/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.bootstrap.mysql.eventprocessor;

import com.flipkart.aesop.bootstrap.mysql.eventlistener.OpenReplicationListener;
import com.flipkart.aesop.bootstrap.mysql.eventprocessor.BinLogEventProcessor;
import com.flipkart.aesop.event.AbstractEvent;
import com.google.code.or.common.glossary.Row;
import com.linkedin.databus.core.DbusOpcode;
import com.linkedin.databus2.schemas.VersionedSchema;
import java.util.ArrayList;
import java.util.List;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBinLogEventProcessor
implements BinLogEventProcessor {
    public static final Logger LOGGER = LogFactory.getLogger(AbstractBinLogEventProcessor.class);

    protected List<AbstractEvent> map(long tableId, List<Row> rowList, OpenReplicationListener listener, DbusOpcode dbusOpcode) {
        String tableName = listener.getTableIdtoNameMapping().get(tableId);
        return this.map(tableName, rowList, listener, dbusOpcode);
    }

    protected List<AbstractEvent> map(String tableName, List<Row> rowList, OpenReplicationListener openReplicationListener, DbusOpcode dbusOpcode) {
        ArrayList<AbstractEvent> sourceEvents = new ArrayList<AbstractEvent>();
        try {
            if (openReplicationListener.getInterestedSourceList().contains(tableName)) {
                VersionedSchema schema = openReplicationListener.getSchemaRegistryService().fetchLatestVersionedSchemaBySourceName(openReplicationListener.getTableUriToSrcNameMap().get(tableName));
                for (Row row : rowList) {
                    Object abstractEvent = openReplicationListener.getBinLogEventMapper().mapBinLogEvent(row, schema.getSchema(), dbusOpcode);
                    sourceEvents.add((AbstractEvent)abstractEvent);
                }
            } else {
                LOGGER.info("Event received form uninterested source");
            }
        }
        catch (Exception ex) {
            LOGGER.error("Exception : ", (Throwable)ex);
        }
        return sourceEvents;
    }
}

