/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.bootstrap.mysql.eventprocessor.impl;

import com.flipkart.aesop.bootstrap.mysql.eventlistener.OpenReplicationListener;
import com.flipkart.aesop.bootstrap.mysql.eventprocessor.BinLogEventProcessor;
import com.flipkart.aesop.bootstrap.mysql.txnprocessor.MysqlTransactionManager;
import com.google.code.or.binlog.BinlogEventV4;
import com.google.code.or.binlog.impl.event.RotateEvent;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class RotateEventProcessor
implements BinLogEventProcessor {
    private static final Logger LOGGER = LogFactory.getLogger(RotateEventProcessor.class);

    @Override
    public void process(BinlogEventV4 event, OpenReplicationListener listener) throws Exception {
        MysqlTransactionManager manager = listener.getMysqlTransactionManager();
        if (!manager.isBeginTxnSeen()) {
            LOGGER.warn("Skipping event (" + event + ") as this is before the start of first transaction");
            return;
        }
        RotateEvent rotateEvent = (RotateEvent)event;
        String fileName = rotateEvent.getBinlogFileName().toString();
        LOGGER.info("File Rotated : FileName :" + fileName + ", BinlogFilePrefix :" + listener.getBinLogPrefix());
        String fileNumStr = fileName.substring(fileName.lastIndexOf(listener.getBinLogPrefix()) + listener.getBinLogPrefix().length() + 1);
        manager.setCurrFileNum(Integer.parseInt(fileNumStr));
    }
}

