/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.bootstrap.mysql.eventprocessor.impl;

import com.flipkart.aesop.bootstrap.mysql.eventlistener.OpenReplicationListener;
import com.flipkart.aesop.bootstrap.mysql.eventprocessor.BinLogEventProcessor;
import com.flipkart.aesop.bootstrap.mysql.txnprocessor.MysqlTransactionManager;
import com.google.code.or.binlog.BinlogEventV4;
import com.google.code.or.binlog.impl.event.UpdateRowsEvent;
import com.google.code.or.common.glossary.Pair;
import com.google.code.or.common.glossary.Row;
import com.linkedin.databus.core.DbusOpcode;
import java.util.ArrayList;
import java.util.List;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class UpdateEventProcessor
implements BinLogEventProcessor {
    private static final Logger LOGGER = LogFactory.getLogger(UpdateEventProcessor.class);

    public void process(BinlogEventV4 event, OpenReplicationListener listener) throws Exception {
        MysqlTransactionManager manager = listener.getMysqlTransactionManager();
        if (!manager.isBeginTxnSeen()) {
            LOGGER.warn("Skipping event (" + event + ") as this is before the start of first transaction");
            return;
        }
        LOGGER.debug("Update Event Received : " + event);
        UpdateRowsEvent updateRowsEvent = (UpdateRowsEvent)event;
        List listOfPairs = updateRowsEvent.getRows();
        ArrayList<Row> rowList = new ArrayList<Row>(listOfPairs.size());
        for (Pair pair : listOfPairs) {
            Row row = (Row)pair.getAfter();
            rowList.add(row);
        }
        manager.performChanges(updateRowsEvent.getTableId(), updateRowsEvent.getHeader(), rowList, DbusOpcode.UPSERT);
        LOGGER.debug("Update Successful for  " + event.getHeader().getEventLength() + " . Data updated : " + rowList);
    }
}

