/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.event;

import com.flipkart.aesop.event.AbstractEvent;
import com.flipkart.aesop.event.EventFactory;
import com.flipkart.aesop.utils.AvroToMysqlMapper;
import com.flipkart.aesop.utils.MysqlDataTypes;
import com.linkedin.databus.client.pub.DbusEventDecoder;
import com.linkedin.databus.core.DbusEvent;
import com.linkedin.databus.core.DbusOpcode;
import com.linkedin.databus2.core.DatabusException;
import com.linkedin.databus2.schemas.VersionedSchema;
import com.linkedin.databus2.schemas.utils.SchemaHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEventFactory<T extends AbstractEvent>
implements EventFactory {
    public static String PRIMARY_KEY_FIELD_NAME = "pk";
    public static String META_FIELD_TYPE_NAME = "dbFieldType";

    private Set<String> getPrimaryKeysSetFromSchema(Schema schema) throws DatabusException {
        HashSet<String> primaryKeySet = new HashSet<String>();
        String primaryKeyFieldName = SchemaHelper.getMetaField((Schema)schema, (String)PRIMARY_KEY_FIELD_NAME);
        if (primaryKeyFieldName == null) {
            throw new DatabusException("No primary key specified in the schema");
        }
        String[] stringArray = primaryKeyFieldName.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String primaryKey = stringArray[n2];
            primaryKeySet.add(primaryKey.trim());
            ++n2;
        }
        assert (primaryKeySet.size() >= 1);
        return primaryKeySet;
    }

    @Override
    public AbstractEvent createEvent(DbusEvent dbusEvent, DbusEventDecoder eventDecoder) throws DatabusException {
        GenericRecord genericRecord = eventDecoder.getGenericRecord(dbusEvent, null);
        VersionedSchema writerSchema = eventDecoder.getPayloadSchema(dbusEvent);
        Schema schema = writerSchema.getSchema();
        DbusOpcode eventType = dbusEvent.getOpcode();
        Set<String> primaryKeysSet = this.getPrimaryKeysSetFromSchema(schema);
        String namespaceName = schema.getNamespace();
        String entityName = schema.getName();
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        for (Schema.Field field : schema.getFields()) {
            String mysqlType = SchemaHelper.getMetaField((Schema.Field)field, (String)META_FIELD_TYPE_NAME);
            fieldMap.put(field.name(), AvroToMysqlMapper.avroToMysqlType(genericRecord.get(field.name()), MysqlDataTypes.valueOf(mysqlType.toUpperCase())));
        }
        AbstractEvent event = this.createEventInstance(fieldMap, primaryKeysSet, entityName, namespaceName, eventType);
        return event;
    }

    protected abstract AbstractEvent createEventInstance(Map<String, Object> var1, Set<String> var2, String var3, String var4, DbusOpcode var5);

    @Override
    public AbstractEvent createEvent(Schema schema, Map<String, Object> keyValuePairs, DbusOpcode eventType) throws DatabusException {
        String entityName = schema.getName();
        String namespaceName = schema.getNamespace();
        Set<String> primaryKeysSet = this.getPrimaryKeysSetFromSchema(schema);
        AbstractEvent event = this.createEventInstance(keyValuePairs, primaryKeysSet, entityName, namespaceName, eventType);
        return event;
    }

    @Override
    public AbstractEvent createEvent(Map<String, Object> fieldsMap, Set<String> primaryFieldsSet, String entityName, String namespaceName, DbusOpcode eventType) {
        AbstractEvent event = this.createEventInstance(fieldsMap, primaryFieldsSet, entityName, namespaceName, eventType);
        return event;
    }
}

