/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.eventconsumer.implementation;

import com.flipkart.aesop.destinationoperation.DestinationStoreOperation;
import com.flipkart.aesop.event.AbstractEvent;
import com.flipkart.aesop.event.EventFactory;
import com.flipkart.aesop.eventconsumer.AbstractEventConsumer;
import com.flipkart.aesop.mapper.Mapper;
import com.linkedin.databus.client.pub.ConsumerCallbackResult;
import com.linkedin.databus.client.pub.DbusEventDecoder;
import com.linkedin.databus.core.DbusEvent;
import com.linkedin.databus.core.DbusOpcode;
import com.linkedin.databus2.core.DatabusException;
import java.util.List;
import java.util.Map;
import javax.naming.OperationNotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEventConsumerImpl
extends AbstractEventConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultEventConsumerImpl.class);

    private DefaultEventConsumerImpl(Builder builder) {
        this.mapper = builder.getMapper();
        this.sourceEventFactory = builder.getSourceEventFactory();
        this.destinationOperationsMap = builder.getDestinationOperationsMap();
        this.destinationGroupSet = builder.getDestinationGroupSet();
        this.totalDestinationGroups = builder.getTotalDestinationGroups();
    }

    public AbstractEvent decodeSourceEvent(DbusEvent dbusEvent, DbusEventDecoder eventDecoder) throws DatabusException {
        AbstractEvent event = this.sourceEventFactory.createEvent(dbusEvent, eventDecoder);
        return event;
    }

    public ConsumerCallbackResult processSourceEvent(AbstractEvent event) {
        List<AbstractEvent> destinationEventList = this.mapper.mapSourceEventToDestinationEvent(event, this.destinationGroupSet, this.totalDestinationGroups);
        for (AbstractEvent destinationEvent : destinationEventList) {
            DestinationStoreOperation destinationStoreOperation = (DestinationStoreOperation)this.destinationOperationsMap.get(destinationEvent.getEventType());
            try {
                destinationStoreOperation.execute(destinationEvent);
            }
            catch (OperationNotSupportedException e) {
                LOGGER.error("Operation Not Supported Exception occured while executing Destination Store Operation.", (Throwable)e);
            }
        }
        return ConsumerCallbackResult.SUCCESS;
    }

    /* synthetic */ DefaultEventConsumerImpl(Builder builder, DefaultEventConsumerImpl defaultEventConsumerImpl) {
        this(builder);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    extends AbstractEventConsumer.Builder<DefaultEventConsumerImpl> {
        public Builder(EventFactory sourceEventFactory, Mapper mapper, Map<DbusOpcode, ? extends DestinationStoreOperation> destinationOperationsMap) {
            super(sourceEventFactory, mapper, destinationOperationsMap);
        }

        @Override
        public DefaultEventConsumerImpl build() {
            return new DefaultEventConsumerImpl(this, null);
        }
    }
}

