/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.eventconsumer;

import com.flipkart.aesop.eventconsumer.AbstractEventConsumer;
import com.flipkart.aesop.eventconsumer.EventConsumerFactoryBean;
import com.linkedin.databus.client.pub.DatabusCombinedConsumer;
import com.linkedin.databus.client.pub.DbusClusterConsumerFactory;
import com.linkedin.databus.client.pub.DbusClusterInfo;
import com.linkedin.databus.client.pub.DbusPartitionInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerFactory
implements DbusClusterConsumerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerFactory.class);
    List<? extends EventConsumerFactoryBean<? extends AbstractEventConsumer>> eventConsumerFactoryList;
    Integer totalDestinationGroups;

    public Collection<DatabusCombinedConsumer> createPartitionedConsumers(DbusClusterInfo clusterInfo, DbusPartitionInfo partitionInfo) {
        ArrayList<AbstractEventConsumer> consumerList = new ArrayList<AbstractEventConsumer>();
        for (EventConsumerFactoryBean<? extends AbstractEventConsumer> eventConsumerFactoryBean : this.eventConsumerFactoryList) {
            AbstractEventConsumer eventConsumer = eventConsumerFactoryBean.getObject();
            consumerList.add(eventConsumer);
        }
        boolean bl = true;
        if (this.totalDestinationGroups == null) {
            int n;
            for (AbstractEventConsumer eventConsumer : consumerList) {
                n = Math.max(n, this.getMaxGroupNo(eventConsumer.getDestinationGroupSet()));
            }
            this.totalDestinationGroups = n;
        }
        for (AbstractEventConsumer eventConsumer : consumerList) {
            eventConsumer.setTotalDestinationGroups(this.totalDestinationGroups);
        }
        return new ArrayList<DatabusCombinedConsumer>(consumerList);
    }

    private int getMaxGroupNo(Set<Integer> destinationGroupSet) {
        int maxDestinationGroupNo = 0;
        for (Integer destinationGroupNo : destinationGroupSet) {
            maxDestinationGroupNo = Math.max(maxDestinationGroupNo, destinationGroupNo);
        }
        return maxDestinationGroupNo;
    }

    public void setEventConsumerFactoryList(List<? extends EventConsumerFactoryBean<? extends AbstractEventConsumer>> eventConsumerFactoryList) {
        this.eventConsumerFactoryList = eventConsumerFactoryList;
    }

    public void setTotalDestinationGroups(Integer totalDestinationGroups) {
        this.totalDestinationGroups = totalDestinationGroups;
    }
}

