/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.eventconsumer;

import com.flipkart.aesop.eventconsumer.AbstractEventConsumer;
import com.flipkart.aesop.eventconsumer.EventConsumerFactoryBean;
import com.linkedin.databus.client.pub.DatabusCombinedConsumer;
import com.linkedin.databus.client.pub.DbusClusterConsumerFactory;
import com.linkedin.databus.client.pub.DbusClusterInfo;
import com.linkedin.databus.client.pub.DbusPartitionInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsumerFactory
implements DbusClusterConsumerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerFactory.class);
    List<? extends EventConsumerFactoryBean<? extends AbstractEventConsumer>> eventConsumerFactoryList;
    Integer totalDestinationGroups;

    public Collection<DatabusCombinedConsumer> createPartitionedConsumers(DbusClusterInfo clusterInfo, DbusPartitionInfo partitionInfo) {
        ArrayList<AbstractEventConsumer> consumerList = new ArrayList<AbstractEventConsumer>();
        for (EventConsumerFactoryBean<? extends AbstractEventConsumer> eventConsumerFactoryBean : this.eventConsumerFactoryList) {
            AbstractEventConsumer eventConsumer = eventConsumerFactoryBean.getObject();
            consumerList.add(eventConsumer);
        }
        int maxGroupSpecified = 1;
        if (this.totalDestinationGroups == null) {
            for (AbstractEventConsumer eventConsumer : consumerList) {
                maxGroupSpecified = Math.max(maxGroupSpecified, this.getMaxGroupNo(eventConsumer.getDestinationGroupSet()));
            }
            this.totalDestinationGroups = maxGroupSpecified;
        }
        for (AbstractEventConsumer eventConsumer : consumerList) {
            eventConsumer.setTotalDestinationGroups(this.totalDestinationGroups);
        }
        return new ArrayList<DatabusCombinedConsumer>(consumerList);
    }

    private int getMaxGroupNo(Set<Integer> destinationGroupSet) {
        int maxDestinationGroupNo = 0;
        for (Integer destinationGroupNo : destinationGroupSet) {
            maxDestinationGroupNo = Math.max(maxDestinationGroupNo, destinationGroupNo);
        }
        return maxDestinationGroupNo;
    }

    public void setEventConsumerFactoryList(List<? extends EventConsumerFactoryBean<? extends AbstractEventConsumer>> eventConsumerFactoryList) {
        this.eventConsumerFactoryList = eventConsumerFactoryList;
    }

    public void setTotalDestinationGroups(Integer totalDestinationGroups) {
        this.totalDestinationGroups = totalDestinationGroups;
    }
}

