/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.elasticsearchdatalayer.config;

import com.flipkart.aesop.elasticsearchdatalayer.config.ElasticSearchConfig;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.List;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.StringUtils;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class ElasticSearchDataLayerClient
implements InitializingBean {
    private static final Logger LOGGER = LogFactory.getLogger(ElasticSearchDataLayerClient.class);
    private Client client;
    private ElasticSearchConfig elasticSearchConfig;
    private Config config;

    private void init() {
        String hostname;
        this.config = ConfigFactory.parseFile((File)new File(this.elasticSearchConfig.getConfig()));
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOGGER.info("Unknown HostException Thrown - UpsertDatalayer");
            throw new RuntimeException("FATAL Error: Unable To get Host Information");
        }
        List hosts = this.config.getStringList("hosts");
        hosts.remove(hostname + ":9300");
        String hostListStr = StringUtils.collectionToDelimitedString((Collection)hosts, (String)",");
        LOGGER.info("HOST LIST : {} ", (Object)hostListStr);
        ImmutableSettings.Builder settings = ImmutableSettings.settingsBuilder().put("cluster.name", this.config.getString("cluster.name")).put("node.name", hostname.replace('.', '-')).put("network.host", hostname).put("node.data", false).put("node.local", false);
        Node node = NodeBuilder.nodeBuilder().clusterName(this.config.getString("cluster.name")).client(true).local(false).settings((Settings.Builder)settings).node();
        node.start();
        this.client = node.client();
    }

    public void afterPropertiesSet() throws Exception {
        this.init();
    }

    public ElasticSearchConfig getElasticSearchConfig() {
        return this.elasticSearchConfig;
    }

    public void setElasticSearchConfig(ElasticSearchConfig elasticSearchConfig) {
        this.elasticSearchConfig = elasticSearchConfig;
    }

    public String getIndex() {
        return this.config.getString("cluster.index");
    }

    public String getType() {
        return this.config.getString("cluster.type");
    }

    public Client getClient() {
        return this.client;
    }
}

