/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.elasticsearchdatalayer.upsert;

import com.flipkart.aesop.destinationoperation.UpsertDestinationStoreOperation;
import com.flipkart.aesop.elasticsearchdatalayer.elasticsearchclient.ElasticSearchClient;
import com.flipkart.aesop.event.AbstractEvent;
import java.util.Map;
import org.elasticsearch.action.index.IndexResponse;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElasticSearchUpsertDataLayer
extends UpsertDestinationStoreOperation {
    private static final Logger LOGGER = LogFactory.getLogger(ElasticSearchUpsertDataLayer.class);
    private ElasticSearchClient elasticSearchClient;

    protected void upsert(AbstractEvent event) {
        LOGGER.info("Received Upsert Event. Event is " + event);
        LOGGER.info("Field Map Pair : " + event.getFieldMapPair().toString());
        try {
            String id = String.valueOf(event.getFieldMapPair().get("id"));
            this.elasticSearchClient.getClient().prepareDelete(this.elasticSearchClient.getIndex(), this.elasticSearchClient.getType(), id).execute().actionGet();
            IndexResponse response = (IndexResponse)this.elasticSearchClient.getClient().prepareIndex(this.elasticSearchClient.getIndex(), this.elasticSearchClient.getType(), id).setSource(this.transform(event.getFieldMapPair())).execute().get();
            if (!response.isCreated()) {
                LOGGER.info("Create Error : " + response);
                throw new RuntimeException("Create Failure");
            }
        }
        catch (Exception e) {
            LOGGER.info("Server Connection Lost/Create Error" + e);
            throw new RuntimeException("Create Failure");
        }
    }

    protected Map<String, Object> transform(Map<String, Object> input) {
        return input;
    }

    public void setElasticSearchClient(ElasticSearchClient elasticSearchClient) {
        this.elasticSearchClient = elasticSearchClient;
    }

    public ElasticSearchClient getElasticSearchClient() {
        return this.elasticSearchClient;
    }
}

