/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.processor.es.upsert;

import com.flipkart.aesop.destinationoperation.UpsertDestinationStoreProcessor;
import com.flipkart.aesop.event.AbstractEvent;
import com.flipkart.aesop.processor.es.client.ElasticSearchClient;
import com.linkedin.databus.client.pub.ConsumerCallbackResult;
import org.elasticsearch.action.index.IndexResponse;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class ElasticSearchUpsertProcessor
extends UpsertDestinationStoreProcessor {
    private static final Logger LOGGER = LogFactory.getLogger(ElasticSearchUpsertProcessor.class);
    private ElasticSearchClient elasticSearchClient;

    protected ConsumerCallbackResult upsert(AbstractEvent event) {
        LOGGER.info("Received Upsert Event. Event is " + event);
        LOGGER.info("Field Map Pair : " + event.getFieldMapPair().toString());
        try {
            String id = String.valueOf(event.getFieldMapPair().get("id"));
            this.elasticSearchClient.getClient().prepareDelete(this.elasticSearchClient.getIndex(), this.elasticSearchClient.getType(), id).execute().actionGet();
            IndexResponse response = (IndexResponse)this.elasticSearchClient.getClient().prepareIndex(this.elasticSearchClient.getIndex(), this.elasticSearchClient.getType(), id).setSource(event.getFieldMapPair()).execute().get();
            if (!response.isCreated()) {
                LOGGER.info("Create Error : " + response);
                throw new RuntimeException("Create Failure");
            }
        }
        catch (Exception e) {
            LOGGER.info("Server Connection Lost/Create Error" + e);
            throw new RuntimeException("Create Failure");
        }
        return ConsumerCallbackResult.SUCCESS;
    }

    public void setElasticSearchClient(ElasticSearchClient elasticSearchClient) {
        this.elasticSearchClient = elasticSearchClient;
    }

    public ElasticSearchClient getElasticSearchClient() {
        return this.elasticSearchClient;
    }
}

