/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.processor.es.client;

import com.flipkart.aesop.processor.es.client.ElasticSearchClient;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class ElasticSearchTransportClient
extends ElasticSearchClient {
    private static final Logger LOGGER = LogFactory.getLogger(ElasticSearchTransportClient.class);

    void init() {
        String hostname;
        this.config = ConfigFactory.parseFile((File)new File(this.elasticSearchConfig.getConfig()));
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOGGER.info("Unknown HostException Thrown - UpsertDatalayer");
            throw new RuntimeException("FATAL Error: Unable To get Host Information");
        }
        ImmutableSettings.Builder settings = ImmutableSettings.settingsBuilder().put("cluster.name", this.config.getString("cluster.name")).put("node.name", hostname.replace('.', '-')).put("network.host", hostname).put("node.data", false).put("node.local", false).put("network.host", hostname).put("client.transport.sniff", this.config.getString("isTransportSniff"));
        TransportClient client = new TransportClient((Settings.Builder)settings);
        for (Config confItem : this.config.getConfigList("transport.hosts")) {
            client.addTransportAddress((TransportAddress)new InetSocketTransportAddress(confItem.getString("host"), confItem.getInt("port")));
        }
        this.client = client;
    }
}

