/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.hbasedatalayer.delete;

import com.flipkart.aesop.destinationoperation.DeleteDestinationStoreProcessor;
import com.flipkart.aesop.destinationoperation.JDBCDataLayer;
import com.flipkart.aesop.destinationoperation.utils.DataLayerHelper;
import com.flipkart.aesop.event.AbstractEvent;
import com.flipkart.aesop.hbasedatalayer.upsert.HBaseUpsertDataLayer;
import com.linkedin.databus.client.pub.ConsumerCallbackResult;
import java.util.Map;
import java.util.Set;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class HBaseDeleteDataLayer
extends DeleteDestinationStoreProcessor
implements JDBCDataLayer {
    public static final Logger LOGGER = LogFactory.getLogger(HBaseUpsertDataLayer.class);
    private Map<String, NamedParameterJdbcTemplate> jdbcTemplateMap;

    public HBaseDeleteDataLayer(Map<String, NamedParameterJdbcTemplate> jdbcTemplateMap) {
        this.jdbcTemplateMap = jdbcTemplateMap;
    }

    public Map<String, NamedParameterJdbcTemplate> getJdbcTemplateMap() {
        return this.jdbcTemplateMap;
    }

    protected ConsumerCallbackResult delete(AbstractEvent event) {
        String deleteQuery = this.generateDeleteQuery(event);
        NamedParameterJdbcTemplate jdbcTemplate = this.jdbcTemplateMap.get(event.getNamespaceName());
        Map nullValueColumnMapping = DataLayerHelper.generateColumnMappingWithNullValues((Map)event.getFieldMapPair(), (Set)event.getPrimaryKeySet());
        jdbcTemplate.update(deleteQuery, nullValueColumnMapping);
        return ConsumerCallbackResult.SUCCESS;
    }

    private String generateDeleteQuery(AbstractEvent event) {
        StringBuilder columnNameStringBuilder = new StringBuilder();
        StringBuilder placeholderStringBuilder = new StringBuilder();
        this.populateQueryParts(event.getFieldMapPair(), columnNameStringBuilder, placeholderStringBuilder);
        return this.buildQuery(event.getNamespaceName(), event.getEntityName(), columnNameStringBuilder, placeholderStringBuilder);
    }

    private String buildQuery(String namespace, String entity, StringBuilder columnNameStringBuilder, StringBuilder placeholderStringBuilder) {
        StringBuilder upsertQuery = new StringBuilder();
        upsertQuery.append("UPSERT INTO ");
        if (namespace != null && !"".equals(namespace)) {
            upsertQuery.append(String.valueOf(namespace) + ".");
        }
        upsertQuery.append(String.valueOf(entity) + "(");
        upsertQuery.append(columnNameStringBuilder.substring(0, columnNameStringBuilder.length() - 1));
        upsertQuery.append(") VALUES(");
        upsertQuery.append(placeholderStringBuilder.substring(0, placeholderStringBuilder.length() - 1));
        upsertQuery.append(")");
        return upsertQuery.toString();
    }

    private void populateQueryParts(Map<String, Object> fieldMap, StringBuilder columnNameStringBuilder, StringBuilder placeholderStringBuilder) {
        for (String columnName : fieldMap.keySet()) {
            columnNameStringBuilder.append(String.valueOf(columnName) + ",");
            placeholderStringBuilder.append(":" + columnName + ",");
        }
    }
}

