/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.processor.kafka.client;

import com.flipkart.aesop.processor.kafka.config.KafkaConfig;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.util.Properties;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.springframework.beans.factory.InitializingBean;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class KafkaClient
implements InitializingBean {
    protected KafkaConfig kafkaConfig;
    protected Config config;
    protected KafkaProducer client;
    private static final Logger LOGGER = LogFactory.getLogger(KafkaClient.class);

    void init() {
        this.config = ConfigFactory.parseFile((File)new File(this.kafkaConfig.getConfig()));
        Properties props = new Properties();
        props.put("zookeeper.connect", this.config.getString("zookeeper.connect"));
        props.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        props.put("key.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        props.put("zk.connectiontimeout.ms", this.config.getString("zk.connectiontimeout.ms"));
        props.put("bootstrap.servers", this.config.getString("bootstrap.servers"));
        this.client = new KafkaProducer(props);
    }

    public void afterPropertiesSet() throws Exception {
        this.init();
    }

    public KafkaConfig getKafkaConfig() {
        return this.kafkaConfig;
    }

    public void setKafkaConfig(KafkaConfig kafkaConfig) {
        this.kafkaConfig = kafkaConfig;
    }

    public KafkaProducer getClient() {
        return this.client;
    }
}

