/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.processor.kafka.processor;

import com.flipkart.aesop.event.AbstractEvent;
import com.flipkart.aesop.processor.DestinationEventProcessor;
import com.flipkart.aesop.processor.kafka.client.KafkaClient;
import com.flipkart.aesop.processor.kafka.producer.adaptor.ProducerRecordAdaptor;
import com.linkedin.databus.client.pub.ConsumerCallbackResult;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public abstract class KafkaEventProcessor
implements DestinationEventProcessor {
    protected KafkaClient kafkaClient;
    protected static final Logger LOGGER = LogFactory.getLogger(KafkaEventProcessor.class);
    private ProducerRecordAdaptor producerRecordAdaptor;

    public ConsumerCallbackResult processDestinationEvent(AbstractEvent event) {
        LOGGER.info("Received Abstract Event. Event is " + event);
        try {
            return this.submitRecord(this.producerRecordAdaptor.createProducerRecord(event));
        }
        catch (Exception e) {
            LOGGER.error("Kafka Server Connection Lost/Send Error" + e);
            return ConsumerCallbackResult.ERROR;
        }
    }

    public abstract ConsumerCallbackResult submitRecord(ProducerRecord var1) throws Exception;

    public ProducerRecordAdaptor getProducerRecordAdaptor() {
        return this.producerRecordAdaptor;
    }

    public void setProducerRecordAdaptor(ProducerRecordAdaptor producerRecordAdaptor) {
        this.producerRecordAdaptor = producerRecordAdaptor;
    }

    public void setKafkaClient(KafkaClient kafkaClient) {
        this.kafkaClient = kafkaClient;
    }

    public KafkaClient getKafkaClient() {
        return this.kafkaClient;
    }
}

