/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.mysqldatalayer.delete;

import com.flipkart.aesop.destinationoperation.DeleteDestinationStoreProcessor;
import com.flipkart.aesop.destinationoperation.JDBCDataLayer;
import com.flipkart.aesop.destinationoperation.utils.DataLayerHelper;
import com.flipkart.aesop.event.AbstractEvent;
import java.util.Map;
import java.util.Set;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySQLDeleteDataLayer
extends DeleteDestinationStoreProcessor
implements JDBCDataLayer {
    private Map<String, NamedParameterJdbcTemplate> jdbcTemplateMap;

    public MySQLDeleteDataLayer(Map<String, NamedParameterJdbcTemplate> jdbcTemplateMap) {
        this.jdbcTemplateMap = jdbcTemplateMap;
    }

    public Map<String, NamedParameterJdbcTemplate> getJdbcTemplateMap() {
        return this.jdbcTemplateMap;
    }

    protected void delete(AbstractEvent event) {
        String deleteQuery = this.getDeleteQuery(event);
        NamedParameterJdbcTemplate jdbcTemplate = this.jdbcTemplateMap.get(event.getNamespaceName());
        Map nullValueColumnMapping = DataLayerHelper.generateColumnMappingWithNullValues((Map)event.getFieldMapPair(), (Set)event.getPrimaryKeySet());
        jdbcTemplate.update(deleteQuery, nullValueColumnMapping);
    }

    private String getDeleteQuery(AbstractEvent event) {
        StringBuilder updateClauseStringBuilder = new StringBuilder();
        StringBuilder whereClauseStringbuilder = new StringBuilder();
        this.populateDeleteQueryParts(event.getFieldMapPair(), event.getPrimaryKeySet(), updateClauseStringBuilder, whereClauseStringbuilder);
        return this.buildQuery(event.getNamespaceName(), event.getEntityName(), updateClauseStringBuilder, whereClauseStringbuilder);
    }

    private void populateDeleteQueryParts(Map<String, Object> fieldMap, Set<String> primaryKeySet, StringBuilder updateClauseStringBuilder, StringBuilder whereClauseStringbuilder) {
        for (String columnName : fieldMap.keySet()) {
            if (!primaryKeySet.contains(columnName)) {
                updateClauseStringBuilder.append(columnName + "=:" + columnName + ",");
                continue;
            }
            whereClauseStringbuilder.append(columnName + "=:" + columnName + " AND ");
        }
    }

    private String buildQuery(String namespace, String entity, StringBuilder updateClauseStringBuilder, StringBuilder whereClauseStringbuilder) {
        StringBuilder deleteQuery = new StringBuilder();
        deleteQuery.append("UPDATE ");
        deleteQuery.append(namespace + "." + entity);
        deleteQuery.append(" SET ");
        deleteQuery.append(updateClauseStringBuilder.substring(0, updateClauseStringBuilder.length() - 1));
        deleteQuery.append(" WHERE ");
        deleteQuery.append(whereClauseStringbuilder.substring(0, whereClauseStringbuilder.length() - 5));
        return deleteQuery.toString();
    }
}

