/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.serializer.stateengine;

import com.flipkart.aesop.runtime.producer.ReadEventCycleSummary;
import com.flipkart.aesop.serializer.stateengine.DiffChangeEventMapper;
import com.netflix.zeno.diff.DiffSerializationFramework;
import com.netflix.zeno.diff.TypeDiff;
import com.netflix.zeno.diff.TypeDiffInstruction;
import com.netflix.zeno.diff.TypeDiffOperation;
import com.netflix.zeno.fastblob.FastBlobStateEngine;
import com.netflix.zeno.fastblob.state.TypeDeserializationStateListener;
import com.netflix.zeno.serializer.SerializerFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.generic.GenericRecord;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public abstract class DiffInterpreter<T, S extends GenericRecord>
implements InitializingBean {
    private static final Logger LOGGER = LogFactory.getLogger(DiffInterpreter.class);
    protected SerializerFactory serializerFactory;
    protected String serializedDataLocation;
    protected File serializedDataLocationDir;
    protected DiffChangeEventMapper<T, S> diffChangeEventMapper;
    private FastBlobStateEngine stateEngine;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.serializerFactory, (String)"'serializerFactory' cannot be null. This diff interpreter will not be initialized");
        Assert.notNull((Object)this.serializedDataLocation, (String)"'serializedDataLocation' cannot be null. This diff interpreter will not be initialized");
        Assert.notNull(this.diffChangeEventMapper, (String)"'diffChangeEventMapper' cannot be null. This diff interpreter will not be initialized");
        this.stateEngine = new FastBlobStateEngine(this.serializerFactory);
        this.serializedDataLocationDir = new File(this.serializedDataLocation);
    }

    public ReadEventCycleSummary<S> getChangeEvents(long sinceSCN) {
        if (this.stateEngine.getLatestVersion() == null || Long.valueOf(this.stateEngine.getLatestVersion()) < sinceSCN) {
            this.readSnapshotAndDeltasForSCN(this.stateEngine, sinceSCN);
        }
        DiffTypeDeserializationStateListener diffTypeDeserializationStateListener = new DiffTypeDeserializationStateListener();
        this.stateEngine.setTypeDeserializationStateListener(this.diffChangeEventMapper.getNFTypeName(), (TypeDeserializationStateListener)diffTypeDeserializationStateListener);
        this.readSnapshotAndDeltasAfterSCN(this.stateEngine, sinceSCN);
        DiffSerializationFramework diffSerializationFramework = new DiffSerializationFramework(this.serializerFactory);
        TypeDiffInstruction diffInstruction = new TypeDiffInstruction<T>(){

            public String getSerializerName() {
                return DiffInterpreter.this.diffChangeEventMapper.getNFTypeName();
            }

            public Object getKey(T object) {
                return DiffInterpreter.this.diffChangeEventMapper.getTypeKey(object);
            }
        };
        TypeDiffOperation diffOperation = new TypeDiffOperation(diffInstruction);
        LOGGER.info("Sizes of removed and added objects post diff : " + diffTypeDeserializationStateListener.getRemovedObjectsList().size() + "," + diffTypeDeserializationStateListener.getAddedObjectsList().size());
        TypeDiff typeDiff = diffOperation.performDiff(diffSerializationFramework, diffTypeDeserializationStateListener.getRemovedObjectsList(), diffTypeDeserializationStateListener.getAddedObjectsList());
        return new ReadEventCycleSummary(this.diffChangeEventMapper.getChangeEvents(typeDiff, this.serializerFactory), Long.valueOf(this.stateEngine.getLatestVersion()).longValue());
    }

    protected abstract void readSnapshotAndDeltasForSCN(FastBlobStateEngine var1, long var2);

    protected abstract void readSnapshotAndDeltasAfterSCN(FastBlobStateEngine var1, long var2);

    public void setSerializerFactory(SerializerFactory serializerFactory) {
        this.serializerFactory = serializerFactory;
    }

    public void setSerializedDataLocation(String serializedDataLocation) {
        this.serializedDataLocation = serializedDataLocation;
    }

    public String getSerializedDataLocation() {
        return this.serializedDataLocation;
    }

    public void setDiffChangeEventMapper(DiffChangeEventMapper<T, S> diffChangeEventMapper) {
        this.diffChangeEventMapper = diffChangeEventMapper;
    }

    public DiffChangeEventMapper<T, S> getDiffChangeEventMapper() {
        return this.diffChangeEventMapper;
    }

    private class DiffTypeDeserializationStateListener
    extends TypeDeserializationStateListener<T> {
        private List<T> addedObjectsList = new ArrayList();
        private List<T> removedObjectsList = new ArrayList();

        private DiffTypeDeserializationStateListener() {
        }

        public void addedObject(T object, int ordinal) {
            this.addedObjectsList.add(object);
        }

        public void removedObject(T object, int ordinal) {
            this.removedObjectsList.add(object);
        }

        public void reassignedObject(T object, int oldOrdinal, int newOrdinal) {
        }

        public List<T> getAddedObjectsList() {
            return this.addedObjectsList;
        }

        public List<T> getRemovedObjectsList() {
            return this.removedObjectsList;
        }
    }
}

