/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.serializer.stateengine;

import com.flipkart.aesop.serializer.stateengine.DiffInterpreter;
import com.netflix.zeno.fastblob.FastBlobStateEngine;
import com.netflix.zeno.fastblob.io.FastBlobReader;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.apache.avro.generic.GenericRecord;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class DailyDiffInterpreter<T, S extends GenericRecord>
extends DiffInterpreter<T, S> {
    private static final Logger LOGGER = LogFactory.getLogger(DailyDiffInterpreter.class);

    @Override
    protected void readSnapshotAndDeltasForSCN(FastBlobStateEngine stateEngine, long sinceSCN) {
        this.readSnapshotAndDeltas(stateEngine, sinceSCN, true);
    }

    @Override
    protected void readSnapshotAndDeltasAfterSCN(FastBlobStateEngine stateEngine, long sinceSCN) {
        this.readSnapshotAndDeltas(stateEngine, sinceSCN, false);
    }

    private void readSnapshotAndDeltas(FastBlobStateEngine stateEngine, final long sinceSCN, final boolean limitToSCN) {
        File[] stateDirs = this.serializedDataLocationDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (new File(dir, name).isDirectory()) {
                    if (limitToSCN) {
                        return Long.valueOf(name) <= DailyDiffInterpreter.this.getSCNDay(sinceSCN);
                    }
                    return Long.valueOf(name) >= DailyDiffInterpreter.this.getSCNDay(sinceSCN);
                }
                return false;
            }
        });
        if (stateDirs.length == 0) {
            return;
        }
        Arrays.sort(stateDirs, Collections.reverseOrder(new Comparator<File>(){

            @Override
            public int compare(File file1, File file2) {
                return (int)(file1.lastModified() - file2.lastModified());
            }
        }));
        FastBlobReader stateReader = new FastBlobReader(stateEngine);
        File[] fileArray = stateDirs;
        int n = stateDirs.length;
        int n2 = 0;
        while (n2 < n) {
            File[] stateFiles;
            File stateDir = fileArray[n2];
            File[] fileArray2 = stateFiles = stateDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    if (name.endsWith("snapshot") || name.endsWith("delta")) {
                        LOGGER.debug("State file version : SCN [" + DailyDiffInterpreter.this.getStateFileVersion(new File(dir, name)) + " : " + sinceSCN + "]");
                        if (limitToSCN) {
                            return DailyDiffInterpreter.this.getStateFileVersion(new File(dir, name)) <= sinceSCN;
                        }
                        return DailyDiffInterpreter.this.getStateFileVersion(new File(dir, name)) >= sinceSCN;
                    }
                    return false;
                }
            });
            int n3 = stateFiles.length;
            int n4 = 0;
            while (n4 < n3) {
                File stateFile = fileArray2[n4];
                try {
                    LOGGER.debug("State file version : engine version [" + this.getStateFileVersion(stateFile) + " : " + this.getStateEngineVersion(stateEngine) + "] State file is " + stateFile.getAbsolutePath());
                    if (this.getStateFileVersion(stateFile) > this.getStateEngineVersion(stateEngine)) {
                        if (stateFile.getName().endsWith("snapshot")) {
                            stateReader.readSnapshot((InputStream)new DataInputStream(new BufferedInputStream(new FileInputStream(stateFile))));
                        } else {
                            stateReader.readDelta((InputStream)new DataInputStream(new BufferedInputStream(new FileInputStream(stateFile))));
                        }
                        stateEngine.setLatestVersion(String.valueOf(this.getStateFileVersion(stateFile)));
                        LOGGER.info("State engine initialized from state file : " + stateFile.getAbsolutePath());
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Error reading state file : " + stateFile.getAbsolutePath() + " Proceeding with next file. Error message is : " + e.getMessage(), (Throwable)e);
                }
                ++n4;
            }
            ++n2;
        }
        LOGGER.debug(this.getStateEngineVersion(stateEngine) != 0L ? "State engine is set to version : " + stateEngine.getLatestVersion() : "State engine not initialized from any existing snapshot");
    }

    private long getStateFileVersion(File stateFile) {
        return Long.valueOf(stateFile.getName().substring(0, "yyyyMMddHHmmss".length()));
    }

    private long getSCNDay(long sinceSCN) {
        return sinceSCN == 0L ? sinceSCN : Long.valueOf(String.valueOf(sinceSCN).substring(0, "yyyyMMdd".length()));
    }

    private long getStateEngineVersion(FastBlobStateEngine stateEngine) {
        return Long.valueOf(stateEngine.getLatestVersion() == null || stateEngine.getLatestVersion().trim().length() == 0 ? "0" : stateEngine.getLatestVersion());
    }
}

