/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.runtime.producer.schema.eventprocessor.impl;

import com.flipkart.aesop.avro.schemagenerator.main.SchemaGenerator;
import com.flipkart.aesop.runtime.producer.schema.eventprocessor.SchemaChangeEventProcessor;
import com.google.code.or.binlog.impl.event.QueryEvent;
import com.linkedin.databus2.schemas.FileSystemSchemaRegistryService;
import com.linkedin.databus2.schemas.SchemaRegistryService;
import com.linkedin.databus2.schemas.VersionedSchema;
import com.linkedin.databus2.schemas.VersionedSchemaId;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.avro.Schema;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class UpdateSchemaChangeEventProcessor
implements SchemaChangeEventProcessor {
    private static final Logger LOGGER = LogFactory.getLogger(UpdateSchemaChangeEventProcessor.class);
    private SchemaGenerator schemaGenerator;
    private SchemaRegistryService schemaRegistryService;
    private String schemaRegistryLocation;
    private Map<String, String> tableUriToSrcNameMap;
    private static final Pattern ALTER_TABLE_REGEX = Pattern.compile("(ALTER\\s+)(ONLINE\\s+|OFFLINE\\s+)?(IGNORE\\s+)?(TABLE\\s+)`(\\S+?)`.*", 2);

    @Override
    public void process(QueryEvent queryEvent) throws Exception {
        String sql = queryEvent.getSql().toString();
        Matcher matcher = ALTER_TABLE_REGEX.matcher(sql);
        if (!matcher.find() || matcher.group(5) == null) {
            throw new IllegalStateException("Failed to parse alter table sql");
        }
        String tableName = matcher.group(5);
        String databaseName = queryEvent.getDatabaseName().toString();
        String tableUri = databaseName.toLowerCase() + "." + tableName.toLowerCase();
        VersionedSchema olderSchema = this.schemaRegistryService.fetchLatestVersionedSchemaBySourceName(this.tableUriToSrcNameMap.get(tableUri));
        if (olderSchema != null) {
            this.process(databaseName, tableName);
        } else {
            LOGGER.info("Event recieved from uninterested source " + tableUri);
        }
    }

    @Override
    public void process(String databaseName, String tableName) throws Exception {
        String newSchemaJson = this.schemaGenerator.generateSchema(databaseName, tableName);
        String tableUri = databaseName.toLowerCase() + "." + tableName.toLowerCase();
        VersionedSchema olderSchema = this.schemaRegistryService.fetchLatestVersionedSchemaBySourceName(this.tableUriToSrcNameMap.get(tableUri));
        short olderVersion = olderSchema != null ? (short)olderSchema.getVersion() : (short)0;
        Short newVersion = olderVersion == Short.MAX_VALUE ? olderVersion : (short)(olderVersion + 1);
        VersionedSchema newSchema = new VersionedSchema(new VersionedSchemaId(this.tableUriToSrcNameMap.get(tableUri), newVersion.shortValue()), Schema.parse((String)newSchemaJson), null);
        this.schemaRegistryService.registerSchema(newSchema);
        if (SchemaRegistryService.class.isAssignableFrom(FileSystemSchemaRegistryService.class)) {
            String schemaFilePath = this.schemaRegistryLocation + File.separator + this.tableUriToSrcNameMap.get(tableUri) + "." + newVersion.toString() + ".avsc";
            File schemaFile = new File(schemaFilePath);
            if (schemaFile.exists()) {
                schemaFile.delete();
                schemaFile = new File(schemaFilePath);
            }
            schemaFile.createNewFile();
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(schemaFile.getAbsoluteFile()));
            bufferedWriter.write(newSchemaJson);
            bufferedWriter.close();
        }
    }

    @Override
    public void setSchemaRegistryService(SchemaRegistryService schemaRegistryService) {
        this.schemaRegistryService = schemaRegistryService;
    }

    @Override
    public void setTableUriToSrcNameMap(Map<String, String> tableUriToSrcNameMap) {
        this.tableUriToSrcNameMap = tableUriToSrcNameMap;
    }

    public void setSchemaGenerator(SchemaGenerator schemaGenerator) {
        this.schemaGenerator = schemaGenerator;
    }

    public void setSchemaRegistryLocation(String schemaRegistryLocation) {
        this.schemaRegistryLocation = schemaRegistryLocation;
    }
}

